/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockStaticLiquid
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176370_f" : "updateLiquid"), "updateLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_176368_m" : "getCanBlockBurn"), "getCanBlockBurn", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        return false;
    }

    public static final class Hooks {
        public static boolean getCanBlockBurn(@Nonnull World world, @Nonnull BlockPos pos) {
            if (world.func_189509_E(pos) || !world.func_175667_e(pos)) {
                return false;
            }
            Chunk chunk = world.func_175726_f(pos);
            if (!chunk.func_177435_g(pos).func_185904_a().func_76217_h()) {
                return false;
            }
            FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
            return fluidState == FluidState.EMPTY || fluidState.getMaterial().func_76217_h();
        }

        public static void updateLiquid(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            FluidState dynState = FluidState.of((Block)BlockLiquid.func_176361_a((Material)state.func_185904_a())).withLevel((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b));
            if (FluidState.get((IBlockAccess)worldIn, pos).isEmpty()) {
                worldIn.func_180501_a(pos, dynState.getState(), 22);
            } else {
                FluidloggedUtils.setFluidState(worldIn, pos, null, dynState, false, 22);
            }
            worldIn.func_175684_a(pos, dynState.getBlock(), dynState.getBlock().func_149738_a(worldIn));
        }
    }
}

