/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.entity;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidCollisionHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginEntity
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_180799_ab" : "isInLava")) {
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_70072_I" : "handleWaterMovement")) {
            return 2;
        }
        if (method.name.equals(obfuscated ? "func_71061_d_" : "doWaterSplashEffect")) {
            return 3;
        }
        if (method.name.equals(obfuscated ? "func_70055_a" : "isInsideOfMaterial")) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_72314_b" : "grow")) {
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 2 && this.checkMethod(this.getNext(insn, 2), obfuscated ? "func_72314_b" : "grow")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("fixSquidWaterCollision", "(DLnet/minecraft/entity/Entity;)D"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            return true;
        }
        if (index == 3) {
            if (this.checkMethod(insn.getPrevious(), obfuscated ? "func_76128_c" : "floor")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("fixWaterSplashEffect", "(Lnet/minecraft/entity/Entity;)F"));
                this.removeFrom(instructions, insn, -3);
            } else if (insn.getOpcode() == 98 && insn.getPrevious().getOpcode() == 12) {
                this.removeFrom(instructions, insn, -1);
            } else if (this.checkField(insn, "WATER_BUBBLE")) {
                this.removeFrom(instructions, this.getNext(insn, 15), 12);
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
            }
        } else {
            if (index == 4 && this.checkMethod(insn, "isEntityInsideMaterial")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isEntityInsideFluidState", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;"));
                instructions.remove(insn);
                return true;
            }
            if (index == 5 && this.checkMethod(insn, obfuscated ? "func_72953_d" : "containsAnyLiquid")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("blocksContainAnyLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;)Z"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/vanilla/entity/PluginEntity$Accessor");
        this.addMethod(classNode, "onInsideBlock_Public", "(Lnet/minecraft/block/state/IBlockState;)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/entity/Entity", obfuscated ? "func_191955_a" : "onInsideBlock", "(Lnet/minecraft/block/state/IBlockState;)V", false);
        });
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/iface/IWaterHeight");
        classNode.fields.add(new FieldNode(1, "waterHeight", "Lgit/jbredwards/fluidlogged_api/mod/asm/iface/IConfigFluidBox$HeightBox;", null, null));
        this.addMethod(classNode, "getBox", "()Lgit/jbredwards/fluidlogged_api/mod/asm/iface/IConfigFluidBox$HeightBox;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/entity/Entity", "waterHeight", "Lgit/jbredwards/fluidlogged_api/mod/asm/iface/IConfigFluidBox$HeightBox;");
        });
        this.addMethod(classNode, "setBox", "(Lgit/jbredwards/fluidlogged_api/mod/asm/iface/IConfigFluidBox$HeightBox;)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitFieldInsn(181, "net/minecraft/entity/Entity", "waterHeight", "Lgit/jbredwards/fluidlogged_api/mod/asm/iface/IConfigFluidBox$HeightBox;");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_145775_I" : "doBlockCollisions"), "doBlockCollisions", "(Lnet/minecraft/entity/Entity;D)V", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitLdcInsn((Object)0.001);
        });
        return true;
    }

    public static interface Accessor {
        public void onInsideBlock_Public(@Nonnull IBlockState var1);
    }

    public static final class Hooks {
        public static boolean blocksContainAnyLiquid(@Nonnull World world, @Nonnull AxisAlignedBB bb) {
            FluidCache cache = new FluidCache((IBlockAccess)world, bb);
            for (int x = cache.minX; x < cache.maxX; ++x) {
                for (int y = cache.minY; y < cache.maxY; ++y) {
                    for (int z = cache.minZ; z < cache.maxZ; ++z) {
                        Object here = cache.func_180495_p((BlockPos)cache.mutablePos.func_181079_c(x, y, z));
                        if (FluidloggedUtils.isFluid(here)) {
                            return true;
                        }
                        Boolean result = here.func_177230_c().isAABBInsideLiquid(world, (BlockPos)cache.mutablePos.func_181079_c(x, y, z), bb);
                        if (Boolean.TRUE.equals(result)) {
                            return true;
                        }
                        here = cache.getFluidState((Vec3i)cache.mutablePos.func_181079_c(x, y, z));
                        if (!here.isEmpty()) {
                            return true;
                        }
                        result = here.getBlock().isAABBInsideLiquid(world, (BlockPos)cache.mutablePos.func_181079_c(x, y, z), bb);
                        if (!Boolean.TRUE.equals(result)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public static void doBlockCollisions(@Nonnull Entity entity, double size) {
            BlockPos.PooledMutableBlockPos end;
            BlockPos.PooledMutableBlockPos start = BlockPos.PooledMutableBlockPos.func_185345_c((double)(entity.func_174813_aQ().field_72340_a + size), (double)(entity.func_174813_aQ().field_72338_b + size), (double)(entity.func_174813_aQ().field_72339_c + size));
            if (entity.field_70170_p.func_175707_a((BlockPos)start, (BlockPos)(end = BlockPos.PooledMutableBlockPos.func_185345_c((double)(entity.func_174813_aQ().field_72336_d - size), (double)(entity.func_174813_aQ().field_72337_e - size), (double)(entity.func_174813_aQ().field_72334_f - size))))) {
                ChunkCache access = new ChunkCache(entity.field_70170_p, (BlockPos)start, (BlockPos)end, 0);
                BlockPos.func_177975_b((BlockPos)start, (BlockPos)end).forEach(pos -> {
                    IBlockState fluidState;
                    IBlockState state = access.func_180495_p((BlockPos)pos);
                    if (!Boolean.FALSE.equals(state.func_177230_c().isAABBInsideLiquid(entity.field_70170_p, (BlockPos)pos, entity.func_174813_aQ()))) {
                        try {
                            state.func_177230_c().func_180634_a(entity.field_70170_p, (BlockPos)pos, state, entity);
                            ((Accessor)entity).onInsideBlock_Public(state);
                        }
                        catch (Throwable t) {
                            CrashReport report = CrashReport.func_85055_a((Throwable)t, (String)"Colliding entity with block");
                            CrashReportCategory.func_175750_a((CrashReportCategory)report.func_85058_a("Block being collided with"), (BlockPos)pos, (IBlockState)state);
                            throw new ReportedException(report);
                        }
                    }
                    if (!Boolean.FALSE.equals((fluidState = FluidState.get((IBlockAccess)access, (BlockPos)pos).getState()).func_177230_c().isAABBInsideLiquid(entity.field_70170_p, (BlockPos)pos, entity.func_174813_aQ()))) {
                        try {
                            fluidState.func_177230_c().func_180634_a(entity.field_70170_p, (BlockPos)pos, fluidState, entity);
                            ((Accessor)entity).onInsideBlock_Public(fluidState);
                        }
                        catch (Throwable t) {
                            CrashReport report = CrashReport.func_85055_a((Throwable)t, (String)"Colliding entity with fluid");
                            CrashReportCategory.func_175750_a((CrashReportCategory)report.func_85058_a("Fluid being collided with"), (BlockPos)pos, (IBlockState)fluidState);
                            throw new ReportedException(report);
                        }
                    }
                });
            }
            start.func_185344_t();
            end.func_185344_t();
        }

        public static double fixSquidWaterCollision(double factor, @Nonnull Entity entity) {
            return entity.isCreatureType(EnumCreatureType.WATER_CREATURE, false) ? factor : 0.0;
        }

        public static float fixWaterSplashEffect(@Nonnull Entity entity) {
            BlockPos pos;
            FluidState fluidState;
            RayTraceResult result = entity.field_70170_p.func_147447_a(new Vec3d(entity.field_70165_t - entity.field_70159_w, entity.field_70163_u - entity.field_70181_x, entity.field_70161_v - entity.field_70179_y), new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), true, true, false);
            if (result != null && !(fluidState = FluidloggedUtils.getFluidState((IBlockAccess)entity.field_70170_p, pos = result.func_178782_a())).isEmpty() && fluidState.isValid()) {
                float filled = FluidCollisionHandler.getFilledPercentage(fluidState, (IBlockAccess)entity.field_70170_p, pos);
                return (float)pos.func_177956_o() + (filled < 0.0f ? filled + 1.1f : filled - 0.1f);
            }
            return (float)(entity.field_70163_u + entity.field_70181_x * -0.7 - 0.1);
        }

        @Nullable
        public static Boolean isEntityInsideFluidState(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            FluidState fluidState;
            Boolean result = block.isEntityInsideMaterial((IBlockAccess)world, pos, here, entity, yToTest, materialIn, testingHead);
            if (result != null) {
                return result;
            }
            if (FluidloggedUtils.getFluidFromBlock(block) == null && !(fluidState = FluidState.get((IBlockAccess)world, pos)).isEmpty()) {
                result = fluidState.getBlock().isEntityInsideMaterial((IBlockAccess)world, pos, fluidState.getState(), entity, yToTest, materialIn, testingHead);
                if (result != null) {
                    return result;
                }
                if (fluidState.getMaterial() == materialIn) {
                    return ForgeHooks.isInsideOfMaterial((Material)materialIn, (Entity)entity, (BlockPos)pos);
                }
            }
            return null;
        }
    }
}

