/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.item;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginItemBucket
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_77659_a" : "onItemRightClick"), "onRightClickBucket", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;Lnet/minecraft/block/Block;)Lnet/minecraft/util/ActionResult;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraft/item/ItemBucket", obfuscated ? "field_77876_a" : "containedBlock", "Lnet/minecraft/block/Block;");
        });
        return false;
    }

    public static final class Hooks {
        @Nonnull
        public static ActionResult<ItemStack> onRightClickBucket(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull Block contained) {
            Vec3d reachVec;
            Vec3d eyeVec;
            RayTraceResult trace;
            ItemStack held = player.func_184586_b(hand);
            ActionResult eventResult = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)held, (RayTraceResult)(trace = world.func_147447_a(eyeVec = player.func_174824_e(1.0f), reachVec = eyeVec.func_178787_e(player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e())), contained == Blocks.field_150350_a, contained != Blocks.field_150350_a, false)));
            if (eventResult != null) {
                return eventResult;
            }
            if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
            }
            if (contained == Blocks.field_150350_a) {
                return Hooks.drainFluid(world, player, held, trace);
            }
            return Hooks.placeFluid(world, player, contained, held, trace);
        }

        @Nonnull
        public static ActionResult<ItemStack> drainFluid(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull ItemStack held, @Nonnull RayTraceResult trace) {
            FluidActionResult filledResult;
            if (world.func_175660_a(player, trace.func_178782_a()) && (filledResult = FluidUtil.tryPickUpFluid((ItemStack)held.func_77946_l(), (EntityPlayer)player, (World)world, (BlockPos)trace.func_178782_a(), (EnumFacing)trace.field_178784_b)).isSuccess()) {
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                    if (held.func_190926_b()) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)filledResult.getResult());
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledResult.getResult());
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)held);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)held);
        }

        @Nonnull
        public static ActionResult<ItemStack> placeFluid(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull Block contained, @Nonnull ItemStack held, @Nonnull RayTraceResult trace) {
            return Hooks.placeFluid(world, player, contained, held, trace, held.func_77973_b());
        }

        @Nonnull
        public static ActionResult<ItemStack> placeFluid(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull Block contained, @Nonnull ItemStack held, @Nonnull RayTraceResult trace, @Nonnull Item itemForStats) {
            Fluid fluid = FluidloggedUtils.getFluidFromBlock(contained);
            if (fluid != null && world.func_175660_a(player, trace.func_178782_a())) {
                FluidActionResult drainedResult;
                BlockPos targetPos;
                BlockPos blockPos = targetPos = trace.field_178784_b == EnumFacing.UP && world.func_180495_p(trace.func_178782_a()).func_177230_c().func_176200_f((IBlockAccess)world, trace.func_178782_a()) || FluidloggedAPIConfig.bucketFluidlogging.test(player) && Hooks.isFluidloggable(world, trace.func_178782_a(), contained) ? trace.func_178782_a() : trace.func_178782_a().func_177972_a(trace.field_178784_b);
                if (world.func_175660_a(player, targetPos) && player.func_175151_a(targetPos, trace.field_178784_b, held) && (drainedResult = FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)targetPos, (ItemStack)held.func_77946_l(), (FluidStack)new FluidStack(fluid, 1000))).isSuccess()) {
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, targetPos, held);
                    }
                    player.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)itemForStats)));
                    if (!player.func_184812_l_()) {
                        held.func_190918_g(1);
                        if (held.func_190926_b()) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)drainedResult.getResult());
                        }
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)drainedResult.getResult());
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)held);
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)held);
        }

        public static boolean isFluidloggable(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block fluid) {
            return fluid instanceof IFluidloggableFluid && ((IFluidloggableFluid)fluid).isFluidloggableFluid(FluidState.of(fluid)) && ((IFluidloggableFluid)fluid).isStateFluidloggable(world.func_180495_p(pos), (IBlockAccess)world, pos, FluidState.of(fluid));
        }
    }
}

