/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import atomicstryker.dynamiclights.client.DynamicLights;
import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IWaterHeight;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginChunk;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginChunkCache;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidCollisionHandler;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lumien.randomthings.handler.AsmHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginWorld
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, obfuscated ? "func_180501_a" : "setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z")) {
            return 1;
        }
        if (this.checkMethod(method, obfuscated ? "func_175655_b" : "destroyBlock", null)) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_190524_a" : "neighborChanged", null)) {
            return 3;
        }
        if (this.checkMethod(method, obfuscated ? "func_72875_a" : "isMaterialInBB", null)) {
            return 5;
        }
        if (this.checkMethod(method, obfuscated ? "func_72953_d" : "containsAnyLiquid", null) || this.checkMethod(method, obfuscated ? "func_147470_e" : "isFlammableWithin", null) || this.checkMethod(method, obfuscated ? "func_175696_F" : "isWater", null)) {
            return 6;
        }
        if (method.name.equals(obfuscated ? "func_147470_e" : "isFlammableWithin")) {
            return 7;
        }
        if (this.checkMethod(method, obfuscated ? "func_175721_c" : "getLight", "(Lnet/minecraft/util/math/BlockPos;Z)I") || method.name.equals(obfuscated ? "func_175705_a" : "getLightFromNeighborsFor")) {
            return 8;
        }
        if (method.name.equals(obfuscated ? "func_180500_c" : "checkLightFor")) {
            return 9;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                if (obfuscated) {
                    ((MethodInsnNode)insn).name = "func_177435_g";
                }
                ((MethodInsnNode)insn).owner = "net/minecraft/world/chunk/Chunk";
                ((VarInsnNode)this.getPrevious((AbstractInsnNode)insn, (int)2)).var = this.findLocal((MethodNode)method, (String)"chunk", (String)"Lnet/minecraft/world/chunk/Chunk;").index;
                return false;
            }
            if (this.checkMethod(insn, "getLightValue") || this.checkMethod(insn, "getLightOpacity")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, this.findLocal((MethodNode)method, (String)"chunk", (String)"Lnet/minecraft/world/chunk/Chunk;").index));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode(((MethodInsnNode)insn).name, "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
                instructions.remove(insn);
                return false;
            }
            if (!this.checkMethod(insn, obfuscated ? "func_177436_a" : "setBlockState")) return this.checkMethod(insn, "markAndNotifyBlock");
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.findLocal((MethodNode)method, (String)"chunk", (String)"Lnet/minecraft/world/chunk/Chunk;").index));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.findLocal((MethodNode)method, (String)"oldState", (String)"Lnet/minecraft/block/state/IBlockState;").index));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.findLocal((MethodNode)method, (String)"iblockstate", (String)"Lnet/minecraft/block/state/IBlockState;").index));
            list.add((AbstractInsnNode)new VarInsnNode(21, 3));
            list.add((AbstractInsnNode)this.genMethodNode("handleOldFluidState", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V"));
            instructions.insert(insn.getNext(), list);
            return false;
        }
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_180501_a" : "setBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", obfuscated ? "func_175698_g" : "setBlockToAir", "(Lnet/minecraft/util/math/BlockPos;)Z", false));
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 3) {
            if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", obfuscated ? "func_175726_f" : "getChunk", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", false));
                list.add((AbstractInsnNode)new VarInsnNode(58, 15));
                list.add((AbstractInsnNode)new VarInsnNode(25, 15));
                instructions.insertBefore(this.getPrevious(insn, 2), list);
                instructions.remove(this.getPrevious(insn, 2));
                if (obfuscated) {
                    ((MethodInsnNode)insn).name = "func_177435_g";
                }
                ((MethodInsnNode)insn).owner = "net/minecraft/world/chunk/Chunk";
                return false;
            }
            if (!this.checkMethod(insn, obfuscated ? "func_189546_a" : "neighborChanged", null)) return false;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 15));
            list.add((AbstractInsnNode)this.genMethodNode("fluidNeighborChanged", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)V"));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 5 && insn.getOpcode() == 3) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(21, 3));
            list.add((AbstractInsnNode)new VarInsnNode(21, 4));
            list.add((AbstractInsnNode)new VarInsnNode(21, 5));
            list.add((AbstractInsnNode)new VarInsnNode(21, 6));
            list.add((AbstractInsnNode)new VarInsnNode(21, 7));
            list.add((AbstractInsnNode)new VarInsnNode(21, 8));
            list.add((AbstractInsnNode)this.genMethodNode("isMaterialInFluidBB", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;IIIIII)Z"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        if (index == 6 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.remove(insn);
            return true;
        }
        if (index == 7 && this.checkField(insn, obfuscated ? "field_150353_l" : "LAVA")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.findLocal((MethodNode)method, (String)"blockpos$pooledmutableblockpos", (String)"Lnet/minecraft/util/math/BlockPos$PooledMutableBlockPos;").index));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)this.genMethodNode("isFlammableFluidWithin", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Z"));
            instructions.insert(insn, list);
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 8 && this.checkMethod(insn, obfuscated ? "func_185916_f" : "useNeighborBrightness")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("useNeighborBrightness", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        if (index != 9) return false;
        if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(1));
            this.removeFrom(instructions, insn, -2);
            return false;
        }
        if (!this.checkMethod(insn, "getLightOpacity")) return false;
        this.removeFrom(instructions, this.getPrevious(insn, 3), -2);
        instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", "getBlockLightOpacity", "(Lnet/minecraft/util/math/BlockPos;)I", false));
        instructions.remove(insn);
        return true;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/world/IWorldChunkProvider");
        this.addMethod(classNode, "getWorld", "()Lnet/minecraft/world/World;", null, null, generator -> generator.visitVarInsn(25, 0));
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_72918_a" : "handleMaterialAcceleration"), "handleMaterialAcceleration", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;Lnet/minecraft/entity/Entity;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, obfuscated ? "func_147447_a" : "rayTraceBlocks", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"), "rayTraceBlocks", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(21, 5);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_175638_a" : "getRawLight"), "getRawLight", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/EnumSkyBlock;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_175623_d" : "isAirBlock"), null, null, (GeneratorAdapter generator) -> {
            int stateVar = generator.newLocal(Type.getType((String)"Lnet/minecraft/block/state/IBlockState;"));
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/world/World", obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false);
            generator.visitVarInsn(58, stateVar);
            generator.visitVarInsn(25, stateVar);
            generator.visitMethodInsn(185, "net/minecraft/block/state/IBlockState", obfuscated ? "func_177230_c" : "getBlock", "()Lnet/minecraft/block/Block;", true);
            generator.visitVarInsn(25, stateVar);
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/block/Block", "isAir", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", false);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, obfuscated ? "func_175627_a" : "getStrongPower", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I"), "getStrongPower", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, obfuscated ? "func_175676_y" : "getStrongPower", "(Lnet/minecraft/util/math/BlockPos;)I"), "getStrongPower", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_175651_c" : "getRedstonePower"), "getRedstonePower", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_175687_A" : "getRedstonePowerFromNeighbors"), "getRedstonePowerFromNeighbors", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals(obfuscated ? "func_175640_z" : "isBlockPowered"), "isBlockPowered", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
        });
        return true;
    }

    @Override
    @Nonnull
    public byte[] transform(@Nonnull byte[] basicClass, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        for (MethodNode mv : classNode.methods) {
            if (!mv.name.equals(obfuscated ? "func_175698_g" : "setBlockToAir")) continue;
            this.overrideMethod(classNode, mv, null, null, (GeneratorAdapter generator) -> {});
            mv.instructions.clear();
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "net/minecraft/world/World", obfuscated ? "func_175726_f" : "getChunk", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", false);
            mv.visitVarInsn(58, 2);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraft/world/World", obfuscated ? "field_72995_K" : "isRemote", "Z");
            Label l2 = new Label();
            mv.visitJumpInsn(153, l2);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "net/minecraft/world/chunk/Chunk", obfuscated ? "func_177435_g" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false);
            mv.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "isFluid", "(Lnet/minecraft/block/state/IBlockState;)Z", false);
            mv.visitJumpInsn(153, l2);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l2);
            mv.visitFrame(1, 1, new Object[]{"net/minecraft/world/chunk/Chunk"}, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getFromProvider", "(Lnet/minecraftforge/common/capabilities/ICapabilityProvider;Lnet/minecraft/util/math/BlockPos;)Lgit/jbredwards/fluidlogged_api/api/util/FluidState;", false);
            mv.visitMethodInsn(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "toFlowing", "()Lgit/jbredwards/fluidlogged_api/api/util/FluidState;", false);
            mv.visitMethodInsn(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getState", "()Lnet/minecraft/block/state/IBlockState;", false);
            mv.visitIntInsn(16, 35);
            mv.visitMethodInsn(182, "net/minecraft/world/World", obfuscated ? "func_180501_a" : "setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", false);
            mv.visitInsn(172);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("world", "Lnet/minecraft/world/World;", null, l0, l3, 0);
            mv.visitLocalVariable("pos", "Lnet/minecraft/util/math/BlockPos;", null, l0, l3, 1);
            mv.visitLocalVariable("chunk", "Lnet/minecraft/world/chunk/Chunk;", null, l1, l3, 2);
            mv.visitEnd();
            break;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return IASMPlugin.super.transform(writer.toByteArray(), obfuscated);
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        if (index == 3) {
            method.localVariables.add(new LocalVariableNode("chunk", "Lnet/minecraft/world/chunk/Chunk;", null, start, end, 15));
            return true;
        }
        return false;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static final class RTHooks {
        public static int getRedstonePower(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
            return AsmHandler.getRedstonePower((World)IWorldProvider.getWorld(world), (BlockPos)pos, (EnumFacing)facing);
        }

        public static int getStrongPower(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
            return AsmHandler.getStrongPower((World)IWorldProvider.getWorld(world), (BlockPos)pos, (EnumFacing)facing);
        }
    }

    public static final class DLHooks {
        public static int getLightValue(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState fluidState) {
            return Math.max(DynamicLights.getLightValue((Block)state.func_177230_c(), (IBlockState)state, (IBlockAccess)world, (BlockPos)pos), fluidState.getLightValue((IBlockAccess)world, pos));
        }
    }

    public static final class Hooks {
        public static void fluidNeighborChanged(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, @Nonnull Chunk chunk) {
            FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState().func_189546_a(world, pos, blockIn, fromPos);
        }

        public static int getLightOpacity(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return PluginChunk.Hooks.getFluidLightOpacity(state, world, pos, chunk);
        }

        public static int getLightValue(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return PluginChunk.Hooks.getFluidLightValue(state, world, pos, chunk);
        }

        public static int getRawLight(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumSkyBlock lightType) {
            if (lightType == EnumSkyBlock.SKY && world.func_175678_i(pos)) {
                return 15;
            }
            Chunk chunk = world.func_175726_f(pos);
            IBlockState state = chunk.func_177435_g(pos);
            IBlockState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState();
            int light = lightType == EnumSkyBlock.SKY ? 0 : (FluidloggedAPI.isDynamicLights ? DLHooks.getLightValue(state, world, pos, fluidState) : Math.max(state.getLightValue((IBlockAccess)world, pos), fluidState.getLightValue((IBlockAccess)world, pos)));
            int opacity = Math.max(Math.max(state.getLightOpacity((IBlockAccess)world, pos), fluidState.getLightOpacity((IBlockAccess)world, pos)), 1);
            if (opacity >= 15) {
                return light;
            }
            if (light >= 14) {
                return light;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offset = pos.func_177972_a(facing);
                int neighborLight = world.func_175642_b(lightType, offset) - opacity;
                if (neighborLight > light) {
                    light = neighborLight;
                }
                if (light < 14) continue;
                return light;
            }
            return light;
        }

        public static int getRedstonePower(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            int wireless;
            if (FluidloggedAPI.isRandomThings && (wireless = RTHooks.getRedstonePower(world, pos, direction)) != 0) {
                return wireless;
            }
            IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 3, 3) : world;
            IBlockState state = access.func_180495_p(pos);
            if (state.func_177230_c().shouldCheckWeakPower(state, access, pos, direction)) {
                return Hooks.getStrongPower(access, pos);
            }
            IBlockState fluidState = FluidState.get(access, pos).getState();
            if (fluidState.func_177230_c().shouldCheckWeakPower(fluidState, access, pos, direction)) {
                return Hooks.getStrongPower(access, pos);
            }
            return Math.max(state.func_185911_a(access, pos, direction), fluidState.func_185911_a(access, pos, direction));
        }

        public static int getRedstonePowerFromNeighbors(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            int currMax;
            IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 4, 4) : world;
            FluidState fluidState = FluidState.get(access, pos);
            int n = currMax = fluidState.isEmpty() ? 0 : fluidState.getState().func_185911_a(access, pos, fluidState.getDownDensityFace());
            if (currMax >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177977_b(), EnumFacing.DOWN))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177984_a(), EnumFacing.UP))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177978_c(), EnumFacing.NORTH))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177968_d(), EnumFacing.SOUTH))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177976_e(), EnumFacing.WEST))) >= 15) {
                return currMax;
            }
            return Math.max(currMax, Hooks.getRedstonePower(access, pos.func_177974_f(), EnumFacing.EAST));
        }

        public static int getStrongPower(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            int currMax;
            IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 2, 2) : world;
            FluidState fluidState = FluidState.get(access, pos);
            int n = currMax = fluidState.isEmpty() ? 0 : fluidState.getState().func_185893_b(access, pos, fluidState.getDownDensityFace());
            if (currMax >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getStrongPower(access, pos.func_177977_b(), EnumFacing.DOWN))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getStrongPower(access, pos.func_177984_a(), EnumFacing.UP))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getStrongPower(access, pos.func_177978_c(), EnumFacing.NORTH))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getStrongPower(access, pos.func_177968_d(), EnumFacing.SOUTH))) >= 15) {
                return currMax;
            }
            if ((currMax = Math.max(currMax, Hooks.getStrongPower(access, pos.func_177976_e(), EnumFacing.WEST))) >= 15) {
                return currMax;
            }
            return Math.max(currMax, Hooks.getStrongPower(access, pos.func_177974_f(), EnumFacing.EAST));
        }

        public static int getStrongPower(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            int wireless;
            if (FluidloggedAPI.isRandomThings && (wireless = RTHooks.getStrongPower(world, pos, direction)) != 0) {
                return wireless;
            }
            IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 1, 1) : world;
            return Math.max(access.func_180495_p(pos).func_185893_b(access, pos, direction), FluidState.get(access, pos).getState().func_185893_b(access, pos, direction));
        }

        public static boolean handleMaterialAcceleration(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Material material, @Nonnull Entity entity) {
            int maxZ;
            int maxY;
            int maxX;
            int minZ;
            int minY;
            int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
            if (!world.func_175663_a(minX, minY = MathHelper.func_76128_c((double)bb.field_72338_b), minZ = MathHelper.func_76128_c((double)bb.field_72339_c), maxX = MathHelper.func_76143_f((double)bb.field_72336_d), maxY = MathHelper.func_76143_f((double)bb.field_72337_e), maxZ = MathHelper.func_76143_f((double)bb.field_72334_f), true)) {
                return false;
            }
            IWaterHeight waterHeight = (IWaterHeight)entity;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
            if (material == Material.field_151586_h) {
                FluidCollisionHandler.cacheHeight.set(waterHeight);
            }
            ChunkCache cache = new ChunkCache(world, new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ), 0);
            Vec3d vec = Vec3d.field_186680_a;
            waterHeight.setBox(null);
            boolean pushEntity = entity.func_96092_aw();
            boolean anyFound = false;
            int total = 0;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        IBlockState here;
                        double height;
                        Vec3d fluidVec;
                        IBlockState state = cache.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                        Boolean result = state.func_177230_c().isEntityInsideMaterial((IBlockAccess)cache, (BlockPos)pos, state, entity, (double)maxY, material, false);
                        if (result != null) {
                            if (!result.booleanValue()) continue;
                            anyFound = true;
                            boolean isFluid = FluidloggedUtils.isFluid(state);
                            if (!isFluid) {
                                waterHeight.setBox(new IConfigFluidBox.HeightBox(0.0, 1.0));
                            }
                            if (!pushEntity) continue;
                            fluidVec = state.func_177230_c().func_176197_a(world, (BlockPos)pos, entity, Vec3d.field_186680_a);
                            if (isFluid && (height = (double)FluidState.of(state).getActualHeight((IBlockAccess)cache, (BlockPos)pos)) < 0.4) {
                                fluidVec = fluidVec.func_186678_a(height);
                            }
                            ++total;
                            vec = vec.func_178787_e(fluidVec);
                            continue;
                        }
                        FluidState fluidState = FluidState.get((IBlockAccess)cache, (BlockPos)pos);
                        result = fluidState.getBlock().isEntityInsideMaterial((IBlockAccess)cache, (BlockPos)pos, fluidState.getState(), entity, (double)maxY, material, false);
                        if (result != null) {
                            if (!result.booleanValue()) continue;
                            anyFound = true;
                            if (!pushEntity) continue;
                            fluidVec = fluidState.getBlock().func_176197_a(world, (BlockPos)pos, entity, Vec3d.field_186680_a);
                            height = fluidState.getActualHeight((IBlockAccess)cache, (BlockPos)pos);
                            if (height < 0.4) {
                                fluidVec = fluidVec.func_186678_a(height);
                            }
                            ++total;
                            vec = vec.func_178787_e(fluidVec);
                            continue;
                        }
                        IBlockState iBlockState = here = fluidState == FluidState.EMPTY ? state : fluidState.getState();
                        if (here.func_185904_a() != material) continue;
                        waterHeight.setBox(new IConfigFluidBox.HeightBox(0.0, 1.0));
                        anyFound = true;
                        if (!pushEntity) continue;
                        ++total;
                        vec = vec.func_178787_e(here.func_177230_c().func_176197_a(world, (BlockPos)pos, entity, Vec3d.field_186680_a));
                    }
                }
            }
            pos.func_185344_t();
            if (vec.func_72433_c() > 0.0) {
                if (total > 0) {
                    vec = vec.func_186678_a(1.0 / (double)total);
                }
                if (!(entity instanceof EntityPlayer)) {
                    vec = vec.func_72432_b();
                }
                entity.field_70159_w += vec.field_72450_a * 0.014;
                entity.field_70181_x += vec.field_72448_b * 0.014;
                entity.field_70179_y += vec.field_72449_c * 0.014;
            }
            if (material == Material.field_151586_h) {
                FluidCollisionHandler.cacheHeight.set(null);
            }
            return anyFound;
        }

        public static void handleOldFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, @Nullable IBlockState iblockstate, int blockFlags) {
            if (iblockstate != null) {
                FluidState oldFluidState;
                IFluidloggableFluid handler;
                FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
                boolean notifyFluid = (blockFlags & 1) != 0;
                blockFlags &= 0xFFFFFFFE;
                if (!world.field_72995_K && !notifyFluid && chunk.func_150802_k() && !FluidloggedUtils.isFluid(newState)) {
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    Chunk[][] chunks = new Chunk[2][2];
                    fluidState.getState().func_189546_a(world, pos, newState.func_177230_c(), pos);
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        Chunk neighborChunk;
                        mutablePos.func_181079_c(pos.func_177958_n() + side.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + side.func_82599_e());
                        int x = mutablePos.func_177958_n() >> 4;
                        int z = mutablePos.func_177952_p() >> 4;
                        Chunk chunk2 = neighborChunk = chunks[x & 1][z & 1] == null ? (chunks[x & 1][z & 1] = world.func_72964_e(x, z)) : chunks[x & 1][z & 1];
                        if (!neighborChunk.func_150802_k()) continue;
                        FluidloggedUtils.getFluidState(neighborChunk, (BlockPos)mutablePos).getState().func_189546_a(world, (BlockPos)mutablePos, newState.func_177230_c(), pos);
                    }
                }
                if ((blockFlags & 0x40) == 0 && ((blockFlags & 0x20) != 0 || !(newState.func_177230_c() instanceof IFluidloggable) && FluidState.removeOnBlockChange.get() != null)) {
                    if (fluidState != FluidState.EMPTY) {
                        FluidloggedUtils.setFluidState(world, pos, newState, FluidState.EMPTY, false, blockFlags);
                    }
                } else if (fluidState.getBlock() instanceof IFluidloggableFluid) {
                    if (!((IFluidloggableFluid)fluidState.getBlock()).isStateFluidloggable(newState, (IBlockAccess)world, pos, fluidState)) {
                        FluidloggedUtils.setFluidState(world, pos, newState, FluidState.EMPTY, false, blockFlags);
                    } else if (!world.field_72995_K && (notifyFluid || chunk.func_150802_k())) {
                        fluidState.getState().func_189546_a(world, pos, newState.func_177230_c(), pos);
                    }
                } else if (oldState.func_177230_c() instanceof IFluidloggableFluid && (handler = (IFluidloggableFluid)oldState.func_177230_c()).isFluidloggableFluid(oldFluidState = FluidState.of(oldState)) && handler.isStateFluidloggable(newState, (IBlockAccess)world, pos, oldFluidState)) {
                    FluidloggedUtils.setFluidState(world, pos, newState, oldFluidState, false, blockFlags);
                    oldFluidState.getState().func_189546_a(world, pos, newState.func_177230_c(), pos);
                }
            }
        }

        public static boolean isBlockPowered(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            IBlockAccess access = world instanceof World ? new FluidCache(world, (Vec3i)pos, 4, 4) : world;
            FluidState fluidState = FluidState.get(access, pos);
            return !fluidState.isEmpty() && fluidState.getState().func_185911_a(access, pos, fluidState.getDownDensityFace()) > 0 || 0 < Hooks.getRedstonePower(access, pos.func_177977_b(), EnumFacing.DOWN) || 0 < Hooks.getRedstonePower(access, pos.func_177984_a(), EnumFacing.UP) || 0 < Hooks.getRedstonePower(access, pos.func_177978_c(), EnumFacing.NORTH) || 0 < Hooks.getRedstonePower(access, pos.func_177968_d(), EnumFacing.SOUTH) || 0 < Hooks.getRedstonePower(access, pos.func_177976_e(), EnumFacing.WEST) || 0 < Hooks.getRedstonePower(access, pos.func_177974_f(), EnumFacing.EAST);
        }

        public static boolean isFlammableFluidWithin(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb) {
            if (block.func_176223_P().func_185904_a() == Material.field_151587_i) {
                return Boolean.TRUE.equals(block.isAABBInsideLiquid(world, pos, bb));
            }
            FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
            return fluidState.getMaterial() == Material.field_151587_i && Boolean.TRUE.equals(fluidState.getBlock().isAABBInsideLiquid(world, pos, bb));
        }

        public static boolean isMaterialInFluidBB(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Material materialIn, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
                        if (fluidState.isEmpty()) continue;
                        Boolean result = fluidState.getBlock().isAABBInsideMaterial(world, pos, bb, materialIn);
                        if (result != null) {
                            if (!result.booleanValue()) continue;
                            return true;
                        }
                        if (fluidState.getMaterial() != materialIn) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Nullable
        public static RayTraceResult rayTraceBlocks(@Nonnull World world, @Nonnull Vec3d vec, @Nonnull Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
            IBlockState state;
            RayTraceResult result;
            FluidState fluidState;
            if (Double.isNaN(vec.field_72450_a) || Double.isNaN(vec.field_72448_b) || Double.isNaN(vec.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
                return null;
            }
            int endX = MathHelper.func_76128_c((double)end.field_72450_a);
            int endY = MathHelper.func_76128_c((double)end.field_72448_b);
            int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
            int prevX = MathHelper.func_76128_c((double)vec.field_72450_a);
            int prevY = MathHelper.func_76128_c((double)vec.field_72448_b);
            int prevZ = MathHelper.func_76128_c((double)vec.field_72449_c);
            BlockPos pos = new BlockPos(prevX, prevY, prevZ);
            Chunk lastChunk = world.func_175726_f(pos);
            boolean isOutOfWorld = world.func_189509_E(pos);
            FluidState fluidState2 = fluidState = isOutOfWorld ? FluidState.EMPTY : FluidState.getFromProvider((ICapabilityProvider)lastChunk, pos);
            if (fluidState.getBlock().func_176209_a(fluidState.getState(), stopOnLiquid) && (stopOnLiquid && !fluidState.isEmpty() || !ignoreBlockWithoutBoundingBox || fluidState.getState().func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) && (result = fluidState.getState().func_185910_a(world, pos, vec, end)) != null) {
                return result;
            }
            IBlockState iBlockState = state = isOutOfWorld ? Blocks.field_150350_a.func_176223_P() : lastChunk.func_177435_g(pos);
            if (state.func_177230_c().func_176209_a(state, stopOnLiquid) && (stopOnLiquid && FluidloggedUtils.isFluid(state) || !ignoreBlockWithoutBoundingBox || state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) && (result = state.func_185910_a(world, pos, vec, end)) != null) {
                return result;
            }
            RayTraceResult lastResult = FluidloggedAPI.isChiseledMe ? new RayTraceResult(RayTraceResult.Type.MISS, end, EnumFacing.DOWN, pos) : null;
            int i = 200;
            while (i-- >= 0) {
                EnumFacing facing;
                if (Double.isNaN(vec.field_72450_a) || Double.isNaN(vec.field_72448_b) || Double.isNaN(vec.field_72449_c)) {
                    return null;
                }
                if (prevX == endX && prevY == endY && prevZ == endZ) {
                    return returnLastUncollidableBlock ? lastResult : null;
                }
                boolean flagX = true;
                boolean flagY = true;
                boolean flagZ = true;
                double x = 999.0;
                double y = 999.0;
                double z = 999.0;
                if (endX > prevX) {
                    x = prevX + 1;
                } else if (endX < prevX) {
                    x = prevX;
                } else {
                    flagX = false;
                }
                if (endY > prevY) {
                    y = prevY + 1;
                } else if (endY < prevY) {
                    y = prevY;
                } else {
                    flagY = false;
                }
                if (endZ > prevZ) {
                    z = prevZ + 1;
                } else if (endZ < prevZ) {
                    z = prevZ;
                } else {
                    flagZ = false;
                }
                double coveredX = 999.0;
                double coveredY = 999.0;
                double coveredZ = 999.0;
                double distX = end.field_72450_a - vec.field_72450_a;
                double distY = end.field_72448_b - vec.field_72448_b;
                double distZ = end.field_72449_c - vec.field_72449_c;
                if (flagX) {
                    coveredX = (x - vec.field_72450_a) / distX;
                }
                if (flagY) {
                    coveredY = (y - vec.field_72448_b) / distY;
                }
                if (flagZ) {
                    coveredZ = (z - vec.field_72449_c) / distZ;
                }
                if (coveredX == 0.0) {
                    coveredX = -1.0E-4;
                }
                if (coveredY == 0.0) {
                    coveredY = -1.0E-4;
                }
                if (coveredZ == 0.0) {
                    coveredZ = -1.0E-4;
                }
                if (coveredX < coveredY && coveredX < coveredZ) {
                    facing = endX > prevX ? EnumFacing.WEST : EnumFacing.EAST;
                    vec = new Vec3d(x, vec.field_72448_b + distY * coveredX, vec.field_72449_c + distZ * coveredX);
                } else if (coveredY < coveredZ) {
                    facing = endY > prevY ? EnumFacing.DOWN : EnumFacing.UP;
                    vec = new Vec3d(vec.field_72450_a + distX * coveredY, y, vec.field_72449_c + distZ * coveredY);
                } else {
                    facing = endZ > prevZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    vec = new Vec3d(vec.field_72450_a + distX * coveredZ, vec.field_72448_b + distY * coveredZ, z);
                }
                prevX = MathHelper.func_76128_c((double)vec.field_72450_a) - (facing == EnumFacing.EAST ? 1 : 0);
                prevY = MathHelper.func_76128_c((double)vec.field_72448_b) - (facing == EnumFacing.UP ? 1 : 0);
                prevZ = MathHelper.func_76128_c((double)vec.field_72449_c) - (facing == EnumFacing.SOUTH ? 1 : 0);
                pos = new BlockPos(prevX, prevY, prevZ);
                isOutOfWorld = world.func_189509_E(pos);
                if (!lastChunk.func_76600_a(prevX >> 4, prevZ >> 4)) {
                    lastChunk = world.func_175726_f(pos);
                }
                FluidState fluidState3 = fluidState = isOutOfWorld ? FluidState.EMPTY : FluidState.getFromProvider((ICapabilityProvider)lastChunk, pos);
                if (!ignoreBlockWithoutBoundingBox || stopOnLiquid && !fluidState.isEmpty() || fluidState.getState().func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) {
                    if (fluidState.getBlock().func_176209_a(fluidState.getState(), stopOnLiquid)) {
                        result = fluidState.getState().func_185910_a(world, pos, vec, end);
                        if (result != null) {
                            return result;
                        }
                    } else {
                        lastResult = new RayTraceResult(RayTraceResult.Type.MISS, vec, facing, pos);
                    }
                }
                IBlockState iBlockState2 = state = isOutOfWorld ? Blocks.field_150350_a.func_176223_P() : lastChunk.func_177435_g(pos);
                if (ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && (!stopOnLiquid || !FluidloggedUtils.isFluid(state)) && state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) continue;
                if (state.func_177230_c().func_176209_a(state, stopOnLiquid)) {
                    result = state.func_185910_a(world, pos, vec, end);
                    if (result == null) continue;
                    return result;
                }
                lastResult = new RayTraceResult(RayTraceResult.Type.MISS, vec, facing, pos);
            }
            return returnLastUncollidableBlock ? lastResult : null;
        }

        public static boolean setBlockToAir(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState airState, int blockFlags) {
            Chunk chunk = world.func_175726_f(pos);
            if (world.field_72995_K && FluidloggedUtils.isFluid(chunk.func_177435_g(pos))) {
                return false;
            }
            return world.func_180501_a(pos, FluidState.getFromProvider((ICapabilityProvider)chunk, pos).toFlowing().getState(), blockFlags | 0x20);
        }

        public static boolean useNeighborBrightness(@Nonnull World world, @Nonnull BlockPos pos) {
            return PluginChunkCache.Hooks.useNeighborBrightness((IBlockAccess)world, pos);
        }
    }
}

