/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client.config.element;

import git.jbredwards.fluidlogged_api.mod.client.config.element.ToggleableConfigElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ComponentConfigEntry
implements GuiConfigEntries.IConfigEntry {
    @Nonnull
    protected static final Field NAME = ReflectionHelper.findField(GuiConfigEntries.ListEntryBase.class, (String[])new String[]{"name"});
    @Nonnull
    protected static final Field TOOLTIP = ReflectionHelper.findField(GuiConfigEntries.ListEntryBase.class, (String[])new String[]{"toolTip"});
    @Nonnull
    protected final GuiConfigEntries.IConfigEntry parent;
    @Nonnull
    protected final ITextComponent component;

    public ComponentConfigEntry(@Nonnull GuiConfigEntries.IConfigEntry parentIn) {
        if (parentIn instanceof GuiConfigEntries.ListEntryBase) {
            String oldName = ComponentConfigEntry.get(NAME, parentIn).toString();
            this.component = ForgeHooks.newChatWithLinks((String)oldName);
            String newName = this.component.func_150254_d();
            ComponentConfigEntry.set(NAME, parentIn, newName);
            List tooltips = (List)ComponentConfigEntry.get(TOOLTIP, parentIn);
            ListIterator<String> it = tooltips.listIterator();
            while (it.hasNext()) {
                ITextComponent tooltipComponent = ForgeHooks.newChatWithLinks((String)((String)it.next()));
                this.component.func_150257_a(tooltipComponent);
                tooltipComponent.func_150253_a().forEach(arg_0 -> ((ITextComponent)this.component).func_150257_a(arg_0));
                it.set(tooltipComponent.func_150254_d().replace(oldName, newName));
            }
            IConfigElement element = parentIn.getConfigElement();
            if (element.getType() != ConfigGuiType.CONFIG_CATEGORY && !element.isList()) {
                tooltips.remove(tooltips.size() - 1);
                tooltips.add(TextFormatting.AQUA + I18n.func_135052_a((String)"fml.configgui.tooltip.default", (Object[])new Object[]{Optional.ofNullable(element.getDefault()).map(o -> {
                    if (element.getType() == ConfigGuiType.STRING) {
                        return I18n.func_135052_a((String)(element.getLanguageKey() + '.' + o), (Object[])new Object[0]);
                    }
                    return element.getType() == ConfigGuiType.BOOLEAN ? I18n.func_135052_a((String)o.toString(), (Object[])new Object[0]) : o.toString();
                }).orElse("[]")}));
            }
        } else {
            this.component = ForgeHooks.newChatWithLinks((String)parentIn.getName()).func_150257_a(ForgeHooks.newChatWithLinks((String)parentIn.getConfigElement().getComment()));
        }
        this.parent = parentIn;
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        ToggleableConfigElement element = (ToggleableConfigElement)this.getConfigElement();
        element.enabled = this.enabled();
        this.parent.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        element.enabled = null;
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        return this.parent.func_148278_a(slotIndex, mouseX, mouseY, mouseEvent, relativeX, relativeY) || Optional.ofNullable(Minecraft.func_71410_x().field_71462_r).map(openGui -> {
            for (ITextComponent sibling : this.component.func_150253_a()) {
                if (!openGui.func_175276_a(sibling)) continue;
                return Boolean.TRUE;
            }
            return openGui.func_175276_a(this.component);
        }).orElse(Boolean.FALSE) != false;
    }

    @Nonnull
    public IConfigElement getConfigElement() {
        return this.parent.getConfigElement();
    }

    @Nonnull
    public String getName() {
        return this.parent.getName();
    }

    @Nonnull
    public Object getCurrentValue() {
        return this.parent.getCurrentValue();
    }

    @Nonnull
    public Object[] getCurrentValues() {
        return this.parent.getCurrentValues();
    }

    public boolean enabled() {
        return this.parent.enabled();
    }

    public void keyTyped(char eventChar, int eventKey) {
        this.parent.keyTyped(eventChar, eventKey);
    }

    public void updateCursorCounter() {
        this.parent.updateCursorCounter();
    }

    public void mouseClicked(int x, int y, int mouseEvent) {
        this.parent.mouseClicked(x, y, mouseEvent);
    }

    public boolean isDefault() {
        return this.parent.isDefault();
    }

    public void setToDefault() {
        this.parent.setToDefault();
    }

    public void undoChanges() {
        this.parent.undoChanges();
    }

    public boolean isChanged() {
        return this.parent.isChanged();
    }

    public boolean saveConfigElement() {
        return this.parent.saveConfigElement();
    }

    public void drawToolTip(int mouseX, int mouseY) {
        this.parent.drawToolTip(mouseX, mouseY);
    }

    public int getLabelWidth() {
        return this.parent.getLabelWidth();
    }

    public int getEntryRightBound() {
        return this.parent.getEntryRightBound();
    }

    public void onGuiClosed() {
        this.parent.onGuiClosed();
    }

    public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        this.parent.func_192633_a(slotIndex, x, y, partialTicks);
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        this.parent.func_148277_b(slotIndex, x, y, mouseEvent, relativeX, relativeY);
    }

    @Nonnull
    protected static Object get(@Nonnull Field field, @Nonnull Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void set(@Nonnull Field field, @Nonnull Object obj, @Nonnull Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

