/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client.config.element;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ToggleableConfigElement
implements IConfigElement {
    @Nonnull
    protected final IConfigElement parent;
    @Nonnull
    protected final ConfigElementWrapper wrapper;
    @Nullable
    public Boolean display;
    @Nullable
    public Boolean enabled;

    public ToggleableConfigElement(@Nonnull IConfigElement parentIn, @Nonnull ConfigElementWrapper wrapperIn) {
        this.parent = parentIn;
        this.wrapper = wrapperIn;
    }

    public boolean requiresWorldRestart() {
        return this.enabled != null ? this.enabled.equals(Boolean.FALSE) : this.parent.requiresWorldRestart();
    }

    public boolean showInGui() {
        return this.display != null ? this.display.equals(Boolean.TRUE) : this.parent.showInGui();
    }

    @Nonnull
    public IConfigElement getParent() {
        return this.parent instanceof ToggleableConfigElement ? ((ToggleableConfigElement)this.parent).getParent() : this.parent;
    }

    @Nonnull
    public List<IConfigElement> getChildElements() {
        return this.parent.getChildElements().stream().map(element -> this.wrapper.wrap((IConfigElement)element, this.wrapper)).collect(Collectors.toList());
    }

    public boolean isProperty() {
        return this.parent.isProperty();
    }

    @Nonnull
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.parent.getConfigEntryClass();
    }

    @Nonnull
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.parent.getArrayEntryClass();
    }

    @Nonnull
    public String getName() {
        return this.parent.getName();
    }

    @Nonnull
    public String getQualifiedName() {
        return this.parent.getQualifiedName();
    }

    @Nonnull
    public String getLanguageKey() {
        return this.parent.getLanguageKey();
    }

    @Nullable
    public String getComment() {
        return this.parent.getComment();
    }

    @Nonnull
    public ConfigGuiType getType() {
        return this.parent.getType();
    }

    public boolean isList() {
        return this.parent.isList();
    }

    public boolean isListLengthFixed() {
        return this.parent.isListLengthFixed();
    }

    public int getMaxListLength() {
        return this.parent.getMaxListLength();
    }

    public boolean isDefault() {
        return this.parent.isDefault();
    }

    @Nullable
    public Object getDefault() {
        return this.parent.getDefault();
    }

    @Nonnull
    public Object[] getDefaults() {
        return this.parent.getDefaults();
    }

    public void setToDefault() {
        this.parent.setToDefault();
    }

    public boolean requiresMcRestart() {
        return this.parent.requiresMcRestart();
    }

    public boolean hasSlidingControl() {
        return this.parent.hasSlidingControl();
    }

    @Nonnull
    public Object get() {
        return this.parent.get();
    }

    @Nonnull
    public Object[] getList() {
        return this.parent.getList();
    }

    public void set(@Nonnull Object value) {
        this.parent.set(value);
    }

    public void set(@Nonnull Object[] aVal) {
        this.parent.set(aVal);
    }

    @Nonnull
    public String[] getValidValues() {
        return this.parent.getValidValues();
    }

    @Nullable
    public String[] getValidValuesDisplay() {
        return this.parent.getValidValuesDisplay();
    }

    @Nonnull
    public Object getMinValue() {
        return this.parent.getMinValue();
    }

    @Nonnull
    public Object getMaxValue() {
        return this.parent.getMaxValue();
    }

    @Nullable
    public Pattern getValidationPattern() {
        return this.parent.getValidationPattern();
    }

    @FunctionalInterface
    public static interface ConfigElementWrapper {
        @Nonnull
        public IConfigElement wrap(@Nonnull IConfigElement var1, @Nonnull ConfigElementWrapper var2);
    }
}

