/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.common.fluid.handler.FluidExtendedStateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedModelFluid
implements IBakedModel {
    public static boolean DEBUG = FMLLaunchHandler.isDeobfuscatedEnvironment();
    protected static final int[] WSEN = new int[]{1, 0, 3, 2};
    protected static final int[] x = new int[]{0, 0, 1, 1};
    protected static final int[] z = new int[]{0, 1, 1, 0};
    protected static final float eps = 0.002f;
    @Nullable
    protected final TRSRTransformation transformation;
    @Nonnull
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final boolean hasTransform;
    @Nonnull
    protected final VertexFormat format;
    @Nonnull
    protected final TextureAtlasSprite still;
    @Nonnull
    protected final TextureAtlasSprite flowing;
    @Nullable
    protected final TextureAtlasSprite overlay;
    protected final float[] argb = new float[4];
    protected final boolean gas;
    @Nonnull
    protected final Function<SerializedProps, List<BakedQuad>[]> blockQuads;
    @Nullable
    protected List<BakedQuad> itemQuads;

    public BakedModelFluid(@Nonnull Fluid fluidIn, @Nonnull IModelState stateIn, @Nonnull VertexFormat formatIn, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetterIn) {
        this(fluidIn, fluidIn.getStill(), fluidIn.getFlowing(), stateIn, formatIn, textureGetterIn);
    }

    public BakedModelFluid(@Nonnull Fluid fluidIn, @Nonnull ResourceLocation stillIn, @Nonnull ResourceLocation flowingIn, @Nonnull IModelState stateIn, @Nonnull VertexFormat formatIn, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureGetterIn) {
        this.transformation = stateIn.apply(Optional.empty()).orElse(null);
        this.transforms = PerspectiveMapWrapper.getTransforms((IModelState)stateIn);
        this.hasTransform = this.transformation != null && !this.transformation.isIdentity();
        this.format = formatIn;
        this.still = textureGetterIn.apply(stillIn);
        this.flowing = textureGetterIn.apply(flowingIn);
        this.overlay = fluidIn.getOverlay() != null ? textureGetterIn.apply(fluidIn.getOverlay()) : null;
        int color = fluidIn.getColor();
        this.argb[0] = (float)(color >> 24 & 0xFF) / 255.0f;
        this.argb[1] = (float)(color >> 16 & 0xFF) / 255.0f;
        this.argb[2] = (float)(color >> 8 & 0xFF) / 255.0f;
        this.argb[3] = (float)(color & 0xFF) / 255.0f;
        this.gas = fluidIn.isLighterThanAir();
        this.blockQuads = CacheBuilder.newBuilder().maximumSize(200L).build(CacheLoader.from(this::buildQuads));
    }

    @Nonnull
    protected List<BakedQuad>[] buildQuads(@Nonnull SerializedProps key) {
        List[] ret = new List[6];
        float[] levelCorners = key.levelCorners();
        boolean[] sideOverlays = key.sideOverlays();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (key.sideToBuild != null && key.sideToBuild != side) {
                ret[side.func_176745_a()] = Collections.emptyList();
                continue;
            }
            if (side.func_176740_k() == EnumFacing.Axis.Y) {
                EnumFacing top;
                EnumFacing enumFacing = top = this.gas ? EnumFacing.DOWN : EnumFacing.UP;
                if (side == top) {
                    float[] y = new float[4];
                    for (int i2 = 0; i2 < 4; ++i2) {
                        y[i2] = this.gas ? 1.0f - levelCorners[i2] : levelCorners[i2];
                    }
                    int flowDirection = key.flowDirection();
                    boolean isFlowing = flowDirection > -1000;
                    float flow = isFlowing ? (float)Math.toRadians(flowDirection) : 0.0f;
                    TextureAtlasSprite topSprite = isFlowing ? this.flowing : this.still;
                    float scale = isFlowing ? 4.0f : 8.0f;
                    float c = MathHelper.func_76134_b((float)flow) * scale;
                    float s = MathHelper.func_76126_a((float)flow) * scale;
                    VertexParameter uv = i -> c * (float)((x[i] << 1) - 1) + s * (float)((z[i] << 1) - 1);
                    VertexParameter topX = i -> x[i];
                    VertexParameter topY = i -> y[i];
                    VertexParameter topZ = i -> z[i];
                    VertexParameter topU = i -> 8.0f + uv.get(i);
                    VertexParameter topV = i -> 8.0f + uv.get(i + 1 & 3);
                    ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(1);
                    quads.add(this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                    if (key.renderUnder()) {
                        quads.add(this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                    }
                    ret[side.func_176745_a()] = Collections.unmodifiableList(quads);
                    continue;
                }
                ret[side.func_176745_a()] = Collections.singletonList(this.buildQuad(side, this.still, this.gas, false, i -> z[i], i -> this.gas ? 0.998f : 0.002f, i -> x[i], i -> z[i] << 4, i -> x[i] << 4));
                continue;
            }
            boolean useOverlay = this.overlay != null && sideOverlays[side.func_176736_b()];
            int si = WSEN[side.func_176736_b()];
            float[] y = new float[4];
            for (int i3 = 0; i3 < 4; ++i3) {
                y[i3] = this.gas ? 1.0f - levelCorners[i3] : levelCorners[i3];
            }
            VertexParameter sideX = j -> BakedModelFluid.fixTextureFightingX(x[si + x[j] & 3], side);
            VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[si + x[j] & 3];
            VertexParameter sideZ = j -> BakedModelFluid.fixTextureFightingZ(z[si + x[j] & 3], side);
            VertexParameter sideU = j -> x[j] << 3;
            VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(1);
            if (!useOverlay) {
                quads.add(this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
            }
            quads.add(this.buildQuad(side, useOverlay ? this.overlay : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
            ret[side.func_176745_a()] = Collections.unmodifiableList(quads);
        }
        return ret;
    }

    @Nonnull
    protected BakedQuad buildQuad(@Nonnull EnumFacing side, @Nonnull TextureAtlasSprite texture, boolean flip, boolean offset, @Nonnull VertexParameter x, @Nonnull VertexParameter y, @Nonnull VertexParameter z, @Nonnull VertexParameter u, @Nonnull VertexParameter v) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        UnpackedBakedQuad.Builder consumer = this.hasTransform ? new TRSRTransformer((IVertexConsumer)builder, this.transformation) : builder;
        consumer.setQuadOrientation(side);
        consumer.setTexture(texture);
        consumer.setQuadTint(0);
        for (int i = 0; i < 4; ++i) {
            int vertex = flip ? 3 - i : i;
            this.putVertex((IVertexConsumer)consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.func_94214_a((double)u.get(vertex)), texture.func_94207_b((double)v.get(vertex)));
        }
        return builder.build();
    }

    protected void putVertex(@Nonnull IVertexConsumer consumer, @Nonnull EnumFacing side, boolean offset, float x, float y, float z, float u, float v) {
        block6: for (int element = 0; element < this.format.func_177345_h(); ++element) {
            switch (this.format.func_177348_c(element).func_177375_c()) {
                case POSITION: {
                    Vec3i vec;
                    if (offset) {
                        vec = side.func_176730_m();
                        float dx = (float)vec.func_177958_n() * 0.002f;
                        float dy = (float)vec.func_177956_o() * 0.002f;
                        float dz = (float)vec.func_177952_p() * 0.002f;
                        consumer.put(element, new float[]{x - dx, y - dy, z - dz, 1.0f});
                        continue block6;
                    }
                    consumer.put(element, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    consumer.put(element, new float[]{this.argb[1], this.argb[2], this.argb[3], this.argb[0]});
                    continue block6;
                }
                case NORMAL: {
                    Vec3i vec = side.func_176730_m();
                    consumer.put(element, new float[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p(), 0.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(element).func_177369_e() == 0) {
                        consumer.put(element, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(element, new float[0]);
                }
            }
        }
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.still;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null || !(state instanceof IExtendedBlockState)) {
            List<BakedQuad> list;
            if (state == null && side == EnumFacing.SOUTH) {
                if (this.itemQuads == null) {
                    this.itemQuads = Collections.singletonList(this.buildQuad(EnumFacing.UP, this.still, false, false, i -> z[i], i -> x[i], i -> 0.0f, i -> z[i] << 4, i -> x[i] << 4));
                    list = this.itemQuads;
                } else {
                    list = this.itemQuads;
                }
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
        return this.blockQuads.apply(new SerializedProps(null, state instanceof FluidExtendedStateHandler.FluidExtendedBlockState ? (FluidExtendedStateHandler.FluidExtendedBlockState)state : BakedModelFluid.createFluidExtendedState((IExtendedBlockState)state)))[side.func_176745_a()];
    }

    @Nonnull
    protected static FluidExtendedStateHandler.FluidExtendedBlockState createFluidExtendedState(@Nonnull IExtendedBlockState stateIn) {
        int i;
        if (DEBUG) {
            FluidloggedAPI.LOGGER.error("Either a mod is trying to render a fluid without calling Block.getExtendedState, or the fluid block overrides Block.getExtendedState! Assuming default properties for: \"" + stateIn + '\"');
        }
        FluidExtendedStateHandler.FluidExtendedBlockState state = new FluidExtendedStateHandler.FluidExtendedBlockState(stateIn);
        for (i = 0; i < 4; ++i) {
            state.sideOverlays[i] = Boolean.TRUE.equals(stateIn.getValue((IUnlistedProperty)BlockFluidBase.SIDE_OVERLAYS[i]));
            Float corner = (Float)stateIn.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[i]);
            state.levelCorners[i] = Float.valueOf(corner == null ? (stateIn.func_177230_c() instanceof PluginBlockFluidBase.Accessor ? ((PluginBlockFluidBase.Accessor)stateIn.func_177230_c()).getQuantaFraction_Public() : 0.8888889f) : corner.floatValue());
        }
        for (i = 0; i < 4; ++i) {
            if (!(state.levelCorners[i].floatValue() < 1.0f)) continue;
            state.renderUnder = true;
            break;
        }
        Arrays.fill(state.shouldSideBeRenderedCache, true);
        state.flowDirection = (Float)stateIn.getValue((IUnlistedProperty)BlockFluidBase.FLOW_DIRECTION);
        if (state.flowDirection == null) {
            state.flowDirection = Float.valueOf(-1000.0f);
        }
        return state;
    }

    public static float fixTextureFightingX(float old, @Nonnull EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Z ? old : (old == 1.0f ? 0.998f : 0.002f);
    }

    public static float fixTextureFightingZ(float old, @Nonnull EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.X ? old : (old == 1.0f ? 0.998f : 0.002f);
    }

    public static class SerializedProps
    implements Comparable<SerializedProps> {
        @Nonnull
        public final int[] cornerHeights = new int[4];
        public final int serializedProps;
        @Nullable
        public final EnumFacing sideToBuild;

        public SerializedProps(@Nullable EnumFacing side, @Nonnull FluidExtendedStateHandler.FluidExtendedBlockState state) {
            this.serializedProps = MathHelper.func_76125_a((int)((int)Math.round(Math.toDegrees(state.flowDirection.floatValue()))), (int)-1000, (int)1000) + 1024 | (state.renderUnder ? 2048 : 0) | (Boolean.TRUE.equals(state.sideOverlays[0]) ? 4096 : 0) | (Boolean.TRUE.equals(state.sideOverlays[1]) ? 8192 : 0) | (Boolean.TRUE.equals(state.sideOverlays[2]) ? 16384 : 0) | (Boolean.TRUE.equals(state.sideOverlays[3]) ? 32768 : 0);
            this.cornerHeights[0] = Float.floatToRawIntBits(state.levelCorners[0].floatValue());
            this.cornerHeights[1] = Float.floatToRawIntBits(state.levelCorners[1].floatValue());
            this.cornerHeights[2] = Float.floatToRawIntBits(state.levelCorners[2].floatValue());
            this.cornerHeights[3] = Float.floatToRawIntBits(state.levelCorners[3].floatValue());
            this.sideToBuild = side;
        }

        public int flowDirection() {
            return (this.serializedProps & 0x7FF) - 1024;
        }

        public boolean renderUnder() {
            return (this.serializedProps & 0x800) != 0;
        }

        @Nonnull
        public boolean[] sideOverlays() {
            boolean[] ret = new boolean[]{(this.serializedProps >> 12 & 1) != 0, (this.serializedProps >> 13 & 1) != 0, (this.serializedProps >> 14 & 1) != 0, (this.serializedProps >> 15 & 1) != 0};
            return ret;
        }

        @Nonnull
        public float[] levelCorners() {
            float[] ret = new float[]{Float.intBitsToFloat(this.cornerHeights[0]), Float.intBitsToFloat(this.cornerHeights[1]), Float.intBitsToFloat(this.cornerHeights[2]), Float.intBitsToFloat(this.cornerHeights[3])};
            return ret;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.serializedProps == ((SerializedProps)o).serializedProps && Arrays.equals(this.cornerHeights, ((SerializedProps)o).cornerHeights);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.cornerHeights);
            result = 31 * result + Integer.hashCode(this.serializedProps);
            return result;
        }

        @Override
        public int compareTo(@Nonnull SerializedProps o) {
            return new CompareToBuilder().append(this.serializedProps, o.serializedProps).append(this.cornerHeights, o.cornerHeights).toComparison();
        }
    }

    @FunctionalInterface
    public static interface VertexParameter {
        public float get(int var1);
    }
}

