/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.capability;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateLayer;
import it.unimi.dsi.fastutil.chars.CharLinkedOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSets;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FluidStateCapabilityVanilla
implements IFluidStateCapability,
IFluidStateContainer {
    @Nonnull
    protected final CharLinkedOpenHashSet indexedPositions = new CharLinkedOpenHashSet();
    protected final int offsetX;
    protected final int offsetZ;
    @Nonnull
    public FluidStateLayer[] layers = new FluidStateLayer[0];
    public char lowestYPos = (char)65535;

    public FluidStateCapabilityVanilla(int chunkXIn, int chunkZIn) {
        this.offsetX = chunkXIn << 4;
        this.offsetZ = chunkZIn << 4;
    }

    @Override
    public void forEach(@Nonnull IFluidStateContainer.ContainerAction action) {
        CharListIterator it = this.indexedPositions.iterator();
        while (it.hasNext()) {
            char pos = it.nextChar();
            action.accept(pos, this.getFluidState(pos));
        }
    }

    @Override
    public boolean hasFluidState(char serializedPos) {
        int y = serializedPos >> 8;
        if (y < this.lowestYPos) {
            return false;
        }
        int ly = y - this.lowestYPos;
        return this.layers.length > ly && this.layers[ly] != null && this.layers[ly].data[serializedPos & 0xFF] != null;
    }

    @Override
    public void clearFluidStates() {
        this.layers = new FluidStateLayer[0];
        this.lowestYPos = (char)65535;
        if (!this.indexedPositions.isEmpty()) {
            this.indexedPositions.clear();
        }
        this.indexedPositions.trim();
    }

    @Override
    public boolean setFluidState(char serializedPos, @Nonnull FluidState fluidState) {
        FluidStateLayer layer;
        int ly;
        FluidStateLayer[] newLayers;
        boolean isEmpty = fluidState == FluidState.EMPTY;
        int y = serializedPos >> 8;
        if (y < this.lowestYPos) {
            if (isEmpty) {
                return false;
            }
            int dy = this.lowestYPos - y;
            this.lowestYPos = (char)y;
            if (this.layers.length == 0) {
                this.layers = new FluidStateLayer[1];
            } else {
                newLayers = new FluidStateLayer[this.layers.length + dy + 1];
                System.arraycopy(this.layers, 0, newLayers, dy, this.layers.length);
                this.layers = newLayers;
            }
        }
        if (this.layers.length <= (ly = y - this.lowestYPos)) {
            if (isEmpty) {
                return false;
            }
            newLayers = new FluidStateLayer[ly + 1];
            System.arraycopy(this.layers, 0, newLayers, 0, this.layers.length);
            this.layers = newLayers;
        }
        if ((layer = this.layers[ly]) == null) {
            if (isEmpty) {
                return false;
            }
            this.layers[ly] = layer = new FluidStateLayer();
        }
        int xz = serializedPos & 0xFF;
        if (isEmpty) {
            if (layer.data[xz] != null && this.indexedPositions.rem(serializedPos)) {
                layer.tracker = (byte)(layer.tracker - 1);
                if (layer.tracker != -128) {
                    layer.data[xz] = null;
                } else if (this.indexedPositions.isEmpty()) {
                    this.clearFluidStates();
                } else {
                    this.layers[ly] = null;
                    if (ly == 0) {
                        for (int newMinY = 1; newMinY < this.layers.length; ++newMinY) {
                            if (this.layers[newMinY] == null) continue;
                            this.lowestYPos = (char)(this.lowestYPos + newMinY);
                            FluidStateLayer[] newLayers2 = new FluidStateLayer[this.layers.length - newMinY];
                            System.arraycopy(this.layers, newMinY, newLayers2, 0, newLayers2.length);
                            this.layers = newLayers2;
                            break;
                        }
                    } else if (this.layers.length - 1 == ly) {
                        for (int newMaxY = ly - 1; newMaxY >= 0; --newMaxY) {
                            if (this.layers[newMaxY] == null) continue;
                            FluidStateLayer[] newLayers3 = new FluidStateLayer[newMaxY + 1];
                            System.arraycopy(this.layers, 0, newLayers3, 0, newLayers3.length);
                            this.layers = newLayers3;
                            break;
                        }
                    }
                }
                return true;
            }
        } else if (layer.data[xz] != fluidState) {
            if (this.indexedPositions.add(serializedPos)) {
                layer.tracker = (byte)(layer.tracker + 1);
            }
            layer.data[xz] = fluidState;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public FluidState getFluidState(char serializedPos, @Nonnull FluidState fallback) {
        return this.hasFluidState(serializedPos) ? this.getFluidState(serializedPos) : fallback;
    }

    @Nonnull
    protected FluidState getFluidState(char serializedPos) {
        return this.layers[(serializedPos >> 8) - this.lowestYPos].data[serializedPos & 0xFF];
    }

    @Override
    @Nonnull
    public IFluidStateContainer getContainer(int y) {
        return this;
    }

    @Override
    @Nonnull
    public CharSet getSerializedPositions() {
        return CharSets.unmodifiable((CharSet)this.indexedPositions);
    }

    @Nonnull
    public NBTBase serializeNBT() {
        NBTTagList data = new NBTTagList();
        this.forEach((pos, fluidState) -> {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("pos", (int)pos);
            nbt.func_74778_a("id", String.valueOf(fluidState.getBlock().getRegistryName()));
            if (fluidState.getMetadata() != 0) {
                nbt.func_74768_a("meta", fluidState.getMetadata());
            }
            data.func_74742_a((NBTBase)nbt);
        });
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("data", (NBTBase)data);
        nbt.func_74768_a("layersLength", this.layers.length);
        nbt.func_74768_a("lowestYPos", (int)this.lowestYPos);
        nbt.func_74768_a("version", 2);
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            switch (nbt.func_74762_e("version")) {
                case 1: 
                case 2: {
                    if (this.layers.length == 0 && nbt.func_150297_b("layersLength", 99)) {
                        this.layers = new FluidStateLayer[nbt.func_74762_e("layersLength")];
                    }
                    if (this.lowestYPos == '\uffff' && nbt.func_150297_b("lowestYPos", 99)) {
                        this.lowestYPos = (char)nbt.func_74762_e("lowestYPos");
                    }
                    nbt.func_150295_c("data", 10).forEach(tagIn -> {
                        NBTTagCompound tag = (NBTTagCompound)tagIn;
                        if (tag.func_150297_b("id", 8) && tag.func_150297_b("pos", 99)) {
                            Block block = Block.func_149684_b((String)tag.func_74779_i("id"));
                            if (block == null) {
                                return;
                            }
                            NBTPrimitive posNbt = (NBTPrimitive)tag.func_74781_a("pos");
                            char pos = posNbt instanceof NBTTagLong ? this.serializePos((Vec3i)BlockPos.func_177969_a((long)posNbt.func_150291_c())) : (char)posNbt.func_150287_d();
                            this.setFluidState(pos, FluidState.of(block.func_176203_a(tag.func_74762_e("meta"))));
                        }
                    });
                    return;
                }
            }
            throw new IllegalArgumentException("Could not read chunk data, please update Fluidlogged API to the latest version!");
        }
        if (nbtIn instanceof NBTTagList) {
            ((NBTTagList)nbtIn).forEach(tagIn -> {
                NBTTagCompound nbt;
                if (tagIn instanceof NBTTagCompound && (nbt = (NBTTagCompound)tagIn).func_150297_b("id", 8) && nbt.func_150297_b("pos", 4)) {
                    this.setFluidState(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), FluidState.of(Block.func_149684_b((String)nbt.func_74779_i("id"))));
                }
            });
        }
    }

    @Override
    public int serializeX(int x) {
        return x & 0xF;
    }

    @Override
    public int serializeY(int y) {
        return y << 8;
    }

    @Override
    public int serializeZ(int z) {
        return (z & 0xF) << 4;
    }

    @Override
    public int deserializeX(char serializedPos) {
        return this.offsetX | serializedPos & 0xF;
    }

    @Override
    public int deserializeY(char serializedPos) {
        return serializedPos >> 8;
    }

    @Override
    public int deserializeZ(char serializedPos) {
        return this.offsetZ | serializedPos >> 4 & 0xF;
    }
}

