/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class FluidTagsConfigHandler {
    @Nonnull
    private static final String error = "An error occurred while parsing a fluid tag in file \"%s\", skipping...";
    @Nullable
    public static Multimap<String, Fluid> FLUID_TAGS = null;

    public static void init(@Nonnull JsonObject configs) throws IOException {
        FLUID_TAGS = HashMultimap.create();
        FluidloggedAPIConfigs.forEach(configs, "FLUID_TAGS", "fluidTags", (file, jsonIn) -> {
            try {
                boolean allowMissing;
                JsonObject json = jsonIn.getAsJsonObject();
                String id = JsonUtils.func_151200_h((JsonObject)json, (String)"id");
                boolean bl = allowMissing = json.has("allowMissing") && JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing");
                if (json.has("remove")) {
                    HashSet fluids = new HashSet();
                    FluidloggedAPIConfigs.getAsIterable(json.get("remove"), Function.identity()).forEach(element -> fluids.addAll(FluidTagsConfigHandler.getFluids(id, element, allowMissing)));
                    if (fluids.isEmpty()) {
                        FLUID_TAGS.removeAll((Object)id);
                    } else {
                        FLUID_TAGS.putAll((Object)id, (Iterable)Sets.difference(new HashSet(FLUID_TAGS.removeAll((Object)id)), fluids));
                    }
                } else {
                    HashSet fluids = new HashSet();
                    if (json.has("fluids")) {
                        FluidloggedAPIConfigs.getAsIterable(json.get("fluids"), Function.identity()).forEach(element -> fluids.addAll(FluidTagsConfigHandler.getFluids(id, element, allowMissing)));
                    }
                    FLUID_TAGS.putAll((Object)id, fluids);
                }
            }
            catch (Throwable t) {
                new JsonParseException(String.format(error, file), t).printStackTrace();
            }
        });
    }

    @Nonnull
    public static Collection<Fluid> getFluids(@Nonnull String tagId, boolean allowMissing) {
        if (FLUID_TAGS == null) {
            throw new IllegalStateException("FluidTagsConfigHandler::getFluids can only be called while reading blacklist.cfg & whitelist.cfg!");
        }
        Collection fluids = FLUID_TAGS.get((Object)tagId);
        if (allowMissing || !fluids.isEmpty()) {
            return fluids;
        }
        throw new JsonParseException("Fluidlogged API Config: No fluids were found from fluidTag: \"" + tagId + '\"');
    }

    @Nonnull
    public static Collection<Fluid> getFluids(@Nullable String tagId, @Nonnull JsonElement element, boolean allowMissing) {
        JsonObject json;
        if (element.isJsonPrimitive() || element.isJsonObject() && element.getAsJsonObject().has("fluidId")) {
            Fluid fluid = FluidTagsConfigHandler.getFluid(tagId, element.isJsonObject() ? JsonUtils.func_151206_a((JsonElement)element.getAsJsonObject().get("fluidId"), (String)"fluidId") : JsonUtils.func_151206_a((JsonElement)element, (String)"fluidId"), allowMissing);
            return fluid != null ? Collections.singleton(fluid) : Collections.emptySet();
        }
        if (element.isJsonObject() && (json = element.getAsJsonObject()).has("materialId")) {
            Fluid fluid = FluidTagsConfigHandler.getFluid(tagId, JsonUtils.func_151200_h((JsonObject)json, (String)"materialId"), allowMissing);
            if (fluid == null) {
                return Collections.emptySet();
            }
            if (!fluid.canBePlacedInWorld()) {
                throw new JsonParseException("Fluidlogged API Config: Cannot parse material: \"" + JsonUtils.func_151200_h((JsonObject)json, (String)"materialId") + (tagId != null ? "\" in fluidTag: \"" + tagId + '\"' : "\""));
            }
            Material material = fluid.getBlock().func_176223_P().func_185904_a();
            Collection fluids = FluidRegistry.getRegisteredFluids().values().stream().filter(fluidIn -> fluidIn.canBePlacedInWorld() && fluidIn.getBlock().func_176223_P().func_185904_a() == material && !FluidTagsConfigHandler.isNonFluidloggable(fluidIn.getBlock())).collect(Collectors.toSet());
            if (allowMissing || !fluids.isEmpty()) {
                return fluids;
            }
            throw new JsonParseException("Fluidlogged API Config: No valid fluidloggable fluids were found from material: \"" + JsonUtils.func_151200_h((JsonObject)json, (String)"materialId") + (tagId != null ? "\" in fluidTag: \"" + tagId + '\"' : "\""));
        }
        if (allowMissing) {
            return Collections.emptySet();
        }
        throw new JsonParseException("Missing fluidId or materialId, expected to find a string");
    }

    @Nullable
    static Fluid getFluid(@Nullable String tagId, @Nonnull String fluidId, boolean allowMissing) {
        Fluid fluid = FluidloggedUtils.getFluidFromBlock(Block.func_149684_b((String)fluidId));
        if (fluid == null) {
            fluid = FluidRegistry.getFluid((String)fluidId);
        }
        if (fluid == null) {
            if (!allowMissing) {
                throw new JsonParseException("Fluidlogged API Config: Unable to parse fluid: \"" + fluidId + (tagId != null ? "\" from fluidTag: \"" + tagId + '\"' : "\""));
            }
            return null;
        }
        if (FluidTagsConfigHandler.isNonFluidloggable(fluid.getBlock())) {
            throw new JsonParseException("Fluidlogged API Config: Specified fluid cannot be fluidlogged: \"" + fluidId + (tagId != null ? "\" in fluidTag: \"" + tagId + '\"' : "\""));
        }
        return fluid;
    }

    static boolean isNonFluidloggable(@Nullable Block block) {
        if (!(block instanceof IFluidloggableFluid) || block.getRegistryName() == null) {
            return true;
        }
        IFluidloggableFluid handler = (IFluidloggableFluid)block;
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (!handler.isFluidloggableFluid(FluidState.of(state))) continue;
            return false;
        }
        return true;
    }
}

