/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.config.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import git.jbredwards.fluidlogged_api.mod.asm.iface.ICanFluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigAccessor;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.FluidTagsConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicate;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicateOperation;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ConfigPredicateHelper {
    @Nonnull
    final IntList metadata = new IntArrayList();
    @Nonnull
    final List<JsonObject> stateArgs = new ArrayList<JsonObject>();
    @Nonnull
    final List<IConfigFluidBox.HeightBox> boxes;
    final boolean allowMissing;
    @Nonnull
    ConfigPredicate predicate;
    @Nullable
    final ICanFluidFlowHandler flowHandler;
    @Nonnull
    final ConfigPredicateOperation operation;

    public ConfigPredicateHelper(@Nonnull JsonObject json, @Nonnull UnaryOperator<ICanFluidFlowHandler> flowTransformer) {
        this.operation = json.has("replace") ? ConfigPredicateOperation.get(JsonUtils.func_151206_a((JsonElement)json.get("replace"), (String)"replace")) : ConfigPredicateOperation.always;
        HashSet fluids = new HashSet();
        IntArrayList fluidLevels = new IntArrayList();
        boolean bl = this.allowMissing = json.has("allowMissing") && JsonUtils.func_151216_b((JsonElement)json.get("allowMissing"), (String)"allowMissing");
        if (json.has("metadata")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("metadata"), element -> JsonUtils.func_151215_f((JsonElement)element, (String)"meta")).forEach(arg_0 -> this.metadata.add(arg_0));
        }
        if (json.has("states")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("states"), element -> JsonUtils.func_151210_l((JsonElement)element, (String)"state")).forEach(this.stateArgs::add);
        }
        if (json.has("fluidLevels")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("fluidLevels"), element -> JsonUtils.func_151215_f((JsonElement)element, (String)"fluidLevel")).forEach(arg_0 -> ((IntList)fluidLevels).add(arg_0));
        }
        if (json.has("fluids")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("fluids"), Function.identity()).forEach(element -> fluids.addAll(FluidTagsConfigHandler.getFluids(null, element, this.allowMissing)));
        }
        if (json.has("fluidTags")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("fluidTags"), element -> JsonUtils.func_151206_a((JsonElement)element, (String)"fluidTag")).forEach(tagId -> fluids.addAll(FluidTagsConfigHandler.getFluids(tagId, this.allowMissing)));
        }
        ArrayList builder = new ArrayList();
        if (json.has("boxes")) {
            FluidloggedAPIConfigs.getAsIterable(json.get("boxes"), element -> JsonUtils.func_151210_l((JsonElement)element, (String)"box")).forEach(box -> {
                JsonElement min = box.get("min");
                JsonElement max = box.get("max");
                if (min == null) {
                    throw new JsonSyntaxException("Missing min, expected to find a number");
                }
                if (max == null) {
                    throw new JsonSyntaxException("Missing max, expected to find a number");
                }
                if (!min.isJsonPrimitive() || !min.getAsJsonPrimitive().isNumber()) {
                    throw new JsonSyntaxException("Expected min to be a number, was " + JsonUtils.func_151222_d((JsonElement)min));
                }
                if (!max.isJsonPrimitive() || !max.getAsJsonPrimitive().isNumber()) {
                    throw new JsonSyntaxException("Expected max to be a number, was " + JsonUtils.func_151222_d((JsonElement)max));
                }
                builder.add(new IConfigFluidBox.HeightBox(min.getAsDouble() / 16.0, max.getAsDouble() / 16.0));
            });
        }
        this.boxes = Collections.unmodifiableList(builder);
        if (fluidLevels.isEmpty()) {
            boolean requireSource;
            boolean bl2 = requireSource = json.has("requireSource") && JsonUtils.func_151216_b((JsonElement)json.get("requireSource"), (String)"requireSource");
            this.predicate = fluids.isEmpty() ? (requireSource ? ConfigPredicate.TRUE_FOR_SOURCE : ConfigPredicate.TRUE_FOR_SIDE) : (requireSource ? (world, pos, state, fluidState) -> ConfigPredicate.TRUE_FOR_SOURCE.test(world, pos, state, fluidState) && (fluidState.isEmpty() || fluids.contains(fluidState.getFluid())) : (world, pos, state, fluidState) -> ConfigPredicate.TRUE_FOR_SIDE.test(world, pos, state, fluidState) && (fluidState.isEmpty() || fluids.contains(fluidState.getFluid())));
        } else {
            boolean[] levels = new boolean[Ints.max((int[])fluidLevels.toIntArray()) + 1];
            IntListIterator it = fluidLevels.iterator();
            while (it.hasNext()) {
                levels[it.nextInt()] = true;
            }
            this.predicate = fluids.isEmpty() ? (world, pos, state, fluidState) -> fluidState.isEmpty() || fluidState.getLevel() < levels.length && levels[fluidState.getLevel()] : (world, pos, state, fluidState) -> fluidState.isEmpty() || fluidState.getLevel() < levels.length && levels[fluidState.getLevel()] && fluids.contains(fluidState.getFluid());
        }
        if (json.has("canFluidFlow")) {
            JsonElement canFluidFlow = json.get("canFluidFlow");
            if (canFluidFlow.isJsonPrimitive() && canFluidFlow.getAsJsonPrimitive().isBoolean()) {
                this.flowHandler = (ICanFluidFlowHandler)flowTransformer.apply(canFluidFlow.getAsBoolean() ? ICanFluidFlowHandler.ALWAYS_FLOW : ICanFluidFlowHandler.NEVER_FLOW);
            } else {
                boolean[] sides = new boolean[EnumFacing.field_82609_l.length];
                FluidloggedAPIConfigs.getAsIterable(canFluidFlow, JsonElement::getAsString).forEach(side -> {
                    sides[Objects.requireNonNull(EnumFacing.func_176739_a((String)side), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$null$12(java.lang.String ), ()Ljava/lang/String;)((String)side)).func_176745_a()] = true;
                });
                this.flowHandler = (ICanFluidFlowHandler)flowTransformer.apply((world, pos, state, side) -> sides[side.func_176745_a()]);
            }
        } else {
            this.flowHandler = json.has("useDeprecatedSideCheck") && JsonUtils.func_151216_b((JsonElement)json.get("useDeprecatedSideCheck"), (String)"useDeprecatedSideCheck") ? ICanFluidFlowHandler.DEPRECATED_CHECK : null;
        }
    }

    public void forEachState(@Nonnull Block base, @Nonnull Function<IConfigAccessor, ConfigPredicate> getter, @Nonnull BiConsumer<IConfigAccessor, ConfigPredicate> setter) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        if (!this.stateArgs.isEmpty()) {
            this.stateArgs.forEach(json -> {
                HashMultimap properties = HashMultimap.create();
                json.entrySet().forEach(arg_0 -> this.lambda$null$15(base, (Multimap)properties, arg_0));
                if (!properties.isEmpty()) {
                    block0: for (IBlockState state : base.func_176194_O().func_177619_a()) {
                        for (IProperty prop : properties.keySet()) {
                            if (properties.containsEntry((Object)prop, (Object)NBTUtil.func_190010_a((IProperty)prop, (Comparable)state.func_177229_b(prop)))) continue;
                            continue block0;
                        }
                        states.add(state);
                    }
                }
            });
            if (states.isEmpty() && !this.allowMissing) {
                throw new JsonParseException(String.format("Could not parse any states from block \"%s\" with properties: %s", base.getRegistryName(), this.stateArgs));
            }
        }
        if (!this.metadata.isEmpty()) {
            IntListIterator it = this.metadata.iterator();
            while (it.hasNext()) {
                states.add(base.func_176203_a(it.nextInt()));
            }
        } else if (this.stateArgs.isEmpty()) {
            states.addAll((Collection<IBlockState>)base.func_176194_O().func_177619_a());
        }
        Iterator iterator = states.stream().map(state -> (IConfigAccessor)(state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).getClean() : state)).collect(Collectors.toSet()).iterator();
        while (iterator.hasNext()) {
            IConfigAccessor state2;
            setter.accept(state2, getter.apply(state2 = (IConfigAccessor)iterator.next()) != null ? (ConfigPredicate)this.operation.apply(getter.apply(state2), this.predicate) : this.predicate);
            if (this.flowHandler != null && (this.operation != ConfigPredicateOperation.never || ((ICanFluidFlowHandler.Accessor)((Object)state2)).getCanFluidFlowOverride() == null)) {
                ICanFluidFlowHandler.Accessor.setOverride(state2, this.flowHandler);
            }
            ((IConfigFluidBox)((Object)state2)).setBoxes(this.boxes.isEmpty() ? null : this.boxes);
        }
    }

    private /* synthetic */ void lambda$null$15(Block base, Multimap properties, Map.Entry entry) {
        IProperty prop = base.func_176194_O().func_185920_a((String)entry.getKey());
        if (prop != null) {
            properties.putAll((Object)prop, FluidloggedAPIConfigs.getAsIterable((JsonElement)entry.getValue(), JsonElement::getAsString));
        } else if (!this.allowMissing) {
            throw new JsonParseException(String.format("Could not parse property \"%s\" from block \"%s\".", entry.getKey(), base.getRegistryName()));
        }
    }

    private static /* synthetic */ String lambda$null$12(String side) {
        return "Cannot get side from \"" + side + '\"';
    }
}

