/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.handler;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public final class FluidMixHandler {
    public static boolean tryMixAtNeighbors(@Nonnull FluidState source, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Collection<MixCondition> mixConditions, @Nullable BiConsumer<World, BlockPos> mixEffects) {
        FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 1, 1);
        boolean ret = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Optional<IBlockState> result;
            BlockPos offset;
            if (side == source.getUpDensityFace() || FluidloggedAPIConfig.fixBadFluidMixing && !FluidloggedUtils.canFluidFlow(cache, pos, cache.func_180495_p(pos), side) || FluidloggedUtils.isCompatibleFluid(source, cache.getFluidOrReal((Vec3i)(offset = pos.func_177972_a(side)))) || !(result = mixConditions.stream().map(condition -> condition.getMixResult(source, cache, offset, pos, side)).filter(Objects::nonNull).findFirst()).isPresent() || !(ret = world.func_175656_a(offset, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)offset, (BlockPos)pos, (IBlockState)result.get()))) || mixEffects == null) continue;
            mixEffects.accept(world, offset);
        }
        return ret;
    }

    @Nonnull
    public static MixCondition forFluid(@Nonnull MixCondition mixCondition) {
        return (source, access, pos, sourcePos, side) -> (!FluidloggedAPIConfig.fixBadFluidMixing || FluidloggedUtils.canFluidFlow(access, pos, access.func_180495_p(pos), side.func_176734_d())) && access.func_180495_p(pos).func_177230_c().func_176200_f(access, pos) ? mixCondition.getMixResult(source, access, pos, sourcePos, side) : null;
    }

    @FunctionalInterface
    public static interface MixCondition {
        @Nullable
        public IBlockState getMixResult(@Nonnull FluidState var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nonnull BlockPos var4, @Nonnull EnumFacing var5);
    }
}

