/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.util;

import git.jbredwards.fluidlogged_api.api.fluid.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConditionalFluid;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.IFluidNeighborInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public interface ISpecializedFluidNeighborInfo
extends IFluidNeighborInfo {
    @Nullable
    public Boolean getDoFireTick();

    @Nonnull
    public Boolean setDoFireTick(@Nullable Boolean var1);

    public boolean canDisplaceI(int var1, int var2, int var3);

    default public boolean canFlowIntoI(int xi, int yi, int zi, int flowMeta, @Nonnull EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        int xio = xi + sideToCheck.func_176730_m().func_177958_n();
        int yio = yi + sideToCheck.func_176730_m().func_177956_o() * -this.getOrigin().getDensityDir();
        int zio = zi + sideToCheck.func_176730_m().func_177952_p();
        if (this.getOrigin().getBlock() instanceof IConditionalFluid && ((IConditionalFluid)this.getOrigin().getBlock()).cannotFlowAt(this.getCache(), this.getPosIB(xio, yio, zio), this.getOrigin().withLevel(flowMeta))) {
            return false;
        }
        return this.canFluidFlowI(xi, yi, zi, sideToCheck) && (this.isReplaceableI(xio, yio, zio, this.getOrigin().withLevel(flowMeta), sideToCheck.func_176734_d(), checkReplaceable, allowMatching) || this.canFluidFlowI(xio, yio, zio, sideToCheck.func_176734_d()) && this.isFluidloggableI(xio, yio, zio, this.getOrigin().withLevel(flowMeta), sideToCheck.func_176734_d(), checkReplaceable, allowMatching));
    }

    public int getEffectiveQuantaI(int var1, int var2, int var3);

    default public boolean hasVerticalFlowI(int xi, int yi, int zi) {
        return this.isCompatibleFluidI(xi, yi + 1, zi) && this.canFluidFlowI(xi, yi, zi, this.getOrigin().getUpDensityFace()) && this.canFluidFlowI(xi, yi + 1, zi, this.getOrigin().getDownDensityFace());
    }

    default public boolean isFluidloggableI(int xi, int yi, int zi, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        FluidState existing;
        if (checkReplaceable && (existing = this.getFluidStateI(xi, yi, zi)).getBlock() instanceof IFluidloggableFluid && !((IFluidloggableFluid)existing.getBlock()).isReplaceableByOther(this.getCache().getWorld(), existing, fluidToPlace, allowMatching)) {
            return false;
        }
        if (this.isVaporizableI(xi, yi, zi, fluidToPlace, sideToCheck)) {
            return true;
        }
        return FluidloggedUtils.isStateFluidloggable(this.getBlockStateI(xi, yi, zi), this.getCache(), this.getPosIB(xi, yi, zi), fluidToPlace);
    }

    default public boolean isReplaceableI(int xi, int yi, int zi, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        FluidState existing;
        if (checkReplaceable && (existing = this.getFluidStateI(xi, yi, zi)).getBlock() instanceof IFluidloggableFluid && !((IFluidloggableFluid)existing.getBlock()).isReplaceableByOther(this.getCache().getWorld(), existing, fluidToPlace, allowMatching)) {
            return false;
        }
        if (this.isVaporizableI(xi, yi, zi, fluidToPlace, sideToCheck)) {
            return true;
        }
        return this.getCache().func_175623_d(this.getPosIB(xi, yi, zi)) || this.canDisplaceI(xi, yi, zi) && !this.isFluidloggableI(xi, yi, zi, fluidToPlace.toSource(), sideToCheck, false, false);
    }

    default public boolean isVaporizableI(int xi, int yi, int zi, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck) {
        if (FluidloggedAPIConfig.lavalogVaporizeFlammable != FluidloggedAPIConfig.LavaVaporizingMode.NEVER && fluidToPlace.getMaterial() == Material.field_151587_i && !this.getCache().getWorld().func_189509_E(this.getPosIB(xi, yi, zi)) && (this.getDoFireTick() == null ? this.setDoFireTick(this.getCache().getWorld().func_82736_K().func_82766_b("doFireTick")) : this.getDoFireTick()).booleanValue() && this.getBlockStateI(xi, yi, zi).func_185904_a().func_76217_h()) {
            if (this.isCompatibleFluidI(xi, yi, zi)) {
                return true;
            }
            if (this.getFluidStateI(xi, yi, zi).isEmpty()) {
                return FluidloggedAPIConfig.lavalogVaporizeFlammable == FluidloggedAPIConfig.LavaVaporizingMode.FLAMMABLE;
            }
        }
        return false;
    }

    default public boolean canDisplace(int x, int y, int z) {
        return this.canDisplaceI(this.getXI(x), this.getYI(y), this.getZI(z));
    }

    default public boolean canFlowInto(int x, int y, int z, int flowMeta, @Nonnull EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        return this.canFlowIntoI(this.getXI(x), this.getYI(y), this.getZI(z), flowMeta, sideToCheck, checkReplaceable, allowMatching);
    }

    default public int getEffectiveQuanta(int x, int y, int z) {
        return this.getEffectiveQuantaI(this.getXI(x), this.getYI(y), this.getZI(z));
    }

    default public boolean hasVerticalFlow(int x, int y, int z) {
        return this.hasVerticalFlowI(this.getXI(x), this.getYI(y), this.getZI(z));
    }

    default public boolean isFluidloggable(int x, int y, int z, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        return this.isFluidloggableI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, sideToCheck, checkReplaceable, allowMatching);
    }

    default public boolean isReplaceable(int x, int y, int z, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck, boolean checkReplaceable, boolean allowMatching) {
        return this.isReplaceableI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, sideToCheck, checkReplaceable, allowMatching);
    }

    default public boolean isVaporizable(int x, int y, int z, @Nonnull FluidState fluidToPlace, @Nullable EnumFacing sideToCheck) {
        return this.isVaporizableI(this.getXI(x), this.getYI(y), this.getZI(z), fluidToPlace, sideToCheck);
    }

    public static interface Vanilla
    extends ISpecializedFluidNeighborInfo {
        @Override
        default public boolean canDisplaceI(int xi, int yi, int zi) {
            IBlockState state = this.getBlockStateI(xi, yi, zi);
            if (FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromState(state), this.getOrigin().getFluid())) {
                return true;
            }
            if (!(state.func_177230_c() instanceof BlockDoor) && state.func_177230_c() != Blocks.field_150472_an && state.func_177230_c() != Blocks.field_150468_ap && state.func_177230_c() != Blocks.field_150436_aH) {
                return !state.func_185904_a().func_76230_c() && state.func_185904_a() != Material.field_151567_E && state.func_185904_a() != Material.field_189963_J;
            }
            return true;
        }

        @Override
        default public int getEffectiveQuantaI(int xi, int yi, int zi) {
            FluidState fluidState = this.getFluidStateI(xi, yi, zi);
            if (!FluidloggedUtils.isCompatibleFluid(fluidState, this.getOrigin())) {
                return this.getCache().func_175623_d(this.getPosIB(xi, yi, zi)) ? 0 : -1;
            }
            int quantaValue = fluidState.getLevel();
            return quantaValue >= 8 ? 8 : 8 - quantaValue;
        }
    }

    public static interface Forge
    extends ISpecializedFluidNeighborInfo {
        @Override
        default public boolean canDisplaceI(int xi, int yi, int zi) {
            IBlockState state = this.getBlockStateI(xi, yi, zi);
            if (FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromState(state), this.getOrigin().getFluid())) {
                return true;
            }
            Boolean displacement = this.getOrigin().getDisplacements().get(state.func_177230_c());
            if (displacement != null) {
                return displacement;
            }
            Material material = state.func_185904_a();
            return !material.func_76230_c() && material != Material.field_151567_E && material != Material.field_189963_J;
        }

        @Override
        default public int getEffectiveQuantaI(int xi, int yi, int zi) {
            FluidState fluidState = this.getFluidStateI(xi, yi, zi);
            if (!FluidloggedUtils.isCompatibleFluid(fluidState, this.getOrigin())) {
                return this.getCache().func_175623_d(this.getPosIB(xi, yi, zi)) ? 0 : -1;
            }
            int quantaValue = fluidState.getQuantaValue();
            return quantaValue > 0 && quantaValue < this.getOrigin().getQuantaPerBlock() && this.hasVerticalFlowI(xi, yi, zi) ? this.getOrigin().getQuantaPerBlock() : quantaValue;
        }
    }
}

