/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.fluid.util.impl;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.IFluidNeighborInfo;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class FluidNeighborInfo
implements IFluidNeighborInfo {
    @Nonnull
    public final FluidCache cache;
    @Nonnull
    public final FluidState originState;
    public final int originX;
    public final int originY;
    public final int originZ;

    public FluidNeighborInfo(@Nonnull IBlockAccess accessIn, @Nonnull BlockPos originIn, @Nonnull FluidState originStateIn, int radius) {
        if (accessIn instanceof FluidCache) {
            FluidCache cacheIn = (FluidCache)accessIn;
            this.cache = cacheIn.minX <= originIn.func_177958_n() - radius && cacheIn.maxZ >= originIn.func_177958_n() + radius && cacheIn.minY <= originIn.func_177956_o() - 1 && cacheIn.maxY >= originIn.func_177956_o() + 1 && cacheIn.minZ <= originIn.func_177952_p() - radius && cacheIn.maxZ >= originIn.func_177952_p() + radius ? cacheIn : new FluidCache(cacheIn.getWrapped(), (Vec3i)originIn, radius, 1);
        } else {
            this.cache = new FluidCache(accessIn, (Vec3i)originIn, radius, 1);
        }
        this.originState = originStateIn;
        this.originX = originIn.func_177958_n();
        this.originY = originIn.func_177956_o();
        this.originZ = originIn.func_177952_p();
    }

    @Override
    @Nonnull
    public FluidCache getCache() {
        return this.cache;
    }

    @Override
    @Nonnull
    public FluidState getOrigin() {
        return this.originState;
    }

    @Override
    public int getOriginX() {
        return this.originX;
    }

    @Override
    public int getOriginY() {
        return this.originY;
    }

    @Override
    public int getOriginZ() {
        return this.originZ;
    }
}

