/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.message;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SMessageSyncFluidState
extends AbstractMessage {
    public BlockPos pos;
    public FluidState state;
    public boolean doRenderUpdate;

    public SMessageSyncFluidState() {
    }

    public SMessageSyncFluidState(@Nonnull BlockPos posIn, @Nonnull FluidState stateIn, boolean doRenderUpdateIn) {
        this.isValid = true;
        this.pos = posIn;
        this.state = stateIn;
        this.doRenderUpdate = doRenderUpdateIn;
    }

    @Override
    public void read(@Nonnull PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.state = FluidState.deserialize(buf.func_150792_a());
        this.doRenderUpdate = buf.readBoolean();
    }

    @Override
    public void write(@Nonnull PacketBuffer buf) {
        buf.func_179255_a(this.pos).func_150787_b(this.state.serialize()).writeBoolean(this.doRenderUpdate);
    }

    public static enum Handler implements IClientMessageHandler<SMessageSyncFluidState>
    {
        INSTANCE;


        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull SMessageSyncFluidState message, @Nonnull MessageContext ctx) {
            WorldClient world = IClientMessageHandler.getWorldFromContext(ctx);
            Chunk chunk = world.func_175726_f(message.pos);
            IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
            if (cap != null) {
                cap.getContainer(message.pos.func_177956_o()).setFluidState(message.pos, message.state);
                FluidloggedUtils.relightFluidBlock((World)world, message.pos, chunk, message.state);
                if (message.doRenderUpdate) {
                    world.func_175704_b(message.pos, message.pos);
                }
            }
        }
    }
}

