/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common.message;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateContainer;
import git.jbredwards.fluidlogged_api.api.network.IClientMessageHandler;
import git.jbredwards.fluidlogged_api.api.network.message.AbstractMessage;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityVanilla;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateLayer;
import it.unimi.dsi.fastutil.chars.AbstractChar2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;

public final class SMessageSyncFluidStates
extends AbstractMessage {
    public Char2ObjectMap.Entry<FluidState>[] data;
    public int chunkX;
    public int indexY;
    public int chunkZ;
    public int layersLength = -1;
    public int lowestYPos = 65535;

    public SMessageSyncFluidStates() {
        this.data = new Char2ObjectMap.Entry[0];
    }

    public SMessageSyncFluidStates(@Nonnull Chunk chunk, @Nonnull IFluidStateCapability cap) {
        this(chunk.field_76635_g, 0, chunk.field_76647_h, cap);
    }

    public SMessageSyncFluidStates(int chunkXIn, int indexYIn, int chunkZIn, @Nonnull IFluidStateCapability cap) {
        IFluidStateContainer container = cap.getContainer(this.indexY);
        MutableInt currIndex = new MutableInt(-1);
        this.data = new Char2ObjectMap.Entry[container.getSerializedPositions().size()];
        container.forEach((pos, fluidState) -> {
            this.data[currIndex.incrementAndGet()] = new AbstractChar2ObjectMap.BasicEntry(pos, (Object)fluidState);
        });
        this.isValid = true;
        this.chunkX = chunkXIn;
        this.indexY = indexYIn;
        this.chunkZ = chunkZIn;
        if (container instanceof FluidStateCapabilityVanilla) {
            this.layersLength = ((FluidStateCapabilityVanilla)container).layers.length;
            this.lowestYPos = ((FluidStateCapabilityVanilla)container).lowestYPos;
        }
    }

    @Override
    public void read(@Nonnull PacketBuffer buf) {
        this.chunkX = buf.func_150792_a();
        this.indexY = buf.func_150792_a();
        this.chunkZ = buf.func_150792_a();
        this.data = new Char2ObjectMap.Entry[buf.func_150792_a()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new AbstractChar2ObjectMap.BasicEntry(buf.readChar(), (Object)FluidState.deserialize(buf.func_150792_a()));
        }
        if (buf.readBoolean()) {
            this.layersLength = buf.func_150792_a();
            this.lowestYPos = buf.readChar();
        }
    }

    @Override
    public void write(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.chunkX).func_150787_b(this.indexY).func_150787_b(this.chunkZ);
        buf.func_150787_b(this.data.length);
        for (Char2ObjectMap.Entry<FluidState> entry : this.data) {
            buf.writeChar((int)entry.getCharKey());
            buf.func_150787_b(((FluidState)((Object)entry.getValue())).serialize());
        }
        if (this.layersLength == -1) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_150787_b(this.layersLength).writeChar(this.lowestYPos);
        }
    }

    public static enum Handler implements IClientMessageHandler<SMessageSyncFluidStates>
    {
        INSTANCE;


        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMessage(@Nonnull SMessageSyncFluidStates message, @Nonnull MessageContext ctx) {
            WorldClient world = IClientMessageHandler.getWorldFromContext(ctx);
            Chunk chunk = world.func_72964_e(message.chunkX, message.chunkZ);
            IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
            if (cap != null) {
                BlockPos pos;
                IFluidStateContainer container = cap.getContainer(message.indexY);
                char[] oldIndexes = container.getSerializedPositions().toCharArray();
                container.clearFluidStates();
                if (container instanceof FluidStateCapabilityVanilla) {
                    ((FluidStateCapabilityVanilla)container).layers = new FluidStateLayer[message.layersLength];
                    ((FluidStateCapabilityVanilla)container).lowestYPos = (char)message.lowestYPos;
                }
                for (Char2ObjectMap.Entry<FluidState> entry : message.data) {
                    container.setFluidState(entry.getCharKey(), (FluidState)((Object)entry.getValue()));
                    pos = container.deserializePos(entry.getCharKey());
                    FluidloggedUtils.relightFluidBlock((World)world, pos, chunk, (FluidState)((Object)entry.getValue()));
                    world.func_175704_b(pos, pos);
                }
                for (char serializedPos : oldIndexes) {
                    if (container.hasFluidState(serializedPos)) continue;
                    pos = container.deserializePos(serializedPos);
                    FluidloggedUtils.relightFluidBlock((World)world, pos, chunk, FluidState.EMPTY);
                    world.func_175704_b(pos, pos);
                }
            }
        }
    }
}

