/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.doos.DominionDOO;
import cn.lunadeer.dominion.doos.MemberDOO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberCache
extends Cache {
    private final Integer serverId;
    private volatile ConcurrentHashMap<Integer, MemberDTO> idMembers;
    private volatile ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> dominionMembersMap;
    private volatile ConcurrentHashMap<UUID, Map<Integer, Integer>> playerDominionMemberMap;
    private volatile ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> groupMembersMap;

    public MemberCache(Integer serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull Player player) {
        return this.getMember(dominion, player.getUniqueId());
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull UUID player_uuid) {
        if (dominion == null) {
            return null;
        }
        ConcurrentHashMap<UUID, Map<Integer, Integer>> currentPlayerDominionMemberMap = this.playerDominionMemberMap;
        ConcurrentHashMap<Integer, MemberDTO> currentIdMembers = this.idMembers;
        if (currentPlayerDominionMemberMap == null || currentIdMembers == null || !currentPlayerDominionMemberMap.containsKey(player_uuid)) {
            return null;
        }
        Map<Integer, Integer> playerMemberMap = currentPlayerDominionMemberMap.get(player_uuid);
        if (playerMemberMap == null) {
            return null;
        }
        Integer member_id = playerMemberMap.get(dominion.getId());
        if (member_id == null) {
            return null;
        }
        return currentIdMembers.get(member_id);
    }

    public List<MemberDTO> getMemberBelongedDominions(@NotNull UUID player) {
        ConcurrentHashMap<UUID, Map<Integer, Integer>> currentPlayerDominionMemberMap = this.playerDominionMemberMap;
        ConcurrentHashMap<Integer, MemberDTO> currentIdMembers = this.idMembers;
        if (currentPlayerDominionMemberMap == null || currentIdMembers == null || !currentPlayerDominionMemberMap.containsKey(player)) {
            return new ArrayList<MemberDTO>();
        }
        Map<Integer, Integer> playerMemberMap = currentPlayerDominionMemberMap.get(player);
        if (playerMemberMap == null) {
            return new ArrayList<MemberDTO>();
        }
        Collection<Integer> member_ids = playerMemberMap.values();
        return this.getMembersByIDs(currentIdMembers, member_ids);
    }

    @NotNull
    private List<MemberDTO> getMembersByIDs(ConcurrentHashMap<Integer, MemberDTO> currentIdMembers, Collection<Integer> member_ids) {
        ArrayList<MemberDTO> members = new ArrayList<MemberDTO>();
        for (Integer member_id : member_ids) {
            MemberDTO member = currentIdMembers.get(member_id);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    @NotNull
    public List<MemberDTO> getDominionMembers(@NotNull DominionDTO dominion) {
        return this.getDominionMembers(dominion.getId());
    }

    @NotNull
    public List<MemberDTO> getDominionMembers(@NotNull Integer dominionId) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> currentDominionMembersMap = this.dominionMembersMap;
        return this.getMembersByIDs(dominionId, currentDominionMembersMap);
    }

    @NotNull
    private List<MemberDTO> getMembersByIDs(@NotNull Integer dominionId, ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> currentDominionMembersMap) {
        ConcurrentHashMap<Integer, MemberDTO> currentIdMembers = this.idMembers;
        if (currentDominionMembersMap == null || currentIdMembers == null || !currentDominionMembersMap.containsKey(dominionId)) {
            return new ArrayList<MemberDTO>();
        }
        CopyOnWriteArrayList<Integer> memberIds = currentDominionMembersMap.get(dominionId);
        if (memberIds == null) {
            return new ArrayList<MemberDTO>();
        }
        return this.getMembersByIDs(currentIdMembers, memberIds);
    }

    @NotNull
    public List<MemberDTO> getGroupMembers(@NotNull GroupDTO group) {
        return this.getGroupMembers(group.getId());
    }

    @NotNull
    public List<MemberDTO> getGroupMembers(@NotNull Integer groupId) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> currentGroupMembersMap = this.groupMembersMap;
        return this.getMembersByIDs(groupId, currentGroupMembersMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadExecution() throws Exception {
        ConcurrentHashMap<Integer, MemberDOO> tempIdMembers = new ConcurrentHashMap<Integer, MemberDOO>();
        ConcurrentHashMap<Integer, CopyOnWriteArrayList> tempDominionMembersMap = new ConcurrentHashMap<Integer, CopyOnWriteArrayList>();
        ConcurrentHashMap<UUID, Map> tempPlayerDominionMemberMap = new ConcurrentHashMap<UUID, Map>();
        ConcurrentHashMap<Integer, CopyOnWriteArrayList> tempGroupMembersMap = new ConcurrentHashMap<Integer, CopyOnWriteArrayList>();
        List<MemberDOO> allMembers = MemberDOO.select();
        for (MemberDOO member : allMembers) {
            PlayerDTO player = CacheManager.instance.getPlayer(member.getPlayerUUID());
            if (player == null) {
                DominionDOO.deleteByPlayerUuid(member.getPlayerUUID());
                MemberDOO.deleteByPlayerUuid(member.getPlayerUUID());
                continue;
            }
            DominionDTO dominion = CacheManager.instance.getDominion(member.getDomID());
            if (dominion == null || !Objects.equals(dominion.getServerId(), this.serverId)) continue;
            tempIdMembers.put(member.getId(), member);
            tempDominionMembersMap.computeIfAbsent(member.getDomID(), k -> new CopyOnWriteArrayList()).add(member.getId());
            tempPlayerDominionMemberMap.computeIfAbsent(member.getPlayerUUID(), k -> new ConcurrentHashMap()).put(member.getDomID(), member.getId());
            if (member.getGroupId() == -1) continue;
            tempGroupMembersMap.computeIfAbsent(member.getGroupId(), k -> new CopyOnWriteArrayList()).add(member.getId());
        }
        MemberCache memberCache = this;
        synchronized (memberCache) {
            this.idMembers = tempIdMembers;
            this.dominionMembersMap = tempDominionMembersMap;
            this.playerDominionMemberMap = tempPlayerDominionMemberMap;
            this.groupMembersMap = tempGroupMembersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        MemberDOO member = MemberDOO.select(idToLoad);
        if (member == null) {
            MemberCache memberCache = this;
            synchronized (memberCache) {
                MemberDTO removed;
                if (this.idMembers != null && (removed = this.idMembers.remove(idToLoad)) != null) {
                    this.removeFromMappings(removed);
                }
            }
            return;
        }
        if (this.idMembers == null || this.dominionMembersMap == null || this.playerDominionMemberMap == null || this.groupMembersMap == null) {
            this.loadExecution();
            return;
        }
        MemberCache memberCache = this;
        synchronized (memberCache) {
            MemberDTO old = this.idMembers.put(member.getId(), member);
            if (old != null) {
                this.removeFromMappings(old);
            }
            this.addToMappings(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteExecution(Integer idToDelete) {
        if (this.idMembers == null) {
            return;
        }
        MemberCache memberCache = this;
        synchronized (memberCache) {
            MemberDTO member = this.idMembers.remove(idToDelete);
            if (member != null) {
                this.removeFromMappings(member);
            }
        }
    }

    private void removeFromMappings(MemberDTO member) {
        CopyOnWriteArrayList<Integer> groupMembers;
        Map<Integer, Integer> playerMemberMap;
        CopyOnWriteArrayList<Integer> dominionMembers;
        if (this.dominionMembersMap != null && (dominionMembers = this.dominionMembersMap.get(member.getDomID())) != null) {
            dominionMembers.remove(member.getId());
            if (dominionMembers.isEmpty()) {
                this.dominionMembersMap.remove(member.getDomID());
            }
        }
        if (this.playerDominionMemberMap != null && (playerMemberMap = this.playerDominionMemberMap.get(member.getPlayerUUID())) != null) {
            playerMemberMap.remove(member.getDomID());
            if (playerMemberMap.isEmpty()) {
                this.playerDominionMemberMap.remove(member.getPlayerUUID());
            }
        }
        if (member.getGroupId() != -1 && this.groupMembersMap != null && (groupMembers = this.groupMembersMap.get(member.getGroupId())) != null) {
            groupMembers.remove(member.getId());
            if (groupMembers.isEmpty()) {
                this.groupMembersMap.remove(member.getGroupId());
            }
        }
    }

    private void addToMappings(MemberDTO member) {
        if (this.dominionMembersMap != null) {
            this.dominionMembersMap.computeIfAbsent(member.getDomID(), k -> new CopyOnWriteArrayList()).addIfAbsent(member.getId());
        }
        if (this.playerDominionMemberMap != null) {
            this.playerDominionMemberMap.computeIfAbsent(member.getPlayerUUID(), k -> new ConcurrentHashMap()).put(member.getDomID(), member.getId());
        }
        if (member.getGroupId() != -1 && this.groupMembersMap != null) {
            this.groupMembersMap.computeIfAbsent(member.getGroupId(), k -> new CopyOnWriteArrayList()).addIfAbsent(member.getId());
        }
    }

    public Integer count() {
        ConcurrentHashMap<Integer, MemberDTO> currentIdMembers = this.idMembers;
        return currentIdMembers != null ? currentIdMembers.size() : 0;
    }
}

