/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.events.member;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.events.ResultEvent;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MemberSetFlagEvent
extends ResultEvent {
    private final DominionDTO dominion;
    private final PriFlag flag;
    private final boolean oldValue;
    private boolean newValue;
    private final MemberDTO member;
    private final CompletableFuture<MemberDTO> future = new CompletableFuture();

    public MemberSetFlagEvent(@NotNull CommandSender operator, @NotNull DominionDTO dominion, @NotNull MemberDTO member, @NotNull PriFlag flag, boolean newValue) {
        super(operator);
        this.dominion = dominion;
        this.flag = flag;
        this.oldValue = member.getFlagValue(flag);
        this.newValue = newValue;
        this.member = member;
    }

    @NotNull
    public DominionDTO getDominion() {
        return this.dominion;
    }

    public PriFlag getFlag() {
        return this.flag;
    }

    public boolean getOldValue() {
        return this.oldValue;
    }

    public boolean getNewValue() {
        return this.newValue;
    }

    public void setNewValue(boolean newValue) {
        this.newValue = newValue;
    }

    public MemberDTO getMember() {
        return this.member;
    }

    public CompletableFuture<MemberDTO> getFutureToComplete() {
        return this.future;
    }

    public CompletableFuture<Void> afterSet(Consumer<MemberDTO> consumer) {
        return this.future.thenAccept((Consumer)consumer);
    }
}

