/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.scui;

import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestView;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;

public class ChestListView
extends ChestView {
    private int pageSize = 45;
    private int currentPage = 1;
    private char itemSymbol = (char)105;
    private boolean layoutSet = false;
    private ListViewConfiguration configCopy;
    private final List<ChestButton> items = new ArrayList<ChestButton>();

    public ChestListView(@NotNull Player viewOwner) {
        super(viewOwner);
    }

    public ChestListView applyListConfiguration(@NotNull ListViewConfiguration config, int currentPage) {
        this.configCopy = config;
        if (currentPage < 1) {
            throw new IllegalArgumentException("Page number must be greater than 0.");
        }
        this.currentPage = currentPage;
        super.setLayout(config.layout);
        this.itemSymbol = config.itemSymbol.charAt(0);
        if (!this.getLayout().contains(String.valueOf(this.itemSymbol))) {
            throw new IllegalArgumentException("Layout must contain the item symbol: " + this.itemSymbol);
        }
        if (!this.getLayout().contains(String.valueOf(config.previewButton.getSymbol()))) {
            throw new IllegalArgumentException("Layout must contain the preview button symbol: " + config.previewButton.getSymbol());
        }
        if (!this.getLayout().contains(String.valueOf(config.nextButton.getSymbol()))) {
            throw new IllegalArgumentException("Layout must contain the next button symbol: " + config.nextButton.getSymbol());
        }
        this.pageSize = (int)this.getLayout().chars().filter(ch -> ch == this.itemSymbol).count();
        this.layoutSet = true;
        return this;
    }

    public ChestListView addItem(@NotNull ChestButton item) {
        this.items.add(item);
        return this;
    }

    public void clearCurrentItemButtons() {
        for (int i = 0; i < this.getLayout().length(); ++i) {
            if (this.getLayout().charAt(i) != this.itemSymbol) continue;
            this.removeButton(i);
        }
    }

    @Override
    public void open() {
        if (!this.layoutSet) {
            throw new IllegalStateException("List layout must be set before opening the view.");
        }
        this.clearCurrentItemButtons();
        int itemSymbolPosition = -1;
        for (int idx = 0; idx < this.items.size(); ++idx) {
            if (this.items.get(idx).getSymbol() != this.itemSymbol || idx < (this.currentPage - 1) * this.pageSize) continue;
            if (idx >= this.currentPage * this.pageSize) break;
            itemSymbolPosition = this.getLayout().indexOf(this.itemSymbol, itemSymbolPosition + 1);
            if (itemSymbolPosition >= this.getLayout().length()) {
                throw new IndexOutOfBoundsException("Not enough space in the layout for items.");
            }
            this.setButton(itemSymbolPosition, this.items.get(idx));
        }
        int totalPages = (int)Math.ceil((double)this.items.size() / (double)this.pageSize);
        this.setButton(this.configCopy.previewButton.getSymbol(), new ChestButton(this.configCopy.previewButton){

            @Override
            public void onClick(ClickType type) {
                if (ChestListView.this.currentPage == 1) {
                    return;
                }
                ChestListView.this.applyListConfiguration(ChestListView.this.configCopy, ChestListView.this.currentPage - 1);
                ChestListView.this.open();
            }
        }.setLoreArgs(this.currentPage, totalPages));
        this.setButton(this.configCopy.nextButton.getSymbol(), new ChestButton(this.configCopy.nextButton){

            @Override
            public void onClick(ClickType type) {
                if (ChestListView.this.currentPage * ChestListView.this.pageSize >= ChestListView.this.items.size()) {
                    return;
                }
                ChestListView.this.applyListConfiguration(ChestListView.this.configCopy, ChestListView.this.currentPage + 1);
                ChestListView.this.open();
            }
        }.setLoreArgs(this.currentPage, totalPages));
        super.open();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

