/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.webMap.WebMapRender;
import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BlueMapConnect
extends WebMapRender {
    private static final String DOMINION_LABEL = "Dominion";
    private static final String MCA_LABEL = "MCA";
    private static final double SHAPE_OFFSET = 0.001;
    private static final int MCA_CHUNK_SIZE = 512;
    private static final int MIN_Y = -64;
    private static final int MAX_Y = 320;
    private static final Color MCA_LINE_COLOR = new Color(0, 204, 0, 0.8f);
    private static final Color MCA_FILL_COLOR = new Color(0, 204, 0, 0.2f);

    public BlueMapConnect() {
        WebMapRender.webMapInstances.add(this);
    }

    @Override
    protected void renderDominions(@NotNull List<DominionDTO> dominions) {
        this.executeBlueMapOperation(() -> {
            Map<String, List<DominionDTO>> worldDominions = this.groupDominionsByWorld(dominions);
            for (Map.Entry<String, List<DominionDTO>> entry : worldDominions.entrySet()) {
                this.renderDominionsForWorld(entry.getKey(), entry.getValue());
            }
        });
    }

    @Override
    protected void renderMCA(@NotNull Map<String, List<String>> mcaFiles) {
        this.executeBlueMapOperation(() -> {
            for (Map.Entry entry : mcaFiles.entrySet()) {
                this.renderMCAForWorld((String)entry.getKey(), (List)entry.getValue());
            }
        });
    }

    private void executeBlueMapOperation(Runnable operation) {
        Scheduler.runTaskAsync(() -> {
            try {
                BlueMapAPI.getInstance().ifPresent(api -> operation.run());
            }
            catch (NoClassDefFoundError e) {
                XLogger.warn(Language.blueMapConnectText.registerFail);
                XLogger.error(e);
            }
        });
    }

    private Map<String, List<DominionDTO>> groupDominionsByWorld(@NotNull List<DominionDTO> dominions) {
        HashMap<String, List<DominionDTO>> worldDominions = new HashMap<String, List<DominionDTO>>();
        for (DominionDTO dominion : dominions) {
            if (dominion.getWorld() == null) continue;
            String worldName = dominion.getWorld().getName();
            worldDominions.computeIfAbsent(worldName, k -> new ArrayList()).add(dominion);
        }
        return worldDominions;
    }

    private void renderDominionsForWorld(String worldName, List<DominionDTO> dominions) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)worldName)).ifPresent(world -> {
            MarkerSet markerSet = MarkerSet.builder().label(DOMINION_LABEL).build();
            for (DominionDTO dominion : dominions) {
                this.createDominionMarker(dominion, markerSet);
            }
            this.addMarkerSetToMaps(world.getMaps(), worldName + "-" + markerSet.getLabel(), markerSet);
        });
    }

    private void createDominionMarker(DominionDTO dominion, MarkerSet markerSet) {
        PlayerDTO player = CacheManager.instance.getPlayer(dominion.getOwner());
        if (player == null) {
            return;
        }
        Shape shape = this.createRectangularShape(dominion.getCuboid().x1(), dominion.getCuboid().z1(), dominion.getCuboid().x2(), dominion.getCuboid().z2());
        Color lineColor = new Color(dominion.getColorR(), dominion.getColorG(), dominion.getColorB(), 0.8f);
        Color fillColor = new Color(dominion.getColorR(), dominion.getColorG(), dominion.getColorB(), 0.2f);
        ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(dominion.getName())).detail(Misc.formatString(Language.blueMapConnectText.infoLabel, dominion.getName(), player.getLastKnownName()))).position((double)dominion.getCuboid().x1() + 0.001, (double)dominion.getCuboid().y1(), (double)dominion.getCuboid().z1() + 0.001)).shape(shape, (float)dominion.getCuboid().y1() + 0.001f, (float)dominion.getCuboid().y2() - 0.001f).lineColor(lineColor).fillColor(fillColor).build();
        markerSet.getMarkers().put(dominion.getName(), marker);
    }

    private void renderMCAForWorld(String worldName, List<String> mcaFiles) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)worldName)).ifPresent(bmWorld -> {
            MarkerSet markerSet = MarkerSet.builder().label(MCA_LABEL).defaultHidden(Boolean.valueOf(true)).build();
            for (String file : mcaFiles) {
                this.createMCAMarker(file, markerSet);
            }
            this.addMarkerSetToMaps(bmWorld.getMaps(), worldName + "-" + markerSet.getLabel(), markerSet);
        });
    }

    private void createMCAMarker(String fileName, MarkerSet markerSet) {
        try {
            String[] parts = fileName.split("\\.");
            if (parts.length < 3) {
                XLogger.warn("Invalid MCA filename format: " + fileName);
                return;
            }
            int mcaX = Integer.parseInt(parts[1]);
            int mcaZ = Integer.parseInt(parts[2]);
            int worldX1 = mcaX * 512;
            int worldX2 = worldX1 + 512;
            int worldZ1 = mcaZ * 512;
            int worldZ2 = worldZ1 + 512;
            Shape shape = this.createRectangularShape(worldX1, worldZ1, worldX2, worldZ2);
            ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(fileName)).position((double)worldX1 + 0.001, -64.0, (double)worldZ1 + 0.001)).shape(shape, -64.0f, 320.0f).lineColor(MCA_LINE_COLOR).fillColor(MCA_FILL_COLOR).build();
            markerSet.getMarkers().put(fileName, marker);
        }
        catch (NumberFormatException e) {
            XLogger.warn("Failed to parse MCA coordinates from filename: " + fileName);
            XLogger.error(e);
        }
    }

    private Shape createRectangularShape(double x1, double z1, double x2, double z2) {
        List<Vector2d> vectors = Arrays.asList(new Vector2d(x1 + 0.001, z1 + 0.001), new Vector2d(x2 - 0.001, z1 + 0.001), new Vector2d(x2 - 0.001, z2 - 0.001), new Vector2d(x1 + 0.001, z2 - 0.001));
        return new Shape(vectors);
    }

    private void addMarkerSetToMaps(Collection<BlueMapMap> maps, String key, MarkerSet markerSet) {
        for (BlueMapMap map : maps) {
            map.getMarkerSets().put(key, markerSet);
        }
    }

    public static class BlueMapConnectText
    extends ConfigurationPart {
        public String registerFail = "Failed to register BlueMap API.";
        public String infoLabel = "<div>{0}</div><div>Owner: {1}</div>";
    }
}

