/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.webMap.WebMapRender;
import java.util.List;
import java.util.Map;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynmapConnect
extends WebMapRender {
    private static final String DOMINION_MARKER_SET_ID = "dominion";
    private static final String DOMINION_MARKER_SET_LABEL = "Dominion";
    private static final String MCA_MARKER_SET_ID = "mca";
    private static final String MCA_MARKER_SET_LABEL = "MCA";
    private static final int MCA_CHUNK_SIZE = 512;
    private static final int MCA_COLOR = 52224;
    private static final double DEFAULT_FILL_OPACITY = 0.2;
    private static final double DEFAULT_LINE_OPACITY = 0.8;
    private static final int DEFAULT_LINE_WEIGHT = 1;
    private final DynmapConnectListener listener;

    public DynmapConnect() {
        WebMapRender.webMapInstances.add(this);
        this.listener = new DynmapConnectListener();
    }

    @Override
    protected void renderDominions(@NotNull List<DominionDTO> dominions) {
        this.listener.setDominionMarkers(dominions);
    }

    @Override
    protected void renderMCA(@NotNull Map<String, List<String>> mcaFiles) {
        this.listener.setMCAMarkers(mcaFiles);
    }

    public static class DynmapConnectListener
    extends DynmapCommonAPIListener {
        private MarkerSet dominionMarkerSet;
        private MarkerSet mcaMarkerSet;

        public DynmapConnectListener() {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)this);
        }

        public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
            try {
                MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                this.initializeMarkerSets(markerAPI);
                XLogger.info(Language.dynmapConnectText.registerSuccess);
            }
            catch (Exception e) {
                XLogger.error("Failed to initialize Dynmap API: " + e.getMessage(), e);
            }
        }

        private void initializeMarkerSets(@NotNull MarkerAPI markerAPI) {
            this.dominionMarkerSet = this.getOrCreateMarkerSet(markerAPI, DynmapConnect.DOMINION_MARKER_SET_ID, DynmapConnect.DOMINION_MARKER_SET_LABEL);
            this.mcaMarkerSet = this.getOrCreateMarkerSet(markerAPI, DynmapConnect.MCA_MARKER_SET_ID, DynmapConnect.MCA_MARKER_SET_LABEL);
        }

        @Nullable
        private MarkerSet getOrCreateMarkerSet(@NotNull MarkerAPI markerAPI, @NotNull String id, @NotNull String label) {
            MarkerSet markerSet = markerAPI.getMarkerSet(id);
            if (markerSet == null) {
                markerSet = markerAPI.createMarkerSet(id, label, null, false);
            }
            return markerSet;
        }

        private void setDominionMarker(@NotNull DominionDTO dominion) {
            PlayerDTO owner = CacheManager.instance.getPlayer(dominion.getOwner());
            if (owner == null || dominion.getWorld() == null) {
                XLogger.debug("Skipping dominion marker for " + dominion.getName() + " - missing owner or world information");
                return;
            }
            try {
                String nameLabel = Misc.formatString(Language.dynmapConnectText.infoLabel, dominion.getName(), owner.getLastKnownName());
                double[] xCoordinates = new double[]{dominion.getCuboid().x1(), dominion.getCuboid().x2()};
                double[] zCoordinates = new double[]{dominion.getCuboid().z1(), dominion.getCuboid().z2()};
                AreaMarker marker = this.dominionMarkerSet.createAreaMarker(dominion.getId().toString(), nameLabel, true, dominion.getWorld().getName(), xCoordinates, zCoordinates, false);
                int color = dominion.getColorHex();
                marker.setFillStyle(0.2, color);
                marker.setLineStyle(1, 0.8, color);
                XLogger.debug("Added dominion marker: " + dominion.getName());
            }
            catch (Exception e) {
                XLogger.error("Failed to create dominion marker for " + dominion.getName() + ": " + e.getMessage());
            }
        }

        public void setDominionMarkers(@NotNull List<DominionDTO> dominions) {
            Scheduler.runTaskAsync(() -> {
                if (this.dominionMarkerSet == null) {
                    XLogger.warn(Language.dynmapConnectText.registerFail);
                    return;
                }
                this.clearAreaMarkers(this.dominionMarkerSet);
                dominions.forEach(this::setDominionMarker);
                XLogger.debug("Updated " + dominions.size() + " dominion markers");
            });
        }

        public void setMCAMarkers(@NotNull Map<String, List<String>> mcaFiles) {
            Scheduler.runTaskAsync(() -> {
                if (this.mcaMarkerSet == null) {
                    XLogger.warn(Language.dynmapConnectText.registerFail);
                    return;
                }
                this.clearAreaMarkers(this.mcaMarkerSet);
                int markerCount = 0;
                for (Map.Entry entry : mcaFiles.entrySet()) {
                    String worldName = (String)entry.getKey();
                    for (String fileName : (List)entry.getValue()) {
                        if (!this.createMCAMarker(worldName, fileName)) continue;
                        ++markerCount;
                    }
                }
                XLogger.debug("Updated " + markerCount + " MCA markers");
            });
        }

        private boolean createMCAMarker(@NotNull String worldName, @NotNull String fileName) {
            try {
                String[] coordinates = fileName.split("\\.");
                if (coordinates.length < 3) {
                    XLogger.warn("Invalid MCA file name format: " + fileName);
                    return false;
                }
                int chunkX = Integer.parseInt(coordinates[1]);
                int chunkZ = Integer.parseInt(coordinates[2]);
                int worldX1 = chunkX * 512;
                int worldX2 = (chunkX + 1) * 512;
                int worldZ1 = chunkZ * 512;
                int worldZ2 = (chunkZ + 1) * 512;
                String nameLabel = "<div>" + fileName + "</div>";
                double[] xCoordinates = new double[]{worldX1, worldX2};
                double[] zCoordinates = new double[]{worldZ1, worldZ2};
                AreaMarker marker = this.mcaMarkerSet.createAreaMarker(fileName, nameLabel, true, worldName, xCoordinates, zCoordinates, false);
                marker.setFillStyle(0.2, 52224);
                marker.setLineStyle(1, 0.8, 52224);
                return true;
            }
            catch (NumberFormatException e) {
                XLogger.warn("Failed to parse MCA coordinates from file: " + fileName);
                return false;
            }
            catch (Exception e) {
                XLogger.error("Failed to create MCA marker for " + fileName + ": " + e.getMessage());
                return false;
            }
        }

        private void clearAreaMarkers(@NotNull MarkerSet markerSet) {
            try {
                markerSet.getAreaMarkers().forEach(GenericMarker::deleteMarker);
            }
            catch (Exception e) {
                XLogger.error("Failed to clear area markers: " + e.getMessage());
            }
        }
    }

    public static class DynmapConnectText
    extends ConfigurationPart {
        public String registerSuccess = "Register to dynmap success!";
        public String registerFail = "Register to dynmap failed!";
        public String infoLabel = "<div>{0}</div><div>Owner: {1}</div>";
    }
}

