/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.Option;
import java.util.List;
import org.bukkit.entity.Player;

public class CommandArguments {

    public static class PlayerTitleIdArgument
    extends Argument {
        public PlayerTitleIdArgument() {
            super("title_id", true, (commandSender, preArguments) -> {
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    return CacheManager.instance.getPlayerCache().getPlayerGroupTitleList(player.getUniqueId()).stream().map(title -> title.getId().toString()).toList();
                }
                return List.of();
            });
        }
    }

    public static class RequiredGroupArgument
    extends Argument {
        public RequiredGroupArgument(Integer dominionArgumentIndex) {
            super("group_name", true, (sender, preArguments) -> {
                if (preArguments.length <= dominionArgumentIndex) {
                    return List.of();
                }
                DominionDTO dominion = Converts.toDominionDTO(preArguments[dominionArgumentIndex]);
                return dominion.getGroups().stream().map(GroupDTO::getNamePlain).toList();
            });
        }
    }

    public static class RequiredMemberArgument
    extends Argument {
        public RequiredMemberArgument(Integer dominionArgumentIndex) {
            super("member_name", true, (sender, preArguments) -> {
                if (preArguments.length <= dominionArgumentIndex) {
                    return List.of();
                }
                DominionDTO dominion = Converts.toDominionDTO(preArguments[dominionArgumentIndex]);
                return dominion.getMembers().stream().map(member -> member.getPlayer().getLastKnownName()).toList();
            });
        }
    }

    public static class RequiredTemplateArgument
    extends Argument {
        public RequiredTemplateArgument() {
            super("template_name", true, (commandSender, preArguments) -> {
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    try {
                        return TemplateDOO.selectAll(player.getUniqueId()).stream().map(TemplateDOO::getName).toList();
                    }
                    catch (Exception e) {
                        XLogger.error(e);
                        return List.of();
                    }
                }
                return List.of();
            });
        }
    }

    public static class OptionalPageArgument
    extends Argument {
        public OptionalPageArgument() {
            super("page", "1");
        }
    }

    public static class PriFlagArgument
    extends Argument {
        public PriFlagArgument() {
            super("pri_flag_name", true, (commandSender, preArguments) -> Flags.getAllPriFlagsEnable().stream().map(Flag::getFlagName).toList());
        }
    }

    public static class GuestFlagArgument
    extends Argument {
        public GuestFlagArgument() {
            super("guest_flag_name", true, (commandSender, preArguments) -> Flags.getAllPriFlagsEnable().stream().filter(flag -> !flag.equals(Flags.ADMIN)).map(Flag::getFlagName).toList());
        }
    }

    public static class EnvFlagArgument
    extends Argument {
        public EnvFlagArgument() {
            super("env_flag_name", true, (commandSender, preArguments) -> Flags.getAllEnvFlagsEnable().stream().map(Flag::getFlagName).toList());
        }
    }

    public static class RequiredPlayerArgument
    extends Argument {
        public RequiredPlayerArgument() {
            super("player_name", true, (commandSender, preArguments) -> CacheManager.instance.getPlayerNames());
        }
    }

    public static class RequiredDominionArgument
    extends Argument {
        public RequiredDominionArgument() {
            super("dominion_name", true, (commandSender, preArguments) -> {
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    return CacheManager.instance.getPlayerManageDominionNames(player.getUniqueId());
                }
                return CacheManager.instance.getAllDominionNames();
            });
        }
    }

    public static class BollenOption
    extends Option {
        public BollenOption() {
            super(List.of("true", "false"));
        }
    }
}

