/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc.webMap;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.misc.webMap.RenderEventHandler;
import cn.lunadeer.dominion.misc.webMap.implementations.BlueMapConnect;
import cn.lunadeer.dominion.misc.webMap.implementations.DynmapConnect;
import cn.lunadeer.dominion.misc.webMap.implementations.Pl3xMapConnect;
import cn.lunadeer.dominion.misc.webMap.implementations.SquareMapConnect;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class WebMapRender {
    protected static List<WebMapRender> webMapInstances = new ArrayList<WebMapRender>();

    public static void WebMapRenderInit() {
        if (Configuration.webMapRenderer.dynmap) {
            try {
                new DynmapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        if (Configuration.webMapRenderer.blueMap) {
            try {
                new BlueMapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        if (Configuration.webMapRenderer.squareMap) {
            try {
                new SquareMapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        if (Configuration.webMapRenderer.pl3xMap) {
            try {
                new Pl3xMapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new RenderEventHandler(), (Plugin)Dominion.instance);
        Scheduler.runTaskLaterAsync(() -> {
            for (WebMapRender mapRender : webMapInstances) {
                mapRender.renderAll(CacheManager.instance.getCache().getDominionCache().getAllDominions());
            }
        }, (long)Configuration.webMapRenderer.renderDelaySec * 20L);
    }

    public static void renderAllMCA(@NotNull Map<String, List<String>> mcaFiles) {
        Scheduler.runTaskAsync(() -> {
            for (WebMapRender mapRender : webMapInstances) {
                mapRender.renderMCA(mcaFiles);
            }
        });
    }

    protected abstract void renderAll(@NotNull List<DominionDTO> var1);

    protected abstract void updateDominionInSet(@NotNull DominionDTO var1);

    public static void updateDominion(@NotNull DominionDTO dominion) {
        for (WebMapRender mapRender : webMapInstances) {
            mapRender.updateDominionInSet(dominion);
        }
    }

    protected abstract void removeDominionFromSet(@NotNull String var1, @NotNull String var2);

    public static void removeDominion(@NotNull String worldName, @NotNull String dominionName) {
        for (WebMapRender mapRender : webMapInstances) {
            mapRender.removeDominionFromSet(worldName, dominionName);
        }
    }

    protected abstract void renderMCA(@NotNull Map<String, List<String>> var1);
}

