/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc.webMap.implementations;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.misc.webMap.WebMapRender;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.event.world.WorldUnloadedEvent;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Popup;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class Pl3xMapConnect
extends WebMapRender
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(Pl3xMapConnect.class.getName());
    private static final String DOMINION_LAYER = "dominion_markers";
    private static final String MCA_LAYER = "mca_markers";
    private static final int MCA_CHUNK_SIZE = 512;
    private final ConcurrentLinkedQueue<DominionDTO> dominions = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MCARegion> mcaRegions = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, Options> dominionOptionsCache = new ConcurrentHashMap();
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public Pl3xMapConnect() {
        WebMapRender.webMapInstances.add(this);
        this.initializePl3xMapConnection();
    }

    private void initializePl3xMapConnection() {
        try {
            Pl3xMap.api().getEventRegistry().register((EventListener)this);
            if (Pl3xMap.api().isEnabled()) {
                this.onPl3xMapEnabled(new Pl3xMapEnabledEvent());
            }
            this.isInitialized.set(true);
            LOGGER.info("Pl3xMap connection initialized successfully");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize Pl3xMap connection", e);
            this.isInitialized.set(false);
        }
    }

    @Override
    protected void renderAll(@NotNull List<DominionDTO> dominions) {
        if (!this.isInitialized.get()) {
            LOGGER.warning("Pl3xMap not initialized, skipping dominion rendering");
            return;
        }
        Scheduler.runTaskAsync(() -> {
            try {
                this.dominions.clear();
                this.dominionOptionsCache.clear();
                List<DominionDTO> validDominions = dominions.parallelStream().filter(dominion -> dominion.getWorld() != null).toList();
                this.dominions.addAll(validDominions);
                validDominions.forEach(dominion -> {
                    Options options = this.getDominionOptions((DominionDTO)dominion);
                    this.dominionOptionsCache.put(dominion.getName(), options);
                });
                this.updateLayers();
                LOGGER.info("Updated " + validDominions.size() + " dominion markers on Pl3xMap");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error rendering dominions on Pl3xMap", e);
            }
        });
    }

    @Override
    protected void updateDominionInSet(@NotNull DominionDTO dominion) {
        if (!this.isInitialized.get()) {
            LOGGER.warning("Pl3xMap not initialized, skipping dominion update");
            return;
        }
        this.dominions.removeIf(d -> d.getName().equals(dominion.getName()) && Objects.equals(d.getWorld(), dominion.getWorld()));
        if (dominion.getWorld() != null) {
            this.dominions.add(dominion);
            this.dominionOptionsCache.put(dominion.getName(), this.getDominionOptions(dominion));
        } else {
            this.dominionOptionsCache.remove(dominion.getName());
        }
        this.updateLayers();
    }

    @Override
    protected void removeDominionFromSet(@NotNull String worldName, @NotNull String dominionName) {
        if (!this.isInitialized.get()) {
            LOGGER.warning("Pl3xMap not initialized, skipping dominion removal");
            return;
        }
        this.dominions.removeIf(d -> d.getName().equals(dominionName) && d.getWorld() != null && d.getWorld().getName().equals(worldName));
        this.dominionOptionsCache.remove(dominionName);
        this.updateLayers();
    }

    @Override
    protected void renderMCA(@NotNull Map<String, List<String>> mcaFiles) {
        if (!this.isInitialized.get()) {
            LOGGER.warning("Pl3xMap not initialized, skipping MCA rendering");
            return;
        }
        Scheduler.runTaskAsync(() -> {
            try {
                this.mcaRegions.clear();
                mcaFiles.entrySet().parallelStream().filter(entry -> Bukkit.getWorld((String)((String)entry.getKey())) != null).forEach(entry -> {
                    String worldName = (String)entry.getKey();
                    ((List)entry.getValue()).parallelStream().map(fileName -> this.parseMCAFile(worldName, (String)fileName)).filter(Objects::nonNull).forEach(this.mcaRegions::add);
                });
                this.updateLayers();
                LOGGER.info("Updated " + this.mcaRegions.size() + " MCA markers on Pl3xMap");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error rendering MCA files on Pl3xMap", e);
            }
        });
    }

    private MCARegion parseMCAFile(@NotNull String worldName, @NotNull String fileName) {
        try {
            String[] cords = fileName.split("\\.");
            if (cords.length < 3) {
                return null;
            }
            int chunkX = Integer.parseInt(cords[1]);
            int chunkZ = Integer.parseInt(cords[2]);
            int x1 = chunkX * 512;
            int z1 = chunkZ * 512;
            int x2 = x1 + 512;
            int z2 = z1 + 512;
            return new MCARegion(worldName, fileName, x1, z1, x2, z2);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Failed to parse MCA coordinates from file: " + fileName, e);
            }
            return null;
        }
    }

    private void updateLayers() {
        if (!this.isInitialized.get()) {
            return;
        }
        try {
            Pl3xMap.api().getWorldRegistry().forEach(this::registerLayers);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to update layers", e);
        }
    }

    private void registerLayers(@NotNull World world) {
        try {
            DominionLayer dominionLayer = new DominionLayer(this, world);
            world.getLayerRegistry().unregister(DOMINION_LAYER);
            world.getLayerRegistry().register((Keyed)dominionLayer);
            MCALayer mcaLayer = new MCALayer(this, world);
            world.getLayerRegistry().unregister(MCA_LAYER);
            world.getLayerRegistry().register((Keyed)mcaLayer);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to register layers for world: " + world.getName(), e);
        }
    }

    @EventHandler
    public void onPl3xMapEnabled(@NotNull Pl3xMapEnabledEvent event) {
        LOGGER.info("Pl3xMap enabled, registering layers for all worlds");
        this.updateLayers();
    }

    @EventHandler
    public void onWorldLoaded(@NotNull WorldLoadedEvent event) {
        this.registerLayers(event.getWorld());
    }

    @EventHandler
    public void onWorldUnloaded(@NotNull WorldUnloadedEvent event) {
        try {
            event.getWorld().getLayerRegistry().unregister(DOMINION_LAYER);
            event.getWorld().getLayerRegistry().unregister(MCA_LAYER);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to unregister layers for world: " + event.getWorld().getName(), e);
        }
    }

    @NotNull
    private Options getDominionOptions(@NotNull DominionDTO dominion) {
        PlayerDTO owner = CacheManager.instance.getPlayer(dominion.getOwner());
        String ownerName = owner != null ? owner.getLastKnownName() : "Unknown";
        String tooltip = dominion.getName();
        String popup = String.format("<div><strong>%s</strong></div><div>Owner: %s</div><div>Size: %dx%dx%d</div>", dominion.getName(), ownerName, Math.abs(dominion.getCuboid().x2() - dominion.getCuboid().x1()), Math.abs(dominion.getCuboid().y2() - dominion.getCuboid().y1()), Math.abs(dominion.getCuboid().z2() - dominion.getCuboid().z1()));
        return Options.builder().tooltip(new Tooltip(tooltip)).popup(new Popup(popup)).fillColor(Integer.valueOf(new Color(dominion.getColorR(), dominion.getColorG(), dominion.getColorB(), 51).getRGB())).strokeColor(Integer.valueOf(new Color(dominion.getColorR(), dominion.getColorG(), dominion.getColorB(), 204).getRGB())).strokeWeight(Integer.valueOf(2)).build();
    }

    @NotNull
    private Options getMCAOptions(@NotNull MCARegion region) {
        return Options.builder().tooltip(new Tooltip(region.fileName)).popup(new Popup("<div><strong>MCA Region</strong></div><div>" + region.fileName + "</div>")).fillColor(Integer.valueOf(new Color(0, 204, 0, 51).getRGB())).strokeColor(Integer.valueOf(new Color(0, 204, 0, 204).getRGB())).strokeWeight(Integer.valueOf(1)).build();
    }

    private record MCARegion(String worldName, String fileName, int x1, int z1, int x2, int z2) {
    }

    public static class DominionLayer
    extends SimpleLayer {
        private final Pl3xMapConnect connect;
        private final World mapWorld;

        public DominionLayer(@NotNull Pl3xMapConnect connect, @NotNull World mapWorld) {
            super(Pl3xMapConnect.DOMINION_LAYER, () -> "Dominion");
            this.connect = connect;
            this.mapWorld = mapWorld;
        }

        @NotNull
        public Collection<Marker<?>> getMarkers() {
            return this.connect.dominions.stream().filter(dominion -> dominion.getWorld().getName().equals(this.mapWorld.getName())).map(dominion -> (Rectangle)Rectangle.of((String)dominion.getName(), (Point)Point.of((int)dominion.getCuboid().x1(), (int)dominion.getCuboid().z1()), (Point)Point.of((int)dominion.getCuboid().x2(), (int)dominion.getCuboid().z2())).setOptions(this.connect.getDominionOptions((DominionDTO)dominion))).collect(Collectors.toList());
        }
    }

    public static class MCALayer
    extends SimpleLayer {
        private final Pl3xMapConnect connect;
        private final World mapWorld;

        public MCALayer(@NotNull Pl3xMapConnect connect, @NotNull World mapWorld) {
            super(Pl3xMapConnect.MCA_LAYER, () -> "MCA");
            this.connect = connect;
            this.mapWorld = mapWorld;
        }

        @NotNull
        public Collection<Marker<?>> getMarkers() {
            return this.connect.mcaRegions.stream().filter(region -> region.worldName.equals(this.mapWorld.getName())).map(region -> (Rectangle)Rectangle.of((String)("mca_" + region.fileName), (Point)Point.of((int)region.x1, (int)region.z1), (Point)Point.of((int)region.x2, (int)region.z2)).setOptions(this.connect.getMCAOptions((MCARegion)region))).collect(Collectors.toList());
        }
    }
}

