/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.GroupTitleCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TitleList {
    public static SecondaryCommand titleList = new SecondaryCommand("title_list", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                TitleList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.titleListTuiText.button){

            @Override
            public void function(String pageStr) {
                TitleList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, TitleList.button(sender));
            view.title(Language.titleListTuiText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.titleListTuiText.button));
            List<GroupDTO> groups = CacheManager.instance.getPlayerCache().getPlayerGroupTitleList(player.getUniqueId());
            CopyOnWriteArrayList<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getPlayerOwnDominionDTOs(player.getUniqueId());
            for (DominionDTO dominion : dominions) {
                groups.addAll(dominion.getGroups());
            }
            PlayerDTO playerDTO = CacheManager.instance.getPlayerCache().getPlayer(player.getUniqueId());
            if (playerDTO == null) {
                return;
            }
            Integer usingId = playerDTO.getUsingGroupTitleID();
            GroupDTO using = CacheManager.instance.getGroup(usingId);
            for (final GroupDTO group : groups) {
                DominionDTO dominion = CacheManager.instance.getDominion(group.getDomID());
                if (dominion == null) continue;
                Line line = Line.create();
                line.append(Component.text((String)(group.getId() + ". ")));
                if (using != null && using.getId().equals(group.getId())) {
                    line.append(new FunctionalButton(Language.titleListTuiText.disuseButton){

                        @Override
                        public void function() {
                            GroupTitleCommand.useTitle(sender, "-1", pageStr);
                        }
                    }.needPermission(Dominion.defaultPermission).red().build());
                } else {
                    line.append(new FunctionalButton(Language.titleListTuiText.useButton){

                        @Override
                        public void function() {
                            GroupTitleCommand.useTitle(sender, group.getId().toString(), pageStr);
                        }
                    }.needPermission(Dominion.defaultPermission).green().build());
                }
                line.append(group.getNameColoredComponent().hoverEvent((HoverEventSource)Component.text((String)Misc.formatString(Language.titleListTuiText.fromDominion, dominion.getName()))));
                view.add(line);
            }
            view.showOn((CommandSender)player, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class TitleListTuiText
    extends ConfigurationPart {
        public String title = "Group Title List";
        public String description = "List of group titles you can use.";
        public String button = "TITLES";
        public String useButton = "USE";
        public String disuseButton = "DISUSE";
        public String fromDominion = "From dominion {0}";
    }
}

