/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.cache.server.ServerCache;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.doos.PlayerDOO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class PlayerCache
extends Cache {
    private ConcurrentHashMap<Integer, PlayerDTO> playerCache;
    private ConcurrentHashMap<UUID, Integer> playerIdCache;
    private ConcurrentHashMap<UUID, String> playerNameCache;
    private ConcurrentHashMap<String, Integer> playerNameToId;
    private ConcurrentHashMap<UUID, Integer> playerUsingTitleId;

    @Override
    void loadExecution() throws Exception {
        this.playerNameCache = new ConcurrentHashMap();
        this.playerNameToId = new ConcurrentHashMap();
        this.playerIdCache = new ConcurrentHashMap();
        this.playerUsingTitleId = new ConcurrentHashMap();
        this.playerCache = new ConcurrentHashMap();
        List<PlayerDTO> players = PlayerDOO.all();
        for (PlayerDTO player : players) {
            this.playerIdCache.put(player.getUuid(), player.getId());
            this.playerNameToId.put(player.getLastKnownName(), player.getId());
            this.playerCache.put(player.getId(), player);
            this.playerNameCache.put(player.getUuid(), player.getLastKnownName());
            this.playerUsingTitleId.put(player.getUuid(), player.getUsingGroupTitleID());
        }
    }

    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        PlayerDTO player = this.playerCache.remove(idToLoad);
        if (player != null) {
            this.playerIdCache.remove(player.getUuid());
            this.playerNameCache.remove(player.getUuid());
            this.playerUsingTitleId.remove(player.getUuid());
            this.playerNameToId.remove(player.getLastKnownName());
        }
        if ((player = PlayerDOO.selectById(idToLoad)) == null) {
            return;
        }
        this.playerCache.put(player.getId(), player);
        this.playerIdCache.put(player.getUuid(), player.getId());
        this.playerNameCache.put(player.getUuid(), player.getLastKnownName());
        this.playerUsingTitleId.put(player.getUuid(), player.getUsingGroupTitleID());
        this.playerNameToId.put(player.getLastKnownName(), player.getId());
    }

    @Override
    void deleteExecution(Integer idToDelete) throws Exception {
        PlayerDTO player = this.playerCache.remove(idToDelete);
        if (player != null) {
            this.playerIdCache.remove(player.getUuid());
            this.playerNameCache.remove(player.getUuid());
            this.playerUsingTitleId.remove(player.getUuid());
            this.playerNameToId.remove(player.getLastKnownName());
        }
    }

    @Nullable
    public PlayerDTO getPlayer(UUID uuid) {
        if (this.playerIdCache.containsKey(uuid)) {
            return this.playerCache.get(this.playerIdCache.get(uuid));
        }
        return null;
    }

    @Nullable
    public PlayerDTO getPlayer(String name) {
        if (this.playerNameToId.containsKey(name)) {
            return this.playerCache.get(this.playerNameToId.get(name));
        }
        return null;
    }

    public String getPlayerName(UUID uuid) {
        if (this.playerNameCache.containsKey(uuid)) {
            return this.playerNameCache.get(uuid);
        }
        return "Unknown Player: %s".formatted(uuid);
    }

    public List<String> getPlayerNames() {
        return new ArrayList<String>(this.playerNameCache.values());
    }

    public Integer getPlayerUsingTitleId(UUID uuid) {
        return this.playerUsingTitleId.getOrDefault(uuid, -1);
    }

    public List<GroupDTO> getPlayerGroupTitleList(UUID uuid) {
        ArrayList<GroupDTO> groupTitleList = new ArrayList<GroupDTO>();
        List<MemberDTO> playerBelongedDominionMembers = Objects.requireNonNull(CacheManager.instance.getCache()).getMemberCache().getMemberBelongedDominions(uuid);
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : CacheManager.instance.getOtherServerCaches().values()) {
                playerBelongedDominionMembers.addAll(serverCache.getMemberCache().getMemberBelongedDominions(uuid));
            }
        }
        for (MemberDTO member : playerBelongedDominionMembers) {
            GroupDTO group;
            if (member.getGroupId() == -1 || (group = CacheManager.instance.getGroup(member.getGroupId())) == null) continue;
            groupTitleList.add(group);
        }
        return groupTitleList;
    }
}

