/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.configuration;

import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldWide {
    private static final Map<String, WorldConfig> worlds = new HashMap<String, WorldConfig>();

    public static boolean isWorldWideEnabled(World world) {
        return worlds.containsKey(world.getName()) && WorldWide.worlds.get((Object)world.getName()).enabled;
    }

    @Nullable
    public static Map<EnvFlag, Boolean> getEnvironmentFlagValue(World world) {
        if (!worlds.containsKey(world.getName())) {
            return null;
        }
        return WorldWide.worlds.get((Object)world.getName()).environmentFlags;
    }

    public static boolean getEnvFlagValue(World world, @NotNull EnvFlag flag) {
        if (!worlds.containsKey(world.getName())) {
            return flag.getDefaultValue();
        }
        return WorldWide.worlds.get((Object)world.getName()).environmentFlags.getOrDefault(flag, flag.getDefaultValue());
    }

    @Nullable
    public static Map<PriFlag, Boolean> getGuestPrivilegeFlagValue(World world) {
        if (!worlds.containsKey(world.getName())) {
            return null;
        }
        return WorldWide.worlds.get((Object)world.getName()).guestPrivilegeFlags;
    }

    public static boolean getGuestFlagValue(World world, @NotNull PriFlag flag) {
        if (!worlds.containsKey(world.getName())) {
            return flag.getDefaultValue();
        }
        return WorldWide.worlds.get((Object)world.getName()).guestPrivilegeFlags.getOrDefault(flag, flag.getDefaultValue());
    }

    protected static void loadWorld(File worldWideRootPath, String worldName) throws IOException {
        File worldWideFile;
        YamlConfiguration config;
        if (!worlds.containsKey(worldName)) {
            worlds.put(worldName, new WorldConfig());
        }
        if ((config = YamlConfiguration.loadConfiguration((File)(worldWideFile = WorldWide.getFile(worldWideRootPath, worldName)))).get("enabled") == null) {
            config.set("enabled", (Object)false);
            config.setInlineComments("enabled", List.of("Enable or disable world-wide dominion for this world"));
        }
        WorldWide.worlds.get((Object)worldName).enabled = config.getBoolean("enabled", false);
        for (Flag flag : Flags.getAllFlags()) {
            if (flag.getFlagName().equals(Flags.ADMIN.getFlagName())) continue;
            if (config.get(flag.getConfigurationNameKey()) == null) {
                config.set(flag.getConfigurationNameKey(), (Object)flag.getDefaultValue());
            }
            config.setInlineComments(flag.getConfigurationNameKey(), List.of(flag.getDisplayName() + " - " + flag.getDescription()));
            if (flag instanceof PriFlag) {
                PriFlag priFlag = (PriFlag)flag;
                WorldWide.worlds.get((Object)worldName).guestPrivilegeFlags.put(priFlag, config.getBoolean(flag.getConfigurationNameKey(), flag.getDefaultValue().booleanValue()));
                continue;
            }
            if (!(flag instanceof EnvFlag)) continue;
            EnvFlag envFlag = (EnvFlag)flag;
            WorldWide.worlds.get((Object)worldName).environmentFlags.put(envFlag, config.getBoolean(flag.getConfigurationNameKey(), flag.getDefaultValue().booleanValue()));
        }
        config.save(worldWideFile);
    }

    @NotNull
    private static File getFile(File worldWideRootPath, String worldName) {
        File worldWideFile = new File(worldWideRootPath, worldName + ".yml");
        if (!worldWideFile.exists()) {
            try {
                if (!worldWideFile.createNewFile()) {
                    throw new RuntimeException("Failed to create world-wide dominion file: " + worldWideFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create world-wide dominion file: " + worldWideFile.getAbsolutePath(), e);
            }
        }
        return worldWideFile;
    }

    public static void load(CommandSender sender, JavaPlugin plugin) throws IOException {
        File rootPath = new File(plugin.getDataFolder(), "world-wide");
        if (!rootPath.exists() && !rootPath.mkdirs()) {
            throw new RuntimeException("Failed to create world-wide dominion directory: " + rootPath.getAbsolutePath());
        }
        for (World world : plugin.getServer().getWorlds()) {
            String worldName = world.getName();
            WorldWide.loadWorld(rootPath, worldName);
        }
    }

    private static class WorldConfig {
        private boolean enabled = false;
        private final Map<PriFlag, Boolean> guestPrivilegeFlags = new HashMap<PriFlag, Boolean>();
        private final Map<EnvFlag, Boolean> environmentFlags = new HashMap<EnvFlag, Boolean>();

        private WorldConfig() {
        }
    }
}

