/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.command;

import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.CommandManager;
import cn.lunadeer.dominion.utils.command.InvalidArgumentException;
import cn.lunadeer.dominion.utils.command.NoPermissionException;
import cn.lunadeer.dominion.utils.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class SecondaryCommand {
    private final String command;
    private final List<Argument> arguments;
    private final List<String> permissions = new ArrayList<String>();
    private boolean dynamic = false;
    private String description;

    public SecondaryCommand(String command, List<Argument> arguments, String description) {
        this.command = command;
        this.arguments = arguments;
        this.description = description;
        boolean startOptional = false;
        for (Argument argument : arguments) {
            if (startOptional && argument.isRequired()) {
                throw new IllegalArgumentException("Optional argument should always be at the end.");
            }
            if (argument.isRequired()) continue;
            startOptional = true;
        }
    }

    public SecondaryCommand(String command, List<Argument> arguments) {
        this(command, arguments, "");
    }

    public SecondaryCommand(String command, String description) {
        this(command, new ArrayList<Argument>(), description);
    }

    public SecondaryCommand(String command) {
        this(command, new ArrayList<Argument>(), "");
    }

    public SecondaryCommand needPermission(String permission) {
        this.permissions.add(permission);
        return this;
    }

    public SecondaryCommand needChildPermission(String rootPermission, PermissionDefault defaultValue) {
        String childPermission = rootPermission + "." + this.command;
        this.permissions.add(childPermission);
        if (Bukkit.getPluginManager().getPermission(childPermission) == null) {
            Bukkit.getPluginManager().addPermission(new Permission(childPermission, defaultValue));
        }
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String getArgumentValue(int index) {
        if (index >= this.arguments.size()) {
            throw new IllegalArgumentException("Index out of range.");
        }
        return this.arguments.get(index).getValue();
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder();
        usage.append(CommandManager.getRootCommand()).append(" ").append(this.command);
        for (Argument argument : this.arguments) {
            usage.append(" ");
            usage.append(argument.toString());
        }
        return usage.toString();
    }

    public void assertArguments(String[] args) throws InvalidArgumentException {
        if (this.arguments.isEmpty()) {
            return;
        }
        int pos = 1;
        for (Argument argument : this.arguments) {
            if (!argument.isRequired()) break;
            if (pos >= args.length) {
                throw new InvalidArgumentException(this.getUsage());
            }
            if (argument instanceof Option) {
                Option option = (Option)argument;
                if (option.getOptions().contains(args[pos])) {
                    ++pos;
                    continue;
                }
                throw new InvalidArgumentException(this.getUsage());
            }
            ++pos;
        }
    }

    public void assertPermission(CommandSender sender) throws NoPermissionException {
        if (this.permissions.isEmpty()) {
            return;
        }
        for (String permission : this.permissions) {
            if (sender.hasPermission(permission)) continue;
            throw new NoPermissionException(permission);
        }
    }

    public void run(CommandSender sender, String[] args) throws NoPermissionException, InvalidArgumentException {
        if (args.length < 1) {
            return;
        }
        if (!args[0].equals(this.command)) {
            return;
        }
        this.assertPermission(sender);
        this.assertArguments(args);
        for (int i = 0; i < this.arguments.size() && i + 1 < args.length; ++i) {
            this.arguments.get(i).setValue(args[i + 1]);
        }
        this.executeHandler(sender);
    }

    public SecondaryCommand register() {
        CommandManager.registerCommand(this);
        return this;
    }

    public SecondaryCommand dynamic() {
        this.dynamic = true;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public abstract void executeHandler(CommandSender var1);

    public String getDescription() {
        return this.description;
    }

    public SecondaryCommand setDescription(String description) {
        this.description = description;
        return this;
    }
}

