/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.inputters;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.group.GroupCreateEvent;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.inputter.InputterRunner;
import org.bukkit.command.CommandSender;

public class CreateGroupInputter {
    public static void createOn(final CommandSender sender, final String dominionName) {
        new InputterRunner(sender, Language.createGroupInputterText.hint){

            @Override
            public void run(String input) {
                DominionDTO dominion = Converts.toDominionDTO(dominionName);
                new GroupCreateEvent(sender, dominion, input).call();
                GroupList.show(sender, dominionName, "1");
            }
        };
    }

    public static FunctionalButton createTuiButtonOn(final CommandSender sender, final String dominionName) {
        return new FunctionalButton(Language.createGroupInputterText.button){

            @Override
            public void function() {
                CreateGroupInputter.createOn(sender, dominionName);
            }
        };
    }

    public static class CreateGroupInputterText
    extends ConfigurationPart {
        public String button = "CREATE";
        public String hint = "Enter new group name you want to create.";
    }
}

