/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.managers;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.managers.MultiServerManager;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.SafeLocationFinder;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.FIelds.FieldInteger;
import cn.lunadeer.dominion.utils.databse.FIelds.FieldString;
import cn.lunadeer.dominion.utils.databse.syntax.Delete;
import cn.lunadeer.dominion.utils.databse.syntax.Insert;
import cn.lunadeer.dominion.utils.databse.syntax.Select;
import cn.lunadeer.dominion.utils.scheduler.CancellableTask;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TeleportManager
implements Listener {
    public static Map<UUID, Integer> teleportCooldown = new HashMap<UUID, Integer>();
    public static Map<UUID, CancellableTask> teleportDelayTasks = new HashMap<UUID, CancellableTask>();

    public TeleportManager(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        try {
            List<Map<String, Field<?>>> res = Select.select(new FieldInteger("dom_id")).from("tp_cache").where("uuid = ?", event.getPlayer().getUniqueId().toString()).execute();
            if (res.isEmpty()) {
                return;
            }
            Integer dominionId = (Integer)res.get(0).get("dom_id").getValue();
            Delete.delete().from("tp_cache").where("uuid = ?", event.getPlayer().getUniqueId().toString()).execute();
            DominionDTO dominion = CacheManager.instance.getDominion(dominionId);
            if (dominion == null) {
                Notification.error(event.getPlayer(), Language.convertsText.unknownDominion, dominionId);
                return;
            }
            if (dominion.getServerId() != Configuration.multiServer.serverId) {
                return;
            }
            TeleportManager.doTeleportSafely(event.getPlayer(), dominion.getTpLocation());
        }
        catch (Exception e) {
            Notification.error((CommandSender)event.getPlayer(), e);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!teleportDelayTasks.containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        CancellableTask task = teleportDelayTasks.remove(event.getPlayer().getUniqueId());
        if (task != null) {
            task.cancel();
        }
        Notification.warn(event.getPlayer(), Language.teleportManagerText.cancelMove);
    }

    public static void teleportToDominion(Player player, DominionDTO dominion) {
        if (!(Configuration.getPlayerLimitation((Player)player).teleportation.enable || player.hasPermission(Dominion.adminPermission) && Configuration.adminBypass)) {
            Notification.warn(player, Language.teleportManagerText.disabled);
            return;
        }
        if (!Others.checkPrivilegeFlag(dominion, Flags.TELEPORT, player, null)) {
            return;
        }
        boolean needCooldown = Configuration.getPlayerLimitation((Player)player).teleportation.cooldown > 0;
        int delaySec = Configuration.getPlayerLimitation((Player)player).teleportation.delay;
        if (player.hasPermission(Dominion.adminPermission) && Configuration.adminBypass) {
            needCooldown = false;
            delaySec = 0;
        }
        if (needCooldown) {
            int currentTs = (int)(System.currentTimeMillis() / 1000L);
            if (teleportCooldown.containsKey(player.getUniqueId()) && teleportCooldown.get(player.getUniqueId()) > currentTs) {
                Notification.warn(player, Language.teleportManagerText.coolingDown, teleportCooldown.get(player.getUniqueId()) - currentTs);
                return;
            }
            teleportCooldown.put(player.getUniqueId(), currentTs + Configuration.getPlayerLimitation((Player)player).teleportation.cooldown);
        }
        if (teleportDelayTasks.containsKey(player.getUniqueId())) {
            teleportDelayTasks.get(player.getUniqueId()).cancel();
            teleportDelayTasks.remove(player.getUniqueId());
            Notification.warn(player, Language.teleportManagerText.unfinishedCancelled);
        }
        if (delaySec > 0) {
            Notification.info(player, Language.teleportManagerText.delay, delaySec);
        }
        CancellableTask task = Scheduler.runTaskLaterAsync(() -> {
            if (dominion.getServerId() == Configuration.multiServer.serverId) {
                TeleportManager.doTeleportSafely(player, dominion.getTpLocation());
            } else {
                if (!Configuration.multiServer.enable) {
                    return;
                }
                try {
                    FieldString cacheUuid = new FieldString("uuid", player.getUniqueId().toString());
                    FieldInteger cacheDomId = new FieldInteger("dom_id", dominion.getId());
                    Insert.insert().into("tp_cache").values(cacheUuid, cacheDomId).onConflict("uuid").doUpdate().execute();
                    MultiServerManager.instance.connectToServer(player, MultiServerManager.instance.getServerName(dominion.getServerId()));
                }
                catch (Exception e) {
                    Notification.error((CommandSender)player, e);
                }
            }
        }, (long)delaySec * 20L);
        Scheduler.runTaskLaterAsync(() -> teleportDelayTasks.remove(player.getUniqueId()), (long)delaySec * 20L + 1L);
        teleportDelayTasks.put(player.getUniqueId(), task);
    }

    public static void doTeleportSafely(Player player, Location location) {
        if (!player.getPassengers().isEmpty()) {
            player.getPassengers().forEach(arg_0 -> ((Player)player).removePassenger(arg_0));
        }
        if (!Misc.isPaper()) {
            Location loc = SafeLocationFinder.findNearestSafeLocation(location);
            Bukkit.getScheduler().runTask((Plugin)Dominion.instance, () -> player.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN));
        } else {
            location.getWorld().getChunkAtAsyncUrgently(location).thenAccept(chunk -> {
                Location loc = SafeLocationFinder.findNearestSafeLocation(location);
                player.teleportAsync(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            });
        }
    }

    public static class TeleportManagerText
    extends ConfigurationPart {
        public String coolingDown = "Please wait for {0} seconds before teleporting again.";
        public String disabled = "Teleportation is disabled for your permission group.";
        public String delay = "Will teleport in {0} seconds, don't move...";
        public String unfinishedCancelled = "Cancelled previous unfinished teleportation.";
        public String cancelMove = "Cancelled teleportation due to movement.";
    }
}

