/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class AllDominion
extends AbstractUI {
    public static SecondaryCommand listAll = new SecondaryCommand("list_all", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            AllDominion.show(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.adminPermission).register();

    public static void show(CommandSender sender, String pageStr) {
        new AllDominion().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.allDominionTuiText.button){

            @Override
            public void function(String pageStr) {
                AllDominion.show(sender, pageStr);
            }
        }.needPermission(Dominion.adminPermission);
    }

    @Override
    protected void showTUI(CommandSender sender, String ... args) {
        int page = Converts.toIntegrity(args[0], 1);
        ListView view = ListView.create(10, AllDominion.button(sender));
        view.title(Language.allDominionTuiText.title);
        view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.allDominionTuiText.button));
        view.addLines(DominionList.BuildTreeLines(sender, CacheManager.instance.getCache().getDominionCache().getAllDominionNodes(), 0));
        view.showOn(sender, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.allDominionCui.title);
        view.applyListConfiguration(ChestUserInterface.allDominionCui.listConfiguration, Converts.toIntegrity(args[0]));
        List<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getAllDominions();
        for (final DominionDTO dominion : dominions) {
            ChestButton btn = new ChestButton(ChestUserInterface.allDominionCui.dominionItemButton){

                @Override
                public void onClick(ClickType type) {
                    if (type.isLeftClick()) {
                        DominionManage.show((CommandSender)player, dominion.getName(), "1");
                    } else if (type.isRightClick()) {
                        TeleportManager.teleportToDominion(player, dominion);
                    }
                }
            };
            btn = btn.setDisplayNameArgs(dominion.getName());
            btn = btn.setLoreArgs(List.of(dominion.getOwnerDTO().getLastKnownName()));
            view = view.addItem(btn);
        }
        view.setButton(ChestUserInterface.allDominionCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.allDominionCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MainMenu.show((CommandSender)player, "1");
            }
        });
        view.open();
    }

    public static class AllDominionTuiText
    extends ConfigurationPart {
        public String title = "All Dominions";
        public String description = "List all dominions.";
        public String button = "LIST ALL";
    }

    public static class AllDominionCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7c\u00a7lAll Dominions \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration dominionItemButton = ButtonConfiguration.createMaterial('i', Material.FILLED_MAP, "\u00a76\ud83c\udff0 \u00a7e{0}", List.of("\u00a77Owner: \u00a7b{0}", "", "\u00a7a\u25b6 Left Click: manage", "\u00a78  View settings, members & permissions", "\u00a7b\u25b6 Right Click: teleport", "", "\u00a77Status: \u00a7aActive", "\u00a78Admin access granted"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Main Menu", List.of("\u00a77Return to the main menu", "\u00a78to access other features.", "", "\u00a7e\u25b6 Click to go back"));
    }
}

