/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.GroupTitleCommand;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class TitleList
extends AbstractUI {
    public static SecondaryCommand titleList = new SecondaryCommand("title_list", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                TitleList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String pageStr) {
        new TitleList().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.titleListTuiText.button){

            @Override
            public void function(String pageStr) {
                TitleList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final CommandSender sender, final String ... args) throws Exception {
        Player player = Converts.toPlayer(sender);
        int page = Converts.toIntegrity(args[0], 1);
        ListView view = ListView.create(10, TitleList.button(sender));
        view.title(Language.titleListTuiText.title);
        view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.titleListTuiText.button));
        List<GroupDTO> groups = CacheManager.instance.getPlayerCache().getPlayerGroupTitleList(player.getUniqueId());
        CopyOnWriteArrayList<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getPlayerOwnDominionDTOs(player.getUniqueId());
        for (DominionDTO dominion : dominions) {
            groups.addAll(dominion.getGroups());
        }
        PlayerDTO playerDTO = CacheManager.instance.getPlayerCache().getPlayer(player.getUniqueId());
        if (playerDTO == null) {
            return;
        }
        Integer usingId = playerDTO.getUsingGroupTitleID();
        GroupDTO using = CacheManager.instance.getGroup(usingId);
        for (final GroupDTO group : groups) {
            DominionDTO dominion = CacheManager.instance.getDominion(group.getDomID());
            if (dominion == null) continue;
            Line line = Line.create();
            line.append(Component.text((String)(group.getId() + ". ")));
            if (using != null && using.getId().equals(group.getId())) {
                line.append(new FunctionalButton(Language.titleListTuiText.disuseButton){

                    @Override
                    public void function() {
                        GroupTitleCommand.useTitle(sender, "-1", args[0]);
                    }
                }.needPermission(Dominion.defaultPermission).red().build());
            } else {
                line.append(new FunctionalButton(Language.titleListTuiText.useButton){

                    @Override
                    public void function() {
                        GroupTitleCommand.useTitle(sender, group.getId().toString(), args[0]);
                    }
                }.needPermission(Dominion.defaultPermission).green().build());
            }
            line.append(group.getNameColoredComponent().hoverEvent((HoverEventSource)Component.text((String)Misc.formatString(Language.titleListTuiText.fromDominion, dominion.getName()))));
            view.add(line);
        }
        view.showOn((CommandSender)player, page);
    }

    @Override
    protected void showCUI(final Player player, final String ... args) throws Exception {
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.titleListCui.title);
        view.applyListConfiguration(ChestUserInterface.titleListCui.listConfiguration, Converts.toIntegrity(args[0], 1));
        List<GroupDTO> groups = CacheManager.instance.getPlayerCache().getPlayerGroupTitleList(player.getUniqueId());
        CopyOnWriteArrayList<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getPlayerOwnDominionDTOs(player.getUniqueId());
        for (DominionDTO dominion : dominions) {
            groups.addAll(dominion.getGroups());
        }
        PlayerDTO playerDTO = CacheManager.instance.getPlayerCache().getPlayer(player.getUniqueId());
        if (playerDTO == null) {
            return;
        }
        Integer usingId = playerDTO.getUsingGroupTitleID();
        GroupDTO using = CacheManager.instance.getGroup(usingId);
        for (final GroupDTO group : groups) {
            DominionDTO dominion = CacheManager.instance.getDominion(group.getDomID());
            if (dominion == null) continue;
            final boolean isActive = using != null && using.getId().equals(group.getId());
            ChestButton btn = new ChestButton(isActive ? ChestUserInterface.titleListCui.activeTitleItemButton : ChestUserInterface.titleListCui.titleItemButton){

                @Override
                public void onClick(ClickType type) {
                    if (isActive) {
                        GroupTitleCommand.useTitle((CommandSender)player, "-1", args[0]);
                    } else {
                        GroupTitleCommand.useTitle((CommandSender)player, group.getId().toString(), args[0]);
                    }
                }
            };
            btn = btn.setDisplayNameArgs(group.getNamePlain());
            btn = btn.setLoreArgs(dominion.getName());
            view = view.addItem(btn);
        }
        view.setButton(ChestUserInterface.titleListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.titleListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MainMenu.show((CommandSender)player, "1");
            }
        });
        view.open();
    }

    public static class TitleListTuiText
    extends ConfigurationPart {
        public String title = "Group Title List";
        public String description = "List of group titles you can use.";
        public String button = "TITLES";
        public String useButton = "USE";
        public String disuseButton = "DISUSE";
        public String fromDominion = "From dominion {0}";
    }

    public static class TitleListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7d\u00a7lGroup Title List \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration titleItemButton = ButtonConfiguration.createMaterial('i', Material.NAME_TAG, "\u00a76\u2726 \u00a7f{0} \u00a76\u2726", List.of("\u00a77From dominion: \u00a7b{0}", "", "\u00a7e\u25b6 Click to equip this title", "\u00a78  and show it to everyone!", "", "\u00a77Status: \u00a7cInactive"));
        public ButtonConfiguration activeTitleItemButton = ButtonConfiguration.createMaterial('i', Material.GOLDEN_HELMET, "\u00a76\u2605 \u00a7e{0} \u00a76\u2605 \u00a7a(ACTIVE)", List.of("\u00a77From dominion: \u00a7b{0}", "", "\u00a7a\u2713 This is your current title", "\u00a78  Everyone can see this!", "", "\u00a7c\u25b6 Click to remove this title", "", "\u00a77Status: \u00a7aActive"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Main Menu", List.of("\u00a77Return to the main menu", "\u00a78to access other features.", "", "\u00a7e\u25b6 Click to go back"));
    }
}

