/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.copy;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.CopyCommand;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.dominion.copy.CopyMenu;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class DominionCopy
extends AbstractUI {
    public static void show(CommandSender sender, String toDominionName, CopyType copyType, String pageStr) {
        new DominionCopy().displayByPreference(sender, toDominionName, copyType.name(), pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String toDominionName, final CopyType copyType) {
        return (ListViewButton)new ListViewButton(switch (copyType) {
            case CopyType.ENVIRONMENT -> Language.dominionCopyTuiText.envButton;
            case CopyType.GUEST -> Language.dominionCopyTuiText.guestButton;
            case CopyType.MEMBER -> Language.dominionCopyTuiText.memberButton;
            case CopyType.GROUP -> Language.dominionCopyTuiText.groupButton;
            default -> throw new IllegalArgumentException("Unknown copy type: " + String.valueOf((Object)copyType));
        }){

            @Override
            public void function(String pageStr) {
                DominionCopy.show(sender, toDominionName, copyType, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final CommandSender sender, String ... args) throws Exception {
        final String toDominionName = args[0];
        final CopyType copyType = CopyType.valueOf(args[1]);
        int page = Converts.toIntegrity(args[2]);
        DominionDTO dominion = Converts.toDominionDTO(toDominionName);
        Player player = Converts.toPlayer(sender);
        Asserts.assertDominionAdmin(sender, dominion);
        ListView view = ListView.create(10, DominionCopy.button(sender, toDominionName, copyType));
        view.title(Language.dominionCopyTuiText.title).navigator(Line.create().append(CopyMenu.button(sender, toDominionName).setText(Language.dominionCopyTuiText.back).build()));
        List<DominionDTO> dominions = CacheManager.instance.getPlayerOwnDominionDTOs(player.getUniqueId());
        for (DominionDTO fromDominion : dominions) {
            if (fromDominion.getId().equals(dominion.getId())) continue;
            final String fromDominionName = fromDominion.getName();
            FunctionalButton item = (FunctionalButton)new FunctionalButton(Language.dominionCopyTuiText.copy){

                @Override
                public void function() {
                    switch (copyType) {
                        case ENVIRONMENT: {
                            CopyCommand.copyEnvironment(sender, fromDominionName, toDominionName);
                            break;
                        }
                        case GUEST: {
                            CopyCommand.copyGuest(sender, fromDominionName, toDominionName);
                            break;
                        }
                        case MEMBER: {
                            CopyCommand.copyMember(sender, fromDominionName, toDominionName);
                            break;
                        }
                        case GROUP: {
                            CopyCommand.copyGroup(sender, fromDominionName, toDominionName);
                        }
                    }
                }
            }.needPermission(Dominion.defaultPermission);
            view.add(Line.create().append(item.build()).append(Component.text((String)fromDominionName)));
        }
        view.showOn(sender, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String toDominionName = args[0];
        final CopyType copyType = CopyType.valueOf(args[1]);
        int page = Converts.toIntegrity(args[2]);
        DominionDTO dominion = Converts.toDominionDTO(toDominionName);
        Asserts.assertDominionAdmin(player, dominion);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.dominionCopyCui.title);
        view.applyListConfiguration(ChestUserInterface.dominionCopyCui.listConfiguration, page);
        List<DominionDTO> dominions = CacheManager.instance.getPlayerOwnDominionDTOs(player.getUniqueId());
        for (final DominionDTO fromDominion : dominions) {
            if (fromDominion.getId().equals(dominion.getId())) continue;
            ButtonConfiguration itemConfig = ButtonConfiguration.createMaterial(ChestUserInterface.dominionCopyCui.listConfiguration.itemSymbol.charAt(0), Material.GRASS_BLOCK, Misc.formatString(ChestUserInterface.dominionCopyCui.itemName, fromDominion.getName()), ChestUserInterface.dominionCopyCui.itemLore);
            view.addItem(new ChestButton(itemConfig){

                @Override
                public void onClick(ClickType type) {
                    switch (copyType) {
                        case ENVIRONMENT: {
                            CopyCommand.copyEnvironment((CommandSender)player, fromDominion.getName(), toDominionName);
                            break;
                        }
                        case GUEST: {
                            CopyCommand.copyGuest((CommandSender)player, fromDominion.getName(), toDominionName);
                            break;
                        }
                        case MEMBER: {
                            CopyCommand.copyMember((CommandSender)player, fromDominion.getName(), toDominionName);
                            break;
                        }
                        case GROUP: {
                            CopyCommand.copyGroup((CommandSender)player, fromDominion.getName(), toDominionName);
                        }
                    }
                    player.closeInventory();
                }
            });
        }
        view.setButton(ChestUserInterface.dominionCopyCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.dominionCopyCui.backButton){

            @Override
            public void onClick(ClickType type) {
                CopyMenu.show((CommandSender)player, toDominionName, "1");
            }
        });
        view.open();
    }

    public static enum CopyType {
        ENVIRONMENT,
        GUEST,
        MEMBER,
        GROUP;

    }

    public static class DominionCopyTuiText
    extends ConfigurationPart {
        public String back = "BACK";
        public String copy = "COPY FROM";
        public String title = "Select Dominion to Copy From";
        public String envButton = "ENV";
        public String envDescription = "Copy Env Settings From Other Dominion.";
        public String groupButton = "GROUPS";
        public String groupDescription = "Copy Group & Settings From Other Dominion.";
        public String guestButton = "GUEST";
        public String guestDescription = "Copy Guest Settings From Other Dominion.";
        public String memberButton = "MEMBERS";
        public String memberDescription = "Copy Member & Settings From Other Dominion.";
    }

    public static class DominionCopyCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7a\u00a7lSelect Dominion to Copy \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "#p#####n#"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Copy Menu", List.of("\u00a77Return to the copy menu", "\u00a77to select a different copy type.", "", "\u00a7e\u25b6 Click to go back"));
        public String itemName = "\u00a7a{0}";
        public List<String> itemLore = List.of("\u00a77Copy from this dominion", "\u00a77to apply its settings.", "", "\u00a7a\u25b6 Click to select");
    }
}

