/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.dominion.modify.DominionReSizeEvent;
import cn.lunadeer.dominion.inputters.ResizeDominionInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.manage.Info;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.ChestView;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class SetSize
extends AbstractUI {
    private static final List<DirectionInfo> DIRECTIONS = Arrays.asList(new DirectionInfo(DominionReSizeEvent.DIRECTION.NORTH, () -> Language.setSizeTuiText.north), new DirectionInfo(DominionReSizeEvent.DIRECTION.SOUTH, () -> Language.setSizeTuiText.south), new DirectionInfo(DominionReSizeEvent.DIRECTION.WEST, () -> Language.setSizeTuiText.west), new DirectionInfo(DominionReSizeEvent.DIRECTION.EAST, () -> Language.setSizeTuiText.east), new DirectionInfo(DominionReSizeEvent.DIRECTION.UP, () -> Language.setSizeTuiText.up), new DirectionInfo(DominionReSizeEvent.DIRECTION.DOWN, () -> Language.setSizeTuiText.down));

    public static void show(CommandSender sender, String dominionName) {
        new SetSize().displayByPreference(sender, dominionName);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.setSizeTuiText.button){

            @Override
            public void function(String pageStr) {
                SetSize.show(sender, dominionName);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(CommandSender sender, String ... args) {
        String dominionName = args[0];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionOwner(sender, dominion);
        ListView view = this.createTUIView(sender, dominion);
        this.addDirectionButtons(view, sender, dominion.getName());
        view.showOn(sender, 1);
    }

    private ListView createTUIView(CommandSender sender, DominionDTO dominion) {
        ListView view = ListView.create(10, SetSize.button(sender, dominion.getName()));
        view.title(Misc.formatString(Language.setSizeTuiText.title, dominion.getName()));
        view.navigator(this.createNavigationLine(sender, dominion.getName()));
        return view;
    }

    private Line createNavigationLine(CommandSender sender, String dominionName) {
        return Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Info.button(sender, dominionName).build()).append(Language.setSizeTuiText.button);
    }

    private void addDirectionButtons(ListView view, CommandSender sender, String dominionName) {
        for (DirectionInfo directionInfo : DIRECTIONS) {
            view.add(this.createDirectionLine(sender, dominionName, directionInfo));
        }
    }

    private Line createDirectionLine(CommandSender sender, String dominionName, DirectionInfo directionInfo) {
        return Line.create().append(directionInfo.getDisplayName()).append(ResizeDominionInputter.createExpandTuiButtonOn(sender, dominionName, directionInfo.getDirection()).build()).append(ResizeDominionInputter.createContractTuiButtonOn(sender, dominionName, directionInfo.getDirection()).build());
    }

    @Override
    protected void showCUI(Player player, String ... args) {
        String dominionName = args[0];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionOwner(player, dominion);
        ChestView view = this.createCUIView(player, dominion);
        this.setupCUIButtons(view, player, dominion);
        view.open();
    }

    private ChestView createCUIView(Player player, DominionDTO dominion) {
        ChestView view = ChestUserInterfaceManager.getInstance().getViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.setSizeCui.title, dominion.getName()));
        view.setLayout(ChestUserInterface.setSizeCui.layout);
        return view;
    }

    private void setupCUIButtons(ChestView view, Player player, DominionDTO dominion) {
        this.setupBackButton(view, player, dominion);
        this.setupDirectionButtons(view, player, dominion);
    }

    private void setupBackButton(ChestView view, final Player player, final DominionDTO dominion) {
        view.setButton(ChestUserInterface.setSizeCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.setSizeCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionManage.show((CommandSender)player, dominion.getName(), "1");
            }
        });
    }

    private void setupDirectionButtons(ChestView view, Player player, DominionDTO dominion) {
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addNorthButton, DominionReSizeEvent.DIRECTION.NORTH);
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addSouthButton, DominionReSizeEvent.DIRECTION.SOUTH);
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addWestButton, DominionReSizeEvent.DIRECTION.WEST);
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addEastButton, DominionReSizeEvent.DIRECTION.EAST);
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addUpButton, DominionReSizeEvent.DIRECTION.UP);
        this.setupExpandButton(view, player, dominion, ChestUserInterface.setSizeCui.addDownButton, DominionReSizeEvent.DIRECTION.DOWN);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractNorthButton, DominionReSizeEvent.DIRECTION.NORTH);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractSouthButton, DominionReSizeEvent.DIRECTION.SOUTH);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractWestButton, DominionReSizeEvent.DIRECTION.WEST);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractEastButton, DominionReSizeEvent.DIRECTION.EAST);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractUpButton, DominionReSizeEvent.DIRECTION.UP);
        this.setupContractButton(view, player, dominion, ChestUserInterface.setSizeCui.contractDownButton, DominionReSizeEvent.DIRECTION.DOWN);
    }

    private void setupExpandButton(ChestView view, final Player player, final DominionDTO dominion, ButtonConfiguration buttonConfig, final DominionReSizeEvent.DIRECTION direction) {
        view.setButton(buttonConfig.getSymbol(), new ChestButton(buttonConfig){

            @Override
            public void onClick(ClickType type) {
                ResizeDominionInputter.createExpandOn((CommandSender)player, dominion.getName(), direction);
            }
        });
    }

    private void setupContractButton(ChestView view, final Player player, final DominionDTO dominion, ButtonConfiguration buttonConfig, final DominionReSizeEvent.DIRECTION direction) {
        view.setButton(buttonConfig.getSymbol(), new ChestButton(buttonConfig){

            @Override
            public void onClick(ClickType type) {
                ResizeDominionInputter.createContractOn((CommandSender)player, dominion.getName(), direction);
            }
        });
    }

    public static class SetSizeTuiText
    extends ConfigurationPart {
        public String title = "Resize {0}";
        public String button = "RESIZE";
        public String north = "North(z-)";
        public String south = "South(z+)";
        public String west = "West(x-)";
        public String east = "East(x+)";
        public String up = "Up(y+)";
        public String down = "Down(y-)";
    }

    private static class DirectionInfo {
        private final DominionReSizeEvent.DIRECTION direction;
        private final Supplier<String> displayNameSupplier;

        public DirectionInfo(DominionReSizeEvent.DIRECTION direction, Supplier<String> displayNameSupplier) {
            this.direction = direction;
            this.displayNameSupplier = displayNameSupplier;
        }

        public DominionReSizeEvent.DIRECTION getDirection() {
            return this.direction;
        }

        public String getDisplayName() {
            return this.displayNameSupplier.get();
        }
    }

    public static class SetSizeCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a72\u00a7lResize {0} \u00a76\u2726";
        public List<String> layout = List.of("<########", "##Nn##Uu#", "#Ww#Ee###", "##Ss##Dd#", "#########");
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion Management", List.of("\u00a77Return to the dominion", "\u00a77management menu.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration addNorthButton = ButtonConfiguration.createMaterial('N', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand North (Z-)", List.of("\u00a77Expand the dominion to the north", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration addSouthButton = ButtonConfiguration.createMaterial('S', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand South (Z+)", List.of("\u00a77Expand the dominion to the south", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration addWestButton = ButtonConfiguration.createMaterial('W', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand West (X-)", List.of("\u00a77Expand the dominion to the west", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration addEastButton = ButtonConfiguration.createMaterial('E', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand East (X+)", List.of("\u00a77Expand the dominion to the east", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration addUpButton = ButtonConfiguration.createMaterial('U', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand Up (Y+)", List.of("\u00a77Expand the dominion upwards", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration addDownButton = ButtonConfiguration.createMaterial('D', Material.OAK_SIGN, "\u00a76\ud83e\udded \u00a7eExpand Down (Y-)", List.of("\u00a77Expand the dominion downwards", "\u00a77with input size.", "", "\u00a7a\u25b6 Click to expand"));
        public ButtonConfiguration contractNorthButton = ButtonConfiguration.createMaterial('n', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract North (Z-)", List.of("\u00a77Contract the dominion from the north", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
        public ButtonConfiguration contractSouthButton = ButtonConfiguration.createMaterial('s', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract South (Z+)", List.of("\u00a77Contract the dominion from the south", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
        public ButtonConfiguration contractWestButton = ButtonConfiguration.createMaterial('w', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract West (X-)", List.of("\u00a77Contract the dominion from the west", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
        public ButtonConfiguration contractEastButton = ButtonConfiguration.createMaterial('e', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract East (X+)", List.of("\u00a77Contract the dominion from the east", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
        public ButtonConfiguration contractUpButton = ButtonConfiguration.createMaterial('u', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract Up (Y+)", List.of("\u00a77Contract the dominion upwards", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
        public ButtonConfiguration contractDownButton = ButtonConfiguration.createMaterial('d', Material.BARRIER, "\u00a76\ud83e\udded \u00a7cContract Down (Y-)", List.of("\u00a77Contract the dominion downwards", "\u00a77with input size.", "", "\u00a7c\u25b6 Click to contract"));
    }
}

