/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.GroupDOO;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.inputters.CreateGroupInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupManage;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupSetting;
import cn.lunadeer.dominion.uis.dominion.manage.group.SelectMember;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class GroupList
extends AbstractUI {
    public static SecondaryCommand list = new SecondaryCommand("group_list", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupList.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String dominionName, String pageStr) {
        new GroupList().displayByPreference(sender, dominionName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.groupListTuiText.button){

            @Override
            public void function(String page) {
                GroupList.show(sender, dominionName, page);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final CommandSender sender, String ... args) throws Exception {
        final String dominionName = args[0];
        final String pageStr = args[1];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(sender, dominion);
        int page = Converts.toIntegrity(pageStr);
        List<GroupDOO> groups = GroupDOO.selectByDominionId(dominion.getId());
        ListView view = ListView.create(10, GroupList.button(sender, dominionName));
        view.title(Misc.formatString(Language.groupListTuiText.title, dominion.getName()));
        view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Language.groupListTuiText.button));
        view.add(new Line().append(CreateGroupInputter.createTuiButtonOn(sender, dominionName).needPermission(Dominion.defaultPermission).build()));
        ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
        for (final GroupDTO groupDTO : groups) {
            Line line = new Line();
            Button deleteGroup = new FunctionalButton(Language.groupListTuiText.deleteButton){

                @Override
                public void function() {
                    GroupCommand.deleteGroup(sender, dominionName, groupDTO.getNamePlain(), pageStr);
                }
            }.needPermission(Dominion.defaultPermission).red().setHoverText(Language.groupListTuiText.deleteDescription);
            ListViewButton setting = GroupSetting.button(sender, dominionName, groupDTO.getNamePlain());
            ListViewButton addMember = SelectMember.button(sender, dominionName, groupDTO.getNamePlain(), pageStr);
            line.append(deleteGroup.build()).append(setting.build()).append(groupDTO.getNameColoredComponent()).append(addMember.build());
            view.add(line);
            for (MemberDTO memberDTO : members) {
                if (!memberDTO.getGroupId().equals(groupDTO.getId())) continue;
                final PlayerDTO p = Converts.toPlayerDTO(memberDTO.getPlayerUUID());
                Button remove = new FunctionalButton("-"){

                    @Override
                    public void function() {
                        GroupCommand.removeMember(sender, dominionName, groupDTO.getNamePlain(), p.getLastKnownName(), pageStr);
                    }
                }.needPermission(Dominion.defaultPermission).red().setHoverText(Language.groupListTuiText.removeMemberDescription);
                Line playerLine = new Line().setDivider("");
                playerLine.append(Component.text((String)"        "));
                playerLine.append(remove.build()).append(" |  " + p.getLastKnownName());
                view.add(playerLine);
            }
            view.add(new Line().append(""));
        }
        view.showOn(sender, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        String dominionName = args[0];
        final DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.groupListCui.title, dominion.getName()));
        view.applyListConfiguration(ChestUserInterface.groupListCui.listConfiguration, Converts.toIntegrity(args[1]));
        view.setButton(ChestUserInterface.groupListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.groupListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionManage.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.groupListCui.newGroupButton){

            @Override
            public void onClick(ClickType type) {
                CreateGroupInputter.createOn((CommandSender)player, dominion.getName());
                view.close();
            }
        });
        for (final GroupDTO group : dominion.getGroups()) {
            ChestButton groupChest = new ChestButton(ChestUserInterface.groupListCui.groupItemButton){

                @Override
                public void onClick(ClickType type) {
                    GroupManage.show((CommandSender)player, dominion.getName(), group.getNamePlain(), "1");
                }
            }.setDisplayNameArgs(group.getNameColoredBukkit()).setLoreArgs(group.getMembers().size());
            view.addItem(groupChest);
        }
        view.open();
    }

    public static class GroupListTuiText
    extends ConfigurationPart {
        public String title = "{0} Group List";
        public String description = "List of groups of this dominion.";
        public String button = "GROUPS";
        public String deleteButton = "DELETE";
        public String deleteDescription = "Delete this group, all members will be move out of this group.";
        public String removeMemberDescription = "Remove {0} from group {1} to default group.";
    }

    public static class GroupListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a75\u00a7lGroup List of {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion Management", List.of("\u00a77Return to the dominion", "\u00a77management menu.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration newGroupButton = ButtonConfiguration.createMaterial('i', Material.LIME_DYE, "\u00a7a\u2795 \u00a72Create New Group", List.of("\u00a77Create a new permission group", "\u00a77for organizing your members.", "", "\u00a72\u25b6 Click to create group", "", "\u00a78Perfect for ranks and roles!"));
        public ButtonConfiguration groupItemButton = ButtonConfiguration.createMaterial('i', Material.CHEST, "\u00a76\ud83d\udc51 \u00a7e{0}", List.of("\u00a77Members: \u00a7a{0}", "", "\u00a7e\u25b6 Click to manage this group", "\u00a78  Edit permissions, add members...", "", "\u00a77Type: \u00a76Permission Group"));
    }
}

