/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.manage.member.MemberSetting;
import cn.lunadeer.dominion.uis.dominion.manage.member.SelectPlayer;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class MemberList
extends AbstractUI {
    public static SecondaryCommand list = new SecondaryCommand("member_list", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberList.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    private static final TextComponent adminTag = (TextComponent)Component.text((String)"[A]", (Style)Style.style((TextColor)TextColor.color((int)97, (int)97, (int)210))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagAdmin));
    private static final TextComponent normalTag = (TextComponent)Component.text((String)"[N]", (Style)Style.style((TextColor)TextColor.color((int)255, (int)255, (int)255))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagNormal));
    private static final TextComponent banTag = (TextComponent)Component.text((String)"[B]", (Style)Style.style((TextColor)TextColor.color((int)255, (int)67, (int)0))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagBan));
    private static final TextComponent groupTag = (TextComponent)Component.text((String)"[G]", (Style)Style.style((TextColor)TextColor.color((int)0, (int)185, (int)153))).hoverEvent((HoverEventSource)Component.text((String)Language.memberListTuiText.tagGroup));

    public static void show(CommandSender sender, String dominionName, String pageStr) {
        new MemberList().displayByPreference(sender, dominionName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.memberListTuiText.button){

            @Override
            public void function(String pageStr) {
                MemberList.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final CommandSender sender, String ... args) throws Exception {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(sender, dominion);
        final int page = Converts.toIntegrity(args[1], 1);
        ListView view = ListView.create(10, MemberList.button(sender, dominion.getName()));
        view.title(Misc.formatString(Language.memberListTuiText.title, dominion.getName()));
        view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominion.getName()).build()).append(Language.memberListTuiText.button));
        view.add(Line.create().append(SelectPlayer.button(sender, dominion.getName()).build()));
        ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
        for (MemberDTO memberDTO : members) {
            final PlayerDTO p_player = memberDTO.getPlayer();
            GroupDTO group = CacheManager.instance.getGroup(memberDTO.getGroupId());
            Line line = Line.create();
            if (group != null) {
                line.append(groupTag);
            } else if (memberDTO.getFlagValue(Flags.ADMIN).booleanValue()) {
                line.append(adminTag);
            } else if (!memberDTO.getFlagValue(Flags.MOVE).booleanValue()) {
                line.append(banTag);
            } else {
                line.append(normalTag);
            }
            Button prev = MemberSetting.button(sender, dominion.getName(), p_player.getLastKnownName()).green();
            Button remove = new FunctionalButton(Language.memberListTuiText.remove){

                @Override
                public void function() {
                    MemberCommand.removeMember(sender, dominion.getName(), p_player.getLastKnownName(), String.valueOf(page));
                }
            }.setHoverText(Language.memberListTuiText.removeDescription).red();
            boolean disable = false;
            try {
                Asserts.assertDominionOwner(sender, dominion);
            }
            catch (Exception e) {
                disable = memberDTO.getFlagValue(Flags.ADMIN);
            }
            if (disable) {
                prev.setDisabled(Language.memberListTuiText.ownerOnly);
                remove.setDisabled(Language.memberListTuiText.ownerOnly);
            }
            if (group != null) {
                prev.setDisabled(Misc.formatString(Language.memberListTuiText.groupOnly, group.getNamePlain()));
            }
            line.append(remove.build());
            line.append(prev.build());
            line.append(p_player.getLastKnownName());
            view.add(line);
        }
        view.showOn(sender, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.memberListCui.title, dominion.getName()));
        view.applyListConfiguration(ChestUserInterface.memberListCui.listConfiguration, Converts.toIntegrity(args[1]));
        view.setButton(ChestUserInterface.memberListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.memberListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionManage.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.memberListCui.addPlayerButton){

            @Override
            public void onClick(ClickType type) {
                SelectPlayer.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        for (final MemberDTO m : dominion.getMembers()) {
            ButtonConfiguration item = ButtonConfiguration.createHeadByName(ChestUserInterface.memberListCui.listConfiguration.itemSymbol.charAt(0), m.getPlayer().getLastKnownName(), m.getPlayer().getLastKnownName(), m.getGroupId() == -1 ? ChestUserInterface.memberListCui.playerHeadItemLore : ChestUserInterface.memberListCui.playerHeadItemLoreDisable);
            String status = ChestUserInterface.memberListCui.normalMember;
            if (m.getFlagValue(Flags.ADMIN).booleanValue()) {
                status = ChestUserInterface.memberListCui.adminMember;
            } else if (!m.getFlagValue(Flags.MOVE).booleanValue()) {
                status = ChestUserInterface.memberListCui.banMember;
            }
            view.addItem(new ChestButton(item){

                @Override
                public void onClick(ClickType type) {
                    if (m.getGroupId() == -1) {
                        MemberSetting.show((CommandSender)player, dominion.getName(), m.getPlayer().getLastKnownName(), "1");
                    }
                }
            }.setLoreArgs(status));
        }
        view.open();
    }

    public static class MemberListTuiText
    extends ConfigurationPart {
        public String title = "{0} Member List";
        public String description = "List of members of this dominion.";
        public String button = "MEMBERS";
        public String remove = "REMOVE";
        public String removeDescription = "Remove this member from this dominion.";
        public String ownerOnly = "Only owner can manage admin member.";
        public String groupOnly = "This member belong to group {0} so you can't manage it separately.";
        public String tagAdmin = "Admin can manage members and groups of this dominion.";
        public String tagNormal = "Normal members.";
        public String tagBan = "Who don't have MOVE privilege.";
        public String tagGroup = "This player belong to a group, you can't manage it separately.";
    }

    public static class MemberListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a73\u00a7lMember List of {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion Management", List.of("\u00a77Return to the dominion", "\u00a77management menu.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration addPlayerButton = ButtonConfiguration.createMaterial('i', Material.LIME_DYE, "\u00a7a\u2795 \u00a72Add New Member", List.of("\u00a77Invite a player to join", "\u00a77this dominion as a member.", "", "\u00a72\u25b6 Click to select player", "", "\u00a78Grant access to your dominion!"));
        public String normalMember = "\u00a7aNormal Member";
        public String adminMember = "\u00a7bAdmin Member";
        public String banMember = "\u00a7cBanned Member";
        public List<String> playerHeadItemLore = List.of("\u00a7e\u25b6 Click to manage permissions", "\u00a78  Set custom privileges for this player", "", "\u00a77Status: {0}");
        public List<String> playerHeadItemLoreDisable = List.of("&cThis player belongs", "&cto a group, you can't", "&cmanage it separately.");
    }
}

