/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.ChestUserInterface;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.uis.dominion.manage.member.SelectTemplate;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class MemberSetting
extends AbstractUI {
    public static SecondaryCommand setting = new SecondaryCommand("member_setting", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredPlayerArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberSetting.show(sender, this.getArgumentValue(0), this.getArgumentValue(1), "1");
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String dominionName, String playerName, String pageStr) {
        new MemberSetting().displayByPreference(sender, dominionName, playerName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName, final String playerName) {
        return (ListViewButton)new ListViewButton(Language.memberSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                MemberSetting.show(sender, dominionName, playerName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(Language.memberSettingTuiText.description);
    }

    @Override
    protected void showTUI(CommandSender sender, String ... args) throws Exception {
        String dominionName = args[0];
        String playerName = args[1];
        String pageStr = args.length > 2 ? args[2] : "1";
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        MemberDTO member = Converts.toMemberDTO(dominion, playerName);
        int page = Converts.toIntegrity(pageStr);
        ListView view = ListView.create(10, MemberSetting.button(sender, dominionName, playerName));
        view.title(Misc.formatString(Language.memberSettingTuiText.title, playerName));
        view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(MemberList.button(sender, dominionName).build()).append(Language.memberSettingTuiText.button));
        view.add(Line.create().append(SelectTemplate.button(sender, dominionName, playerName).build()));
        if (member.getFlagValue(Flags.ADMIN).booleanValue()) {
            view.add(MemberSetting.createOption(sender, Flags.ADMIN, true, playerName, dominion.getName(), page));
            view.add(MemberSetting.createOption(sender, Flags.GLOW, member.getFlagValue(Flags.GLOW), playerName, dominion.getName(), page));
        } else {
            for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
                view.add(MemberSetting.createOption(sender, flag, member.getFlagValue(flag), playerName, dominion.getName(), page));
            }
        }
        view.showOn(sender, page);
    }

    private static Line createOption(final CommandSender sender, final PriFlag flag, boolean value, final String player_name, final String dominion_name, final int page) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    MemberCommand.setMemberPrivilege(sender, dominion_name, player_name, flag.getFlagName(), "false", String.valueOf(page));
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                MemberCommand.setMemberPrivilege(sender, dominion_name, player_name, flag.getFlagName(), "true", String.valueOf(page));
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    @Override
    protected void showCUI(final Player player, final String ... args) throws Exception {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        final MemberDTO member = Converts.toMemberDTO(dominion, args[1]);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.memberSettingCui.title, args[1]));
        view.applyListConfiguration(ChestUserInterface.memberSettingCui.listConfiguration, Converts.toIntegrity(args[2]));
        view.setButton(ChestUserInterface.memberSettingCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.memberSettingCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MemberList.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.setButton(ChestUserInterface.memberSettingCui.templateButton.getSymbol(), new ChestButton(ChestUserInterface.memberSettingCui.templateButton){

            @Override
            public void onClick(ClickType type) {
                SelectTemplate.show((CommandSender)player, dominion.getName(), args[1], "1");
            }
        });
        for (int i = 0; i < Flags.getAllPriFlagsEnable().size(); ++i) {
            final PriFlag flag = Flags.getAllPriFlagsEnable().get(i);
            final Integer page = (int)Math.ceil((double)(i + 1) / (double)view.getPageSize());
            String flagState = member.getFlagValue(flag) != false ? ChestUserInterface.memberSettingCui.flagItemStateTrue : ChestUserInterface.memberSettingCui.flagItemStateFalse;
            String flagName = Misc.formatString(ChestUserInterface.memberSettingCui.flagItemName, flag.getDisplayName());
            List<String> descriptions = Misc.foldLore2Line(flag.getDescription(), 30);
            List<String> flagLore = Misc.formatStringList(ChestUserInterface.memberSettingCui.flagItemLore, flagState, descriptions.get(0), descriptions.get(1));
            ButtonConfiguration btnConfig = ButtonConfiguration.createMaterial(ChestUserInterface.memberSettingCui.listConfiguration.itemSymbol.charAt(0), flag.getMaterial(), flagName, flagLore);
            view.addItem(new ChestButton(btnConfig){

                @Override
                public void onClick(ClickType type) {
                    boolean newValue = member.getFlagValue(flag) == false;
                    MemberCommand.setMemberPrivilege((CommandSender)player, dominion.getName(), args[1], flag.getFlagName(), String.valueOf(newValue), String.valueOf(page));
                }
            });
        }
        view.open();
    }

    public static class MemberSettingTuiText
    extends ConfigurationPart {
        public String title = "{0} Member Setting";
        public String description = "Set member's privilege of dominion.";
        public String button = "SETTING";
    }

    public static class MemberSettingCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7f\u00a7lMember {0} Settings \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<######T#", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "Back", List.of("Go back to the", "member list."));
        public ButtonConfiguration templateButton = ButtonConfiguration.createMaterial('T', Material.PAPER, "\u00a7e\u270f \u00a76Select Template", List.of("\u00a77Select a template to apply", "\u00a77to this member's privileges.", "", "\u00a76\u25b6 Click to select template"));
        public String flagItemName = "&7Flag: &9{0}";
        public String flagItemStateTrue = "&a&l[ENABLED]";
        public String flagItemStateFalse = "&c&l[DISABLED]";
        public List<String> flagItemLore = List.of("&7State: {0}", "&7Des: &f{1}", "       &f{2}", "", "&7Click to toggle this flag.");
    }
}

