/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.managers.PlaceHolderApi;
import cn.lunadeer.dominion.utils.XLogger;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Misc {
    public static boolean isPaper() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String formatString(String str, Object ... args) {
        String formatStr = str;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                args[i] = "[null for formatString (args[" + i + "])]";
            }
            formatStr = formatStr.replace("{" + i + "}", args[i].toString());
        }
        return formatStr;
    }

    public static List<String> formatStringList(List<String> list, Object ... args) {
        ArrayList<String> formattedList = new ArrayList<String>(list);
        for (int i = 0; i < args.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                formattedList.set(j, ((String)formattedList.get(j)).replace("{" + i + "}", args[i].toString()));
            }
        }
        return formattedList;
    }

    public static List<String> foldLore2Line(String str, int length) {
        ArrayList<String> result = new ArrayList<String>();
        if (str.codePoints().anyMatch(codePoint -> Character.UnicodeScript.of(codePoint) == Character.UnicodeScript.HAN || Character.UnicodeScript.of(codePoint) == Character.UnicodeScript.HIRAGANA || Character.UnicodeScript.of(codePoint) == Character.UnicodeScript.KATAKANA)) {
            length /= 2;
        }
        if (str.length() > length) {
            result.add(str.substring(0, length));
            if (str.length() > 2 * length) {
                result.add(str.substring(length, 2 * length - 3) + "...");
            } else {
                result.add(str.substring(length));
            }
        } else {
            result.add(str);
            result.add("");
        }
        return result;
    }

    public static List<String> listClassOfPackage(JavaPlugin plugin, String packageName) {
        ArrayList<String> classesInPackage = new ArrayList<String>();
        String path = packageName.replace('.', '/');
        URL packageDir = plugin.getClass().getClassLoader().getResource(path);
        if (packageDir == null) {
            return classesInPackage;
        }
        String packageDirPath = packageDir.getPath();
        XLogger.debug("packageDirPath raw: {0}", packageDirPath);
        packageDirPath = packageDirPath.substring(0, packageDirPath.indexOf("jar!") + 4);
        packageDirPath = packageDirPath.replace("file:", "");
        packageDirPath = packageDirPath.replace("!", "");
        packageDirPath = URLDecoder.decode(packageDirPath, StandardCharsets.UTF_8);
        XLogger.debug("packageDirPath processed: {0}", packageDirPath);
        XLogger.debug("Unpacking class in jar: {0}", packageDirPath);
        File jarFile = new File(packageDirPath);
        if (!jarFile.exists() || !jarFile.isFile()) {
            XLogger.debug("Skipping {0} because it is not a jar file", packageDirPath);
            return classesInPackage;
        }
        try (JarFile jar = new JarFile(jarFile);){
            jar.stream().filter(entry -> entry.getName().endsWith(".class") && entry.getName().startsWith(path)).forEach(entry -> classesInPackage.add(entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6)));
        }
        catch (Exception e) {
            XLogger.debug("Failed to list classes in jar: {0}", e.getMessage());
            return classesInPackage;
        }
        return classesInPackage;
    }

    public static String setPlaceholder(Player player, String message) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceHolderApi.setPlaceholders(player, message);
        }
        return message;
    }
}

