/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.Misc;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class XLogger {
    public static XLogger instance;
    private final Logger _logger;
    private boolean _debug = false;

    public XLogger() {
        instance = this;
        this._logger = Logger.getLogger("Lunadeer");
    }

    public XLogger(@Nullable JavaPlugin plugin) {
        instance = this;
        this._logger = plugin != null ? plugin.getLogger() : Logger.getLogger("Lunadeer");
    }

    public static XLogger setDebug(boolean debug) {
        XLogger.instance._debug = debug;
        return instance;
    }

    public static boolean isDebug() {
        return XLogger.instance._debug;
    }

    public static void info(String message) {
        XLogger.instance._logger.info(" I | " + message);
    }

    public static void info(String message, Object ... args) {
        XLogger.instance._logger.info(" I | " + Misc.formatString(message, args));
    }

    public static void warn(String message) {
        XLogger.instance._logger.warning(" W | " + message);
    }

    public static void warn(String message, Object ... args) {
        XLogger.instance._logger.warning(" W | " + Misc.formatString(message, args));
    }

    public static void error(String message) {
        XLogger.instance._logger.severe(" E | " + message);
    }

    public static void error(String message, Object ... args) {
        XLogger.instance._logger.severe(" E | " + Misc.formatString(message, args));
    }

    public static void error(Throwable e) {
        XLogger.instance._logger.severe(" E | " + e.getMessage());
        if (XLogger.isDebug()) {
            for (StackTraceElement element : e.getStackTrace()) {
                XLogger.instance._logger.severe("StackTrace | " + element.toString());
            }
        }
    }

    public static void debug(String message) {
        if (!XLogger.instance._debug) {
            return;
        }
        XLogger.instance._logger.info(" D | " + message);
    }

    public static void debug(String message, Object ... args) {
        if (!XLogger.instance._debug) {
            return;
        }
        XLogger.instance._logger.info(" D | " + Misc.formatString(message, args));
    }
}

