/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.api;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.providers.DominionProvider;
import cn.lunadeer.dominion.providers.GroupProvider;
import cn.lunadeer.dominion.providers.MemberProvider;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DominionAPI {
    protected static DominionAPI instance;

    public static DominionAPI getInstance() {
        return instance;
    }

    @Nullable
    public abstract PlayerDTO getPlayer(String var1);

    @Nullable
    public abstract PlayerDTO getPlayer(@NotNull UUID var1);

    @NotNull
    public abstract String getPlayerName(@NotNull UUID var1);

    public abstract List<DominionDTO> getAllDominions();

    public abstract List<DominionDTO> getChildrenDominionOf(DominionDTO var1);

    @Nullable
    public abstract DominionDTO getDominion(Integer var1);

    @Nullable
    public abstract DominionDTO getDominion(String var1);

    @Nullable
    public abstract DominionDTO getDominion(Location var1);

    public abstract List<DominionDTO> getPlayerOwnDominionDTOs(UUID var1);

    public abstract List<DominionDTO> getPlayerAdminDominionDTOs(UUID var1);

    @Nullable
    public abstract MemberDTO getMember(@Nullable DominionDTO var1, @NotNull Player var2);

    @Nullable
    public abstract MemberDTO getMember(@Nullable DominionDTO var1, @NotNull UUID var2);

    @Nullable
    public abstract GroupDTO getGroup(MemberDTO var1);

    @Nullable
    public abstract GroupDTO getGroup(Integer var1);

    @Nullable
    public abstract DominionDTO getPlayerCurrentDominion(@NotNull Player var1);

    public abstract void resetPlayerCurrentDominionId(@NotNull Player var1);

    public abstract Integer dominionCount();

    public abstract Integer groupCount();

    public abstract Integer memberCount();

    public abstract boolean checkPrivilegeFlag(@NotNull Location var1, @NotNull PriFlag var2, @NotNull Player var3);

    public abstract boolean checkPrivilegeFlag(@Nullable DominionDTO var1, @NotNull PriFlag var2, @NotNull Player var3);

    public abstract boolean checkPrivilegeFlagSilence(@NotNull Location var1, @NotNull PriFlag var2, @NotNull Player var3);

    public abstract boolean checkPrivilegeFlagSilence(@Nullable DominionDTO var1, @NotNull PriFlag var2, @NotNull Player var3);

    public abstract boolean checkEnvironmentFlag(@NotNull Location var1, @NotNull EnvFlag var2);

    public abstract boolean checkEnvironmentFlag(@Nullable DominionDTO var1, @NotNull EnvFlag var2);

    public static DominionProvider getDominionProvider() {
        return DominionProvider.getInstance();
    }

    public static GroupProvider getGroupProvider() {
        return GroupProvider.getInstance();
    }

    public static MemberProvider getMemberProvider() {
        return MemberProvider.getInstance();
    }
}

