/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.LegacyToMiniMessage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Notification {
    public static Notification instance;
    private static BukkitAudiences adventure;
    private String prefix;
    private JavaPlugin plugin;

    public Notification(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.prefix = "&6[&e" + plugin.getName() + "&6]&f";
        if (!Misc.isPaper()) {
            adventure = BukkitAudiences.create((Plugin)plugin);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static void info(CommandSender sender, String msg) {
        Component adventureMessage = LegacyToMiniMessage.parse(Notification.instance.prefix + " &2" + msg);
        if (adventure != null) {
            adventure.sender(sender).sendMessage(adventureMessage);
        } else {
            sender.sendMessage(adventureMessage);
        }
    }

    public static void info(CommandSender player, String msg, Object ... args) {
        Notification.info(player, Misc.formatString(msg, args));
    }

    public static void warn(CommandSender sender, String msg) {
        Component adventureMessage = LegacyToMiniMessage.parse(Notification.instance.prefix + " &e" + msg);
        if (adventure != null) {
            adventure.sender(sender).sendMessage(adventureMessage);
        } else {
            sender.sendMessage(adventureMessage);
        }
    }

    public static void warn(CommandSender sender, String msg, Object ... args) {
        Notification.warn(sender, Misc.formatString(msg, args));
    }

    public static void error(CommandSender sender, String msg) {
        Component adventureMessage = LegacyToMiniMessage.parse(Notification.instance.prefix + " &c" + msg);
        if (adventure != null) {
            adventure.sender(sender).sendMessage(adventureMessage);
        } else {
            sender.sendMessage(adventureMessage);
        }
    }

    public static void error(CommandSender player, String msg, Object ... args) {
        Notification.error(player, Misc.formatString(msg, args));
    }

    public static void error(CommandSender player, Throwable e) {
        Notification.error(player, e.getMessage());
        if (XLogger.isDebug()) {
            XLogger.error(e);
        }
    }

    public static void all(String msg) {
        Component adventureMessage = LegacyToMiniMessage.parse(Notification.instance.prefix + " &2" + msg);
        if (adventure != null) {
            adventure.all().sendMessage(adventureMessage);
        } else {
            Notification.instance.plugin.getServer().broadcast(adventureMessage);
        }
    }

    public static void all(String msg, Object ... args) {
        Notification.all(Misc.formatString(msg, args));
    }

    public static void actionBar(Player player, String msg) {
        Component adventureMessage = LegacyToMiniMessage.parse(msg);
        if (adventure != null) {
            adventure.player(player).sendActionBar(adventureMessage);
        } else {
            player.sendActionBar(adventureMessage);
        }
    }

    public static void actionBar(Player player, String msg, Object ... args) {
        Notification.actionBar(player, Misc.formatString(msg, args));
    }

    public static void title(Player player, String title) {
        Notification.title(player, title, "");
    }

    public static void subTitle(Player player, String subtitle) {
        Notification.title(player, "", subtitle);
    }

    public static void title(Player player, String title, String subtitle) {
        Component titleAdventureMessage = LegacyToMiniMessage.parse(title);
        Component subtitleAdventureMessage = LegacyToMiniMessage.parse(subtitle);
        Title adventureTitle = Title.title((Component)titleAdventureMessage, (Component)subtitleAdventureMessage, (Title.Times)Title.DEFAULT_TIMES);
        if (adventure != null) {
            adventure.player(player).showTitle(adventureTitle);
        } else {
            player.showTitle(adventureTitle);
        }
    }

    public static void bossBar(Player player, String message) {
        NamespacedKey key = new NamespacedKey((Plugin)Notification.instance.plugin, "dominion_bossbar_" + String.valueOf(player.getUniqueId()));
        KeyedBossBar bossBar = player.getServer().createBossBar(key, ChatColor.translateAlternateColorCodes((char)'&', (String)message), BarColor.GREEN, BarStyle.SOLID, new BarFlag[0]);
        bossBar.setProgress(1.0);
        bossBar.addPlayer(player);
        bossBar.setVisible(true);
        Scheduler.runTaskLater(() -> Notification.lambda$bossBar$0(player, (BossBar)bossBar, key), 60L);
    }

    private static /* synthetic */ void lambda$bossBar$0(Player player, BossBar bossBar, NamespacedKey key) {
        if (player.isOnline()) {
            bossBar.removePlayer(player);
        }
        bossBar.setVisible(false);
        player.getServer().removeBossBar(key);
    }

    static {
        adventure = null;
    }
}

