/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.webMap.WebMapRender;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquareMapConnect
extends WebMapRender {
    private static final Logger LOGGER = Logger.getLogger(SquareMapConnect.class.getName());
    private final Squaremap api;
    private static final Key MCA_KEY = Key.of((String)"mca_layer_key");
    private static final Key DOMINION_KEY = Key.of((String)"dominion_layer_key");
    private static final MarkerOptions MCA_MARKER_OPTIONS = MarkerOptions.builder().fillColor(new Color(0, 204, 0)).fillOpacity(0.2).strokeColor(new Color(0, 204, 0)).strokeOpacity(0.8).build();
    private static final int MCA_CHUNK_SIZE = 512;

    public SquareMapConnect() {
        WebMapRender.webMapInstances.add(this);
        this.api = SquaremapProvider.get();
        this.initializeLayers();
    }

    private void initializeLayers() {
        Bukkit.getWorlds().forEach(world -> {
            try {
                this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
                    if (mapWorld.layerRegistry().get(DOMINION_KEY) == null) {
                        SimpleLayerProvider dominionProvider = SimpleLayerProvider.builder((String)"Dominion").showControls(true).build();
                        mapWorld.layerRegistry().register(DOMINION_KEY, (Object)dominionProvider);
                    }
                    if (mapWorld.layerRegistry().get(MCA_KEY) == null) {
                        SimpleLayerProvider mcaProvider = SimpleLayerProvider.builder((String)"MCA").showControls(true).build();
                        mapWorld.layerRegistry().register(MCA_KEY, (Object)mcaProvider);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to initialize layers for world: " + world.getName(), e);
            }
        });
    }

    @Override
    protected void renderDominions(@NotNull List<DominionDTO> dominions) {
        if (dominions.isEmpty()) {
            return;
        }
        Scheduler.runTaskAsync(() -> {
            try {
                Map<World, List<DominionDTO>> dominionMap = dominions.stream().filter(dominion -> dominion.getWorld() != null).collect(Collectors.groupingBy(DominionDTO::getWorld));
                dominionMap.forEach(this::renderDominionsForWorld);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error rendering dominions", e);
            }
        });
    }

    private void renderDominionsForWorld(World world, List<DominionDTO> dominionList) {
        this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
            SimpleLayerProvider dominionProvider = (SimpleLayerProvider)mapWorld.layerRegistry().get(DOMINION_KEY);
            if (dominionProvider == null) {
                LOGGER.warning("Dominion provider not found for world: " + world.getName());
                return;
            }
            dominionList.forEach(dominion -> {
                try {
                    this.renderSingleDominion(dominionProvider, (DominionDTO)dominion);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to render dominion: " + dominion.getId(), e);
                }
            });
            mapWorld.layerRegistry().unregister(DOMINION_KEY);
            mapWorld.layerRegistry().register(DOMINION_KEY, (Object)dominionProvider);
        });
    }

    private void renderSingleDominion(SimpleLayerProvider provider, DominionDTO dominion) {
        Point p1 = Point.of((double)dominion.getCuboid().x1(), (double)dominion.getCuboid().z1());
        Point p2 = Point.of((double)dominion.getCuboid().x2(), (double)dominion.getCuboid().z2());
        Color dominionColor = new Color(dominion.getColorR(), dominion.getColorG(), dominion.getColorB());
        MarkerOptions options = MarkerOptions.builder().fillColor(dominionColor).fillOpacity(0.2).strokeColor(dominionColor).strokeOpacity(0.8).build();
        Marker marker = Marker.rectangle((Point)p1, (Point)p2).markerOptions(options);
        Key key = Key.of((String)("dominion_" + dominion.getId()));
        provider.removeMarker(key);
        provider.addMarker(key, marker);
    }

    @Override
    protected void renderMCA(@NotNull Map<String, List<String>> mcaFiles) {
        if (mcaFiles.isEmpty()) {
            return;
        }
        Scheduler.runTaskAsync(() -> {
            try {
                mcaFiles.forEach(this::renderMCAForWorld);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error rendering MCA files", e);
            }
        });
    }

    private void renderMCAForWorld(String worldName, List<String> files) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            LOGGER.warning("World not found: " + worldName);
            return;
        }
        this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
            SimpleLayerProvider mcaProvider = (SimpleLayerProvider)mapWorld.layerRegistry().get(MCA_KEY);
            if (mcaProvider == null) {
                LOGGER.warning("MCA provider not found for world: " + worldName);
                return;
            }
            files.forEach(file -> {
                try {
                    this.renderSingleMCAFile(mcaProvider, worldName, (String)file);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to render MCA file: " + file, e);
                }
            });
            mapWorld.layerRegistry().unregister(MCA_KEY);
            mapWorld.layerRegistry().register(MCA_KEY, (Object)mcaProvider);
        });
    }

    private void renderSingleMCAFile(SimpleLayerProvider provider, String worldName, String file) {
        String[] coords = file.split("\\.");
        if (coords.length < 3) {
            LOGGER.warning("Invalid MCA file format: " + file);
            return;
        }
        try {
            int chunkX = Integer.parseInt(coords[1]);
            int chunkZ = Integer.parseInt(coords[2]);
            int worldX1 = chunkX * 512;
            int worldZ1 = chunkZ * 512;
            int worldX2 = (chunkX + 1) * 512;
            int worldZ2 = (chunkZ + 1) * 512;
            Point p1 = Point.of((double)worldX1, (double)worldZ1);
            Point p2 = Point.of((double)worldX2, (double)worldZ2);
            Marker marker = Marker.rectangle((Point)p1, (Point)p2).markerOptions(MCA_MARKER_OPTIONS);
            Key key = Key.of((String)("mca_" + worldName + "_" + chunkX + "_" + chunkZ));
            provider.removeMarker(key);
            provider.addMarker(key, marker);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Invalid coordinates in MCA file: " + file, e);
        }
    }
}

