/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.doos.GroupDOO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupCache
extends Cache {
    private final Integer serverId;
    private volatile ConcurrentHashMap<Integer, GroupDTO> idGroups;
    private volatile ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> dominionGroupsMap;

    public GroupCache(Integer serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public GroupDTO getGroup(Integer id) {
        ConcurrentHashMap<Integer, GroupDTO> currentGroups = this.idGroups;
        return currentGroups != null ? currentGroups.get(id) : null;
    }

    @NotNull
    public List<GroupDTO> getDominionGroups(DominionDTO dominion) {
        if (dominion == null) {
            return new ArrayList<GroupDTO>();
        }
        return this.getDominionGroups(dominion.getId());
    }

    @NotNull
    public List<GroupDTO> getDominionGroups(Integer dominionId) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> currentDominionGroupsMap = this.dominionGroupsMap;
        ConcurrentHashMap<Integer, GroupDTO> currentIdGroups = this.idGroups;
        if (currentDominionGroupsMap == null || currentIdGroups == null || !currentDominionGroupsMap.containsKey(dominionId)) {
            return List.of();
        }
        ArrayList<GroupDTO> groups = new ArrayList<GroupDTO>();
        CopyOnWriteArrayList<Integer> groupIds = currentDominionGroupsMap.get(dominionId);
        if (groupIds != null) {
            groupIds.forEach(groupId -> {
                GroupDTO group = (GroupDTO)currentIdGroups.get(groupId);
                if (group != null) {
                    groups.add(group);
                }
            });
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadExecution() throws Exception {
        ConcurrentHashMap<Integer, GroupDOO> tempIdGroups = new ConcurrentHashMap<Integer, GroupDOO>();
        ConcurrentHashMap<Integer, CopyOnWriteArrayList> tempDominionGroupsMap = new ConcurrentHashMap<Integer, CopyOnWriteArrayList>();
        List<GroupDOO> allGroups = GroupDOO.select();
        for (GroupDOO group : allGroups) {
            DominionDTO dominion = CacheManager.instance.getDominion(group.getDomID());
            if (dominion == null || !Objects.equals(dominion.getServerId(), this.serverId)) continue;
            tempIdGroups.put(group.getId(), group);
            tempDominionGroupsMap.computeIfAbsent(dominion.getId(), k -> new CopyOnWriteArrayList()).add(group.getId());
        }
        GroupCache groupCache = this;
        synchronized (groupCache) {
            this.idGroups = tempIdGroups;
            this.dominionGroupsMap = tempDominionGroupsMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        GroupDOO group = GroupDOO.select(idToLoad);
        if (group == null) {
            GroupCache groupCache = this;
            synchronized (groupCache) {
                CopyOnWriteArrayList<Integer> groupList;
                GroupDTO removed;
                if (this.idGroups != null && (removed = this.idGroups.remove(idToLoad)) != null && this.dominionGroupsMap != null && (groupList = this.dominionGroupsMap.get(removed.getDomID())) != null) {
                    groupList.remove(removed.getId());
                }
            }
            return;
        }
        if (this.idGroups == null || this.dominionGroupsMap == null) {
            this.loadExecution();
            return;
        }
        GroupCache groupCache = this;
        synchronized (groupCache) {
            CopyOnWriteArrayList<Integer> oldGroupList;
            GroupDTO old = this.idGroups.put(group.getId(), group);
            if (old != null && !Objects.equals(old.getDomID(), group.getDomID()) && (oldGroupList = this.dominionGroupsMap.get(old.getDomID())) != null) {
                oldGroupList.remove(old.getId());
            }
            this.dominionGroupsMap.computeIfAbsent(group.getDomID(), k -> new CopyOnWriteArrayList()).addIfAbsent(group.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteExecution(Integer idToDelete) {
        if (this.idGroups == null || this.dominionGroupsMap == null) {
            return;
        }
        GroupCache groupCache = this;
        synchronized (groupCache) {
            CopyOnWriteArrayList<Integer> groupList;
            GroupDTO group = this.idGroups.remove(idToDelete);
            if (group != null && (groupList = this.dominionGroupsMap.get(group.getDomID())) != null) {
                groupList.remove(group.getId());
                if (groupList.isEmpty()) {
                    this.dominionGroupsMap.remove(group.getDomID());
                }
            }
        }
    }

    public Integer count() {
        ConcurrentHashMap<Integer, GroupDTO> currentGroups = this.idGroups;
        return currentGroups != null ? currentGroups.size() : 0;
    }
}

