/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetEnvFlagEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetGuestFlagEvent;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.dominion.manage.EnvFlags;
import cn.lunadeer.dominion.uis.dominion.manage.GuestFlags;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.List;
import org.bukkit.command.CommandSender;

public class DominionFlagCommand {
    public static SecondaryCommand SetEnvFlag = new SecondaryCommand("set_env", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.EnvFlagArgument(), new CommandArguments.BollenOption(), new CommandArguments.OptionalPageArgument()), Language.dominionFlagCommandText.setEnvDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionFlagCommand.setEnv(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand SetGuestFlag = new SecondaryCommand("set_guest", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.GuestFlagArgument(), new CommandArguments.BollenOption(), new CommandArguments.OptionalPageArgument()), Language.dominionFlagCommandText.setGuestDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionFlagCommand.setGuest(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void setEnv(CommandSender sender, String dominionName, String flagName, String valueStr, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            EnvFlag flag = Converts.toEnvFlag(flagName);
            boolean value = Converts.toBoolean(valueStr);
            new DominionSetEnvFlagEvent(sender, dominion, flag, value).call();
            EnvFlags.show(sender, dominionName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setGuest(CommandSender sender, String dominionName, String flagName, String valueStr, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            PriFlag flag = Converts.toPriFlag(flagName);
            boolean value = Converts.toBoolean(valueStr);
            new DominionSetGuestFlagEvent(sender, dominion, flag, value).call();
            GuestFlags.show(sender, dominionName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static class DominionFlagCommandText
    extends ConfigurationPart {
        public String setEnvDescription = "Set environment flag for a dominion.";
        public String setGuestDescription = "Set guest privilege flag for a dominion.";
    }
}

