/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.inputters;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.group.GroupRenamedEvent;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupFlags;
import cn.lunadeer.dominion.utils.ColorParser;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.inputter.InputterRunner;
import org.bukkit.command.CommandSender;

public class RenameGroupInputter {
    public static void createOn(final CommandSender sender, final String dominionName, final String oldGroupName) {
        new InputterRunner(sender, Language.renameGroupInputterText.hint){

            @Override
            public void run(String input) {
                DominionDTO dominion = Converts.toDominionDTO(dominionName);
                GroupDTO group = Converts.toGroupDTO(dominion, oldGroupName);
                new GroupRenamedEvent(sender, dominion, group, input).call();
                GroupFlags.show(sender, dominionName, ColorParser.getPlainText(input), "1");
            }
        };
    }

    public static FunctionalButton createTuiButtonOn(final CommandSender sender, final String dominionName, final String oldGroupName) {
        return new FunctionalButton(Language.renameGroupInputterText.button){

            @Override
            public void function() {
                RenameGroupInputter.createOn(sender, dominionName, oldGroupName);
            }
        };
    }

    public static class RenameGroupInputterText
    extends ConfigurationPart {
        public String button = "RENAME";
        public String hint = "Enter new group name.";
        public String description = "Rename this group.";
    }
}

