/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc;

import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.Limitation;
import cn.lunadeer.dominion.doos.DominionDOO;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.VaultConnect.VaultConnect;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Asserts {
    public static void assertDominionName(String dominionName) throws DominionException, SQLException {
        if (dominionName.isEmpty()) {
            throw new DominionException(Language.assertsText.domNameShouldNotEmpty, new Object[0]);
        }
        if (dominionName.contains(" ") || dominionName.contains(".") || dominionName.contains("\u00a7")) {
            throw new DominionException(Language.assertsText.domNameInvalid, new Object[0]);
        }
        if (DominionDOO.select(dominionName) != null) {
            throw new DominionException(Language.assertsText.domNameExist, dominionName);
        }
    }

    public static void assertGroupName(@NotNull DominionDTO dominion, String groupNamePlain) throws DominionException, SQLException {
        if (groupNamePlain.isEmpty()) {
            throw new DominionException(Language.assertsText.groupNameShouldNotEmpty, new Object[0]);
        }
        if (groupNamePlain.contains(" ") || groupNamePlain.contains(".")) {
            throw new DominionException(Language.assertsText.groupNameInvalid, new Object[0]);
        }
        if (dominion.getGroups().stream().anyMatch(group -> group.getNamePlain().equals(groupNamePlain))) {
            throw new DominionException(Language.assertsText.groupNameExist, groupNamePlain);
        }
    }

    public static void assertPlayerDominionAmount(@NotNull CommandSender operator, @NotNull UUID associatedWorldUid) throws DominionException {
        if (!(operator instanceof Player)) {
            return;
        }
        Player associatedPlayer = (Player)operator;
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        CopyOnWriteArrayList<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getPlayerOwnDominionDTOs(associatedPlayer.getUniqueId());
        int allOverTheWorld = Configuration.getPlayerLimitation((Player)associatedPlayer).amountAllOverTheWorld;
        if (dominions.size() >= allOverTheWorld && allOverTheWorld >= 0) {
            throw new DominionException(Language.assertsText.exceedMaxAmount, associatedPlayer.getName(), allOverTheWorld);
        }
        World associatedWorld = Converts.toWorld(associatedWorldUid);
        int amountOfWorld = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld.getName()).amount;
        if (amountOfWorld == 0) {
            throw new DominionException(Language.assertsText.notAllowDomInWorld, associatedPlayer.getName(), associatedWorld.getName());
        }
        if (dominions.stream().filter(dom -> dom.getWorldUid().equals(associatedWorld.getUID())).count() >= (long)amountOfWorld && amountOfWorld >= 0) {
            throw new DominionException(Language.assertsText.exceedMaxAmountOfWorld, associatedPlayer.getName(), associatedWorld.getName(), amountOfWorld);
        }
    }

    public static void assertDominionSize(@NotNull CommandSender operator, @NotNull UUID associatedWorldUid, CuboidDTO cuboid) throws DominionException {
        if (!(operator instanceof Player)) {
            return;
        }
        Player associatedPlayer = (Player)operator;
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        String associatedWorld = Converts.toWorld(associatedWorldUid).getName();
        int sizeMinX = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMinX;
        if (cuboid.xLength() < (long)sizeMinX) {
            throw new DominionException(Language.assertsText.xLengthTooShort, cuboid.xLength(), sizeMinX);
        }
        int sizeMinY = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMinY;
        if (cuboid.yLength() < (long)sizeMinY) {
            throw new DominionException(Language.assertsText.yLengthTooShort, cuboid.yLength(), sizeMinY);
        }
        int sizeMinZ = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMinZ;
        if (cuboid.zLength() < (long)sizeMinZ) {
            throw new DominionException(Language.assertsText.zLengthTooShort, cuboid.zLength(), sizeMinZ);
        }
        int sizeMaxX = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMaxX;
        if (sizeMaxX > 0 && cuboid.xLength() > (long)sizeMaxX) {
            throw new DominionException(Language.assertsText.xLengthTooLong, cuboid.xLength(), sizeMaxX);
        }
        int sizeMaxY = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMaxY;
        if (sizeMaxY > 0 && cuboid.yLength() > (long)sizeMaxY) {
            throw new DominionException(Language.assertsText.yLengthTooLong, cuboid.yLength(), sizeMaxY);
        }
        int sizeMaxZ = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).sizeMaxZ;
        if (sizeMaxZ > 0 && cuboid.zLength() > (long)sizeMaxZ) {
            throw new DominionException(Language.assertsText.zLengthTooLong, cuboid.zLength(), sizeMaxZ);
        }
        int yMax = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).noHigherThan;
        if (cuboid.y2() > yMax) {
            throw new DominionException(Language.assertsText.yTooHigh, cuboid.y2(), yMax);
        }
        int yMin = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((String)associatedWorld).noLowerThan;
        if (cuboid.y1() < yMin) {
            throw new DominionException(Language.assertsText.yTooLow, cuboid.y1(), yMin);
        }
    }

    public static void assertDominionOwner(@NotNull Player associatedPlayer, @NotNull DominionDTO dominion) throws DominionException {
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        if (!dominion.getOwner().equals(associatedPlayer.getUniqueId())) {
            throw new DominionException(Language.assertsText.notOwner, dominion.getName());
        }
    }

    public static void assertDominionOwner(@NotNull CommandSender sender, @NotNull DominionDTO dominion) throws DominionException {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Asserts.assertDominionOwner(player, dominion);
        }
    }

    public static boolean checkDominionAdmin(@NotNull Player associatedPlayer, @NotNull DominionDTO dominion) {
        if (Others.bypassLimit(associatedPlayer)) {
            return true;
        }
        if (dominion.getOwner().equals(associatedPlayer.getUniqueId())) {
            return true;
        }
        MemberDTO member = CacheManager.instance.getMember(dominion, associatedPlayer);
        if (member == null) {
            return false;
        }
        GroupDTO group = CacheManager.instance.getGroup(member.getGroupId());
        if (group != null && group.getFlagValue(Flags.ADMIN).booleanValue()) {
            return true;
        }
        return member.getFlagValue(Flags.ADMIN);
    }

    public static void assertDominionAdmin(@NotNull Player associatedPlayer, @NotNull DominionDTO dominion) throws DominionException {
        if (Asserts.checkDominionAdmin(associatedPlayer, dominion)) {
            return;
        }
        throw new DominionException(Language.assertsText.notAdmin, dominion.getName());
    }

    public static void assertDominionAdmin(@NotNull CommandSender sender, @NotNull DominionDTO dominion) throws DominionException {
        if (sender instanceof Player) {
            Asserts.assertDominionAdmin((Player)sender, dominion);
        }
    }

    public static void assertWithinParent(@NotNull DominionDTO dominion, @NotNull CuboidDTO cuboid) throws Exception {
        if (dominion.getParentDomId() != -1) {
            DominionDOO parent = DominionDOO.select(dominion.getParentDomId());
            if (parent == null) {
                throw new DominionException(Language.assertsText.missingParentDom, dominion.getName());
            }
            if (!parent.getCuboid().contain(cuboid)) {
                throw new DominionException(Language.assertsText.outsideOfParentDom, dominion.getName(), parent.getName());
            }
        }
    }

    public static void assertSubDepth(@NotNull CommandSender operator, @NotNull DominionDTO dominion) throws DominionException {
        if (!(operator instanceof Player)) {
            return;
        }
        Player associatedPlayer = (Player)operator;
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        int limitDepth = Configuration.getPlayerLimitation((Player)associatedPlayer).getWorldSettings((UUID)dominion.getWorldUid()).maxSubDominionDepth;
        if (limitDepth == -1) {
            return;
        }
        int level = 0;
        DominionDTO parent = dominion;
        while (parent.getParentDomId() != -1) {
            if ((parent = CacheManager.instance.getDominion(parent.getParentDomId())) == null) {
                throw new DominionException(Language.assertsText.missingParentDom, dominion.getName());
            }
            ++level;
        }
        if (level > limitDepth) {
            throw new DominionException(Language.assertsText.subDomTooDeep, associatedPlayer.getName(), limitDepth);
        }
    }

    public static void assertContainSubs(@NotNull DominionDTO dominion, @NotNull CuboidDTO cuboid) throws DominionException {
        List<DominionDTO> children = CacheManager.instance.getCache().getDominionCache().getChildrenOf(dominion.getId());
        for (DominionDTO child : children) {
            if (cuboid.contain(child.getCuboid())) continue;
            throw new DominionException(Language.assertsText.cantContainChild, dominion.getName(), child.getName());
        }
    }

    public static void assertDominionIntersect(@NotNull CommandSender operator, @NotNull DominionDTO dominion, @NotNull CuboidDTO cuboid) throws DominionException {
        List<DominionDTO> dominions = CacheManager.instance.getCache().getDominionCache().getChildrenOf(dominion.getParentDomId());
        for (DominionDTO dom : dominions) {
            if (dom.getId().equals(dominion.getId()) || !dom.getWorldUid().equals(dominion.getWorldUid()) || !cuboid.intersectWith(dom.getCuboid())) continue;
            throw new DominionException(Language.assertsText.intersectWithDom, dominion.getName(), dom.getName());
        }
        if (!(operator instanceof Player)) {
            return;
        }
        Player associatedPlayer = (Player)operator;
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        int spawnProtection = Configuration.serverSpawnProtectionRadius;
        if (spawnProtection == -1) {
            return;
        }
        World world = dominion.getWorld();
        if (world == null) {
            return;
        }
        Location spawn = world.getSpawnLocation();
        CuboidDTO spawnCuboid = new CuboidDTO(spawn.getBlockX() - spawnProtection, spawn.getBlockX() + spawnProtection, spawn.getBlockY() - spawnProtection, spawn.getBlockY() + spawnProtection, spawn.getBlockZ() - spawnProtection, spawn.getBlockZ() + spawnProtection);
        if (cuboid.intersectWith(spawnCuboid)) {
            throw new DominionException(Language.assertsText.intersectWithSpawn, dominion.getName());
        }
    }

    public static void assertEconomy(@NotNull CommandSender operator, CuboidDTO before, CuboidDTO after) throws Exception {
        if (!(operator instanceof Player)) {
            return;
        }
        Player associatedPlayer = (Player)operator;
        Limitation.Economy ecoConf = Configuration.getPlayerLimitation((Player)associatedPlayer).economy;
        if (!ecoConf.enable) {
            return;
        }
        if (Others.bypassLimit(associatedPlayer)) {
            return;
        }
        long amount = ecoConf.squareOnly ? after.minusSquareWith(before) : after.minusVolumeWith(before);
        if (amount == 0L) {
            return;
        }
        double price = (double)amount * ecoConf.pricePerBlock;
        if (price > 0.0) {
            VaultConnect.instance.withdrawPlayer(associatedPlayer, price);
            Notification.info((CommandSender)associatedPlayer, Language.assertsText.withDrawMoney, price);
        } else {
            price = price * ecoConf.refundRate * -1.0;
            VaultConnect.instance.depositPlayer(associatedPlayer, price);
            Notification.info((CommandSender)associatedPlayer, Language.assertsText.depositMoney, price);
        }
    }

    public static void assertGroupBelongDominion(@NotNull GroupDTO group, @NotNull DominionDTO dominion) throws DominionException {
        if (!group.getDomID().equals(dominion.getId())) {
            throw new DominionException(Language.assertsText.groupNotBelongDominion, group.getNamePlain(), dominion.getName());
        }
    }

    public static void assertMemberBelongDominion(@NotNull MemberDTO member, @NotNull DominionDTO dominion) throws DominionException {
        if (!member.getDomID().equals(dominion.getId())) {
            throw new DominionException(Language.assertsText.groupNotBelongDominion, member.getPlayer().getLastKnownName(), dominion.getName());
        }
    }

    public static class AssertsText
    extends ConfigurationPart {
        public String domNameShouldNotEmpty = "Dominion name should not be empty.";
        public String domNameInvalid = "Dominion name should not contain space or dot.";
        public String domNameExist = "Dominion name: {0} already exists.";
        public String groupNameShouldNotEmpty = "Group name should not be empty.";
        public String groupNameInvalid = "Group name should not contain space or dot.";
        public String groupNameExist = "Group name: {0} already exists.";
        public String notAllowDomInWorld = "Player {0} is not allowed to create dominions in world {1}.";
        public String exceedMaxAmount = "Player {0} can not create more dominions (max: {1}).";
        public String exceedMaxAmountOfWorld = "Player {0} can not create more dominions in world {1} (max: {2}).";
        public String xLengthTooShort = "West-East(X) length {0} should more than {1}.";
        public String yLengthTooShort = "Down-Up(Y) length {0} should more than {1}.";
        public String zLengthTooShort = "South-North(Z) length {0} should more than {1}.";
        public String xLengthTooLong = "West-East(X) length {0} should less than {1}.";
        public String yLengthTooLong = "Down-Up(Y) length {0} should less than {1}.";
        public String zLengthTooLong = "South-North(Z) length {0} should less than {1}.";
        public String yTooHigh = "The highest point of the dominion {0} should less than {1}.";
        public String yTooLow = "The lowest point of the dominion {0} should more than {1}.";
        public String notOwner = "Only {0}'s owner can perform this command/operation.";
        public String notAdmin = "Only {0}'s admin can perform this command/operation.";
        public String intersectWithDom = "Dominion {0} intersects with dominion {1}.";
        public String intersectWithSpawn = "Dominion {0} intersects with the spawn protection area.";
        public String outsideOfParentDom = "Dominion {0} is outside of it's parent dominion {1}.";
        public String cantContainChild = "Dominion {0} can not contain it's child dominion {1}.";
        public String missingParentDom = "Parent dominion of {0} is missing.";
        public String subDomTooDeep = "Player {0} can't create sub-dominion of depth more than {1}.";
        public String withDrawMoney = "Successfully paid {0} for dominion.";
        public String depositMoney = "Successfully refunded {0} from dominion.";
        public String groupNotBelongDominion = "Group {0} does not belong to dominion {1}.";
    }
}

