/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.WorldWide;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.utils.MessageDisplay;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.NotNull;

public class Others {
    public static boolean bypassLimit(Player player) {
        return player.isOp() || player.hasPermission(Dominion.adminPermission);
    }

    public static List<DominionDTO> getSubDominionsRecursive(DominionDTO dominion) {
        ArrayList<DominionDTO> res = new ArrayList<DominionDTO>();
        List<DominionDTO> sub_dominions = CacheManager.instance.getCache().getDominionCache().getChildrenOf(dominion.getId());
        for (DominionDTO sub_dominion : sub_dominions) {
            res.add(sub_dominion);
            res.addAll(Others.getSubDominionsRecursive(sub_dominion));
        }
        return res;
    }

    public static Location[] autoPoints(Player player) {
        int size = Configuration.autoCreateRadius;
        Location location = player.getLocation();
        Location location1 = new Location(location.getWorld(), location.getX() - (double)size, location.getY() - (double)size, location.getZ() - (double)size);
        Location location2 = new Location(location.getWorld(), location.getX() + (double)size, location.getY() + (double)size, location.getZ() + (double)size);
        if (Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).autoIncludeVertical) {
            location1.setY((double)Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noLowerThan);
            location2.setY((double)(Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noHigherThan - 1));
        }
        return new Location[]{location1, location2};
    }

    public static void autoClean() {
        if (Configuration.autoCleanAfterDays == -1) {
            return;
        }
        XLogger.info(Language.othersText.autoCleanStart, Configuration.autoCleanAfterDays);
        int auto_clean_after_days = Configuration.autoCleanAfterDays;
        try {
            List<PlayerDTO> players = PlayerDOO.all();
            for (PlayerDTO p : players) {
                if (((PlayerDOO)p).getLastJoinAt() + (long)auto_clean_after_days * 24L * 60L * 60L * 1000L >= System.currentTimeMillis()) continue;
                try {
                    PlayerDOO.delete((PlayerDOO)p);
                }
                catch (Exception e) {
                    XLogger.error(e);
                }
                XLogger.info(Language.othersText.autoCleaningPlayer, p.getLastKnownName());
            }
        }
        catch (Exception e) {
            XLogger.error(e);
        }
        XLogger.info(Language.othersText.autoCleanEnd);
    }

    public static boolean checkPrivilegeFlag(@NotNull Location location, @NotNull PriFlag flag, @NotNull Player player, @Nullable Cancellable event) {
        if (Others.checkPrivilegeFlagSilence(location, flag, player, event)) {
            return true;
        }
        Object msg = Misc.formatString(Language.othersText.noPermissionForFlag, flag.getDisplayName(), flag.getDescription());
        msg = "&4&l" + (String)msg;
        MessageDisplay.show(player, MessageDisplay.Place.valueOf(Configuration.pluginMessage.noPermissionDisplayPlace.toUpperCase()), (String)msg);
        return false;
    }

    public static boolean checkPrivilegeFlagSilence(@NotNull Location location, @NotNull PriFlag flag, @NotNull Player player, @Nullable Cancellable event) {
        boolean hasPrivilege;
        if (!flag.getEnable().booleanValue()) {
            return true;
        }
        DominionDTO dom = CacheManager.instance.getDominion(location);
        if (dom == null) {
            if (!WorldWide.isWorldWideEnabled(location.getWorld()) || Others.bypassLimit(player)) {
                return true;
            }
            hasPrivilege = WorldWide.getGuestFlagValue(location.getWorld(), flag);
        } else {
            if (Asserts.checkDominionAdmin(player, dom)) {
                return true;
            }
            MemberDTO member = CacheManager.instance.getMember(dom, player);
            if (member != null) {
                GroupDTO group = CacheManager.instance.getGroup(member.getGroupId());
                hasPrivilege = member.getGroupId() != -1 && group != null ? group.getFlagValue(flag) : member.getFlagValue(flag);
            } else {
                hasPrivilege = dom.getGuestPrivilegeFlagValue().get(flag);
            }
        }
        if (hasPrivilege) {
            return true;
        }
        if (event != null) {
            event.setCancelled(true);
        }
        return false;
    }

    public static boolean checkEnvironmentFlag(@NotNull Location location, @NotNull EnvFlag flag, @Nullable Cancellable event) {
        boolean enabled;
        if (!flag.getEnable().booleanValue()) {
            return true;
        }
        DominionDTO dom = CacheManager.instance.getDominion(location);
        if (dom == null) {
            if (!WorldWide.isWorldWideEnabled(location.getWorld())) {
                return true;
            }
            enabled = WorldWide.getEnvFlagValue(location.getWorld(), flag);
        } else {
            enabled = dom.getEnvironmentFlagValue().getOrDefault(flag, false);
        }
        if (!enabled && event != null) {
            event.setCancelled(true);
        }
        return enabled;
    }

    public static boolean isInDominion(@Nullable DominionDTO dominion, @NotNull Location location) {
        if (dominion == null) {
            return false;
        }
        if (!Objects.equals(dominion.getWorldUid(), location.getWorld().getUID())) {
            return false;
        }
        return dominion.getCuboid().contain(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static void lightOrNot(@NotNull Player player, @Nullable DominionDTO dominion) {
        if (!Flags.GLOW.getEnable().booleanValue()) {
            return;
        }
        if (dominion == null) {
            player.setGlowing(false);
            return;
        }
        MemberDTO member = CacheManager.instance.getCache().getMemberCache().getMember(dominion, player);
        if (member != null) {
            if (member.getGroupId() == -1) {
                player.setGlowing(member.getFlagValue(Flags.GLOW).booleanValue());
            } else {
                GroupDTO group = CacheManager.instance.getCache().getGroupCache().getGroup(member.getGroupId());
                if (group != null) {
                    player.setGlowing(group.getFlagValue(Flags.GLOW).booleanValue());
                } else {
                    player.setGlowing(dominion.getGuestPrivilegeFlagValue().get(Flags.GLOW).booleanValue());
                }
            }
        } else {
            player.setGlowing(dominion.getGuestPrivilegeFlagValue().get(Flags.GLOW).booleanValue());
        }
    }

    public static void flyOrNot(@NotNull Player player, @Nullable DominionDTO dominion) {
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            if (player.isOp()) {
                player.setAllowFlight(true);
            }
            return;
        }
        if (player.isOp()) {
            return;
        }
        for (String flyPN : Configuration.flyPermissionNodes) {
            if (!player.hasPermission(flyPN)) continue;
            return;
        }
        if (!Flags.FLY.getEnable().booleanValue()) {
            player.setAllowFlight(false);
            return;
        }
        if (dominion == null) {
            player.setAllowFlight(false);
            return;
        }
        if (dominion.getOwner().equals(player.getUniqueId())) {
            player.setAllowFlight(true);
            return;
        }
        MemberDTO member = CacheManager.instance.getCache().getMemberCache().getMember(dominion, player);
        if (member != null) {
            if (member.getGroupId() == -1) {
                player.setAllowFlight(member.getFlagValue(Flags.FLY).booleanValue());
            } else {
                GroupDTO group = CacheManager.instance.getCache().getGroupCache().getGroup(member.getGroupId());
                if (group != null) {
                    player.setAllowFlight(group.getFlagValue(Flags.FLY).booleanValue());
                } else {
                    player.setAllowFlight(dominion.getGuestPrivilegeFlagValue().get(Flags.FLY).booleanValue());
                }
            }
        } else {
            player.setAllowFlight(dominion.getGuestPrivilegeFlagValue().get(Flags.FLY).booleanValue());
        }
    }

    public static boolean isExplodeEntity(@NotNull Entity entity) {
        return entity.getType() == EntityType.CREEPER || entity.getType() == EntityType.WITHER_SKULL || entity.getType() == EntityType.FIREBALL || entity.getType() == EntityType.ENDER_CRYSTAL || entity.getType() == EntityType.SMALL_FIREBALL || entity.getType() == EntityType.DRAGON_FIREBALL;
    }

    public static Location[] sortLocations(@NotNull Location location1, @NotNull Location location2) {
        int minX = Math.min(location1.getBlockX(), location2.getBlockX());
        int minY = Math.min(location1.getBlockY(), location2.getBlockY());
        int minZ = Math.min(location1.getBlockZ(), location2.getBlockZ());
        int maxX = Math.max(location1.getBlockX(), location2.getBlockX()) + 1;
        int maxY = Math.max(location1.getBlockY(), location2.getBlockY()) + 1;
        int maxZ = Math.max(location1.getBlockZ(), location2.getBlockZ()) + 1;
        return new Location[]{new Location(location1.getWorld(), (double)minX, (double)minY, (double)minZ), new Location(location1.getWorld(), (double)maxX, (double)maxY, (double)maxZ)};
    }

    public static class OthersText
    extends ConfigurationPart {
        public String autoCleanStart = "Start auto clean players who have not logged in for {0} days.";
        public String autoCleaningPlayer = "Cleaned {0}'s data.";
        public String autoCleanEnd = "Auto clean finished.";
        public String noPermissionForFlag = "&4&lYou do not have {0}({1}) permission.";
    }
}

