/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.command;

import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.Suggestion;
import java.util.List;

public class Option
extends Argument {
    private final List<String> options;

    public Option(List<String> options) {
        super(options.get(0), true);
        this.options = options;
    }

    public Option(List<String> options, String defaultValue) {
        super(options.get(0), false);
        this.options = options;
        this.setValue(defaultValue);
    }

    @Override
    public Suggestion getSuggestion() {
        return commandSender -> this.options;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRequired()) {
            sb.append("<");
        } else {
            sb.append("[");
        }
        for (int i = 0; i < this.options.size(); ++i) {
            sb.append(this.options.get(i));
            if (i == this.options.size() - 1) continue;
            sb.append("|");
        }
        if (this.isRequired()) {
            sb.append(">");
        } else {
            sb.append("]");
        }
        return sb.toString();
    }

    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public Option copy() {
        Option copy = new Option(this.options, this.getValue());
        copy.setValue(this.getValue());
        return copy;
    }
}

