/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.events.dominion.DominionCreateEvent;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DominionCreateCommand {
    public static SecondaryCommand create = new SecondaryCommand("create", (List)List.of(new Argument("name", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                Player player = Converts.toPlayer(sender);
                World world = player.getWorld();
                Location[] points = Converts.getSelectedPoints(player);
                CuboidDTO cuboidDTO = new CuboidDTO(points[0], points[1]);
                new DominionCreateEvent(sender, this.getArgumentValue(0), player.getUniqueId(), world, cuboidDTO, null).call();
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand createSub = new SecondaryCommand("create_sub", List.of(new Argument("name", true), new CommandArguments.RequiredDominionArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                Player player = Converts.toPlayer(sender);
                World world = player.getWorld();
                Location[] points = Converts.getSelectedPoints(player);
                CuboidDTO cuboidDTO = new CuboidDTO(points[0], points[1]);
                new DominionCreateEvent(sender, this.getArgumentValue(0), player.getUniqueId(), world, cuboidDTO, Converts.toDominionDTO(this.getArgumentValue(1))).call();
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand autoCreate = new SecondaryCommand("auto_create", (List)List.of(new Argument("name", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionCreateCommand.autoCreate(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand autoCreateSub = new SecondaryCommand("auto_create_sub", List.of(new Argument("name", true), new CommandArguments.RequiredDominionArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                Player player = Converts.toPlayer(sender);
                World world = player.getWorld();
                Location[] points = Others.autoPoints(player);
                CuboidDTO cuboidDTO = new CuboidDTO(points[0], points[1]);
                new DominionCreateEvent(sender, this.getArgumentValue(0), player.getUniqueId(), world, cuboidDTO, Converts.toDominionDTO(this.getArgumentValue(1))).call();
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void autoCreate(CommandSender sender, String dominionName) {
        try {
            Player player = Converts.toPlayer(sender);
            World world = player.getWorld();
            Location[] points = Others.autoPoints(player);
            CuboidDTO cuboidDTO = new CuboidDTO(points[0], points[1]);
            new DominionCreateEvent(sender, dominionName, player.getUniqueId(), world, cuboidDTO, null).call();
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }
}

