/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.events;

import cn.lunadeer.dominion.events.HighestVersion;
import cn.lunadeer.dominion.events.LowestVersion;
import cn.lunadeer.dominion.events.PaperOnly;
import cn.lunadeer.dominion.events.SpigotOnly;
import cn.lunadeer.dominion.handler.DominionEventHandler;
import cn.lunadeer.dominion.handler.GroupEventHandler;
import cn.lunadeer.dominion.handler.MemberEventHandler;
import cn.lunadeer.dominion.handler.SelectPointEventsHandler;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.XVersionManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EventsRegister {
    private final JavaPlugin plugin;
    public XVersionManager.ImplementationVersion version;
    public Implementation implementation;

    public EventsRegister(JavaPlugin plugin) {
        this.plugin = plugin;
        this.version = XVersionManager.VERSION;
        this.implementation = Misc.isPaper() ? Implementation.PAPER : Implementation.SPIGOT;
        try {
            XLogger.debug("Load API version: {0}:{1}", this.implementation.name().toLowerCase(), this.version.name());
            this.registerVersion();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            XLogger.error("Failed to register events: {0}", e.getMessage());
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
        }
        new DominionEventHandler(plugin);
        new MemberEventHandler(plugin);
        new GroupEventHandler(plugin);
        new SelectPointEventsHandler(plugin);
    }

    public void registerEvents(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        LowestVersion lowestVersion;
        HighestVersion highestVersion;
        Class<?> clazz = Class.forName(className);
        if (!Listener.class.isAssignableFrom(clazz)) {
            return;
        }
        if (this.implementation == Implementation.PAPER && clazz.isAnnotationPresent(SpigotOnly.class)) {
            XLogger.debug("Skipping {0} because it is Spigot only", className);
            return;
        }
        if (this.implementation == Implementation.SPIGOT && clazz.isAnnotationPresent(PaperOnly.class)) {
            XLogger.debug("Skipping {0} because it is Paper only", className);
            return;
        }
        if (clazz.isAnnotationPresent(HighestVersion.class) && (highestVersion = clazz.getAnnotation(HighestVersion.class)).value().compareWith(this.version) < 0) {
            XLogger.debug("Skipping {0} because it is for a lower version", className);
            return;
        }
        if (clazz.isAnnotationPresent(LowestVersion.class) && (lowestVersion = clazz.getAnnotation(LowestVersion.class)).value().compareWith(this.version) > 0) {
            XLogger.debug("Skipping {0} because it is for a higher version", className);
            return;
        }
        Listener listener = (Listener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    public void registerPackageEvents(String packageName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        List<String> classesInPackage = Misc.listClassOfPackage(this.plugin, packageName);
        for (String className : classesInPackage) {
            XLogger.debug("Registering event: {0}", className);
            this.registerEvents(className);
        }
    }

    private void registerVersion() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        for (XVersionManager.ImplementationVersion v : XVersionManager.ImplementationVersion.values()) {
            String packageName = "cn.lunadeer.dominion." + v.name() + ".";
            this.registerPackageEvents(packageName + "events.player");
            this.registerPackageEvents(packageName + "events.environment");
        }
    }

    public static enum Implementation {
        SPIGOT,
        PAPER;

    }
}

