/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.MigrationCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.ResMigration;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MigrateList {
    public static SecondaryCommand migrateList = new SecondaryCommand("migrate_list", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                MigrateList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.migrateListText.button){

            @Override
            public void function(String pageStr) {
                MigrateList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(CommandSender sender, String pageStr) {
        try {
            if (!Configuration.residenceMigration) {
                Notification.error(sender, Language.migrateListText.notEnabled);
                return;
            }
            Player player = Converts.toPlayer(sender);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, MigrateList.button(sender));
            view.title(Language.migrateListText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.migrateListText.button));
            List<ResMigration.ResidenceNode> res_data = player.hasPermission(Dominion.adminPermission) ? CacheManager.instance.getResidenceCache().getResidenceData() : CacheManager.instance.getResidenceCache().getResidenceData(player.getUniqueId());
            if (res_data == null) {
                view.add(Line.create().append(Language.migrateListText.noData));
            } else {
                view.addLines(MigrateList.BuildTreeLines(sender, res_data, 0, page));
            }
            view.showOn((CommandSender)player, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static List<Line> BuildTreeLines(CommandSender sender, List<ResMigration.ResidenceNode> dominionTree, Integer depth, int page) {
        ArrayList<Line> lines = new ArrayList<Line>();
        StringBuilder prefix = new StringBuilder();
        prefix.append(" | ".repeat(Math.max(0, depth)));
        for (ResMigration.ResidenceNode node : dominionTree) {
            ListViewButton migrate = MigrationCommand.button(sender, node.name);
            Line line = Line.create();
            if (depth == 0) {
                line.append(migrate.build());
            } else {
                line.append(migrate.setDisabled(Language.migrateListText.cantMigrate).build());
            }
            line.append(String.valueOf(prefix) + node.name);
            lines.add(line);
            lines.addAll(MigrateList.BuildTreeLines(sender, node.children, depth + 1, page));
        }
        return lines;
    }

    public static class MigrateListText
    extends ConfigurationPart {
        public String title = "Migrate From Residence";
        public String description = "Migrate residence data to dominion.";
        public String button = "MIGRATE";
        public String notEnabled = "Residence migration is not enabled.";
        public String noData = "No data to migrate.";
        public String cantMigrate = "Sub-residence will be migrated with the parent.";
    }
}

